/*
 * MemoryHighscore.java
 *
 * Created on 5. Dezember 2003, 19:18
 */

import java.applet.AppletContext;
import java.awt.*;
import java.awt.event.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;
import java.io.*;
import java.net.*;


/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryHighscore extends Frame {
    
    private AppletContext m_appletcontext;
    private Image m_imageUrlCat;
    private Memory m_memory;
    private MemoryImageButton m_imageButtonCat;
    private String m_strPicturePath;
    
    /** Creates new form MemoryHighscore */
    public MemoryHighscore(AppletContext appletcontext, Image imageUrlCat) {
        super("Memory Highscore");
        m_appletcontext = appletcontext;
        m_imageUrlCat = imageUrlCat;
        setBackground(new java.awt.Color(0xFFFF99));
        initComponents();
        setSize(460, 350);
        setLocation(20, 20);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        java.awt.Label labelURL;

        m_canvasPic = new MemoryCatPicture(m_imageUrlCat);
        labelURL = new java.awt.Label();
        m_listHighscore = new java.awt.List();
        m_buttonOk = new java.awt.Button();

        setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        m_canvasPic.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                m_canvasPicMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                m_canvasPicMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                m_canvasPicMouseExited(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 2);
        add(m_canvasPic, gridBagConstraints);

        labelURL.setFont(new java.awt.Font("Dialog", 1, 24));
        labelURL.setText("Memory by Markus Eichenberger");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(labelURL, gridBagConstraints);

        m_listHighscore.setFont(new java.awt.Font("Monospaced", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(m_listHighscore, gridBagConstraints);

        m_buttonOk.setLabel("Close");
        m_buttonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_buttonOkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(m_buttonOk, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /** Pointer entered cat picture */
    private void m_canvasPicMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_m_canvasPicMouseEntered
        setCursor(new Cursor(Cursor.HAND_CURSOR));
    }//GEN-LAST:event_m_canvasPicMouseEntered
    
    /** Pointer exited cat picture */
    private void m_canvasPicMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_m_canvasPicMouseExited
        setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_m_canvasPicMouseExited
    
    /** Cat picture clicked */
    private void m_canvasPicMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_m_canvasPicMouseClicked
        try {
            URL url = new URL("http://mypage.bluewin.ch/katzenseite/index_en.html");
            m_appletcontext.showDocument(url, "_blank");
        }
        catch(MalformedURLException e) {
            m_appletcontext.showStatus(e.getMessage());
        }
    }//GEN-LAST:event_m_canvasPicMouseClicked
    
    /** Close button */
    private void m_buttonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_m_buttonOkActionPerformed
        this.setVisible(false);
    }//GEN-LAST:event_m_buttonOkActionPerformed
    
    /** Hide this form */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        this.setVisible(false);
    }//GEN-LAST:event_exitForm
    
    /** Paint this container */
    public void paint(java.awt.Graphics g) {
        super.paint(g);
    }
    
    /** List highscore from cookies */
    public void listHighscore(Vector vectorHighscore) {
        m_listHighscore.removeAll();
        m_listHighscore.add(new MemoryScoreEntry().getFormatedHeader());
        for(Enumeration e = vectorHighscore.elements(); e.hasMoreElements();) {
            MemoryScoreEntry mse = (MemoryScoreEntry)e.nextElement();
            m_listHighscore.add(mse.getFormatedScore());
        }
    }
    
    /** List highscore from stream */
    public void listHighscore(URL url) {
        m_listHighscore.removeAll();
        m_listHighscore.add(new MemoryScoreEntry().getFormatedHeader());
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String strLine;
            while((strLine = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(strLine, "\t");
                if(st.countTokens() == 6) {
                    int nPoints = Integer.parseInt(st.nextToken());
                    String strName = st.nextToken();
                    int nTime = Integer.parseInt(st.nextToken());
                    int nAttempts = Integer.parseInt(st.nextToken());
                    int nLevel = Integer.parseInt(st.nextToken());
                    String strDate = st.nextToken();
                    MemoryScoreEntry mse = new MemoryScoreEntry(nPoints, strName, nTime, nAttempts, nLevel, strDate);
                    m_listHighscore.add(mse.getFormatedScore());
                }
            }
            in.close();
        }
        catch(Exception e) {
            m_appletcontext.showStatus(e.getMessage());
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button m_buttonOk;
    private java.awt.Canvas m_canvasPic;
    private java.awt.List m_listHighscore;
    // End of variables declaration//GEN-END:variables
    
}
