/*
 * MemoryCookieWrapper.java
 *
 * Created on 6. Dezember 2003, 23:28
 */

import java.util.*;
import netscape.javascript.JSObject;

/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryCookieWrapper {
    
    private Memory m_memory;
    private boolean m_bCookies = false;
    
    /** Creates a new instance of MemoryCookieWrapper */
    public MemoryCookieWrapper(Memory memory) {
        m_memory = memory;
        checkForCookies();
    }
    
    /** Check for access cookies */
    private void checkForCookies() {
        m_bCookies = false;
        try {
            //Class.forName("JSObject");
            java.lang.Class.forName("netscape.javascript.JSObject");
            JSObject browserWindow = JSObject.getWindow(m_memory);
            Object args[] = new Object[1];
            args[0] = this;
            browserWindow.call("jsCheckForCookies", args);
        }
        catch(Exception e) {
            System.err.println("Class " + e.getMessage() + " does not exists");
            m_bCookies = false;
        }
    }
    
    /** Callback for JavaScript to enable or disable cookies */
    public void cbSetCookiesEnabled(boolean bCookies) {
        m_bCookies = bCookies;
    }
    
    /** Return true if cookies enabled, otherwise false */
    public boolean cookiesEnabled() {
        return m_bCookies;
    }
    
    /** Set cookie */
    public void setCookie(String strId, String strValue) {
        if(m_bCookies) {
            JSObject browserWindow = JSObject.getWindow(m_memory);
            Object args[] = new Object[2];
            args[0] = strId;
            args[1] = strValue;
            browserWindow.call("jsSetCookie", args);
        }
    }
    
    /** Get cookie */
    public void getCookie(String strId) {
        if(m_bCookies) {
            JSObject browserWindow = JSObject.getWindow(m_memory);
            Object args[] = new Object[2];
            args[0] = this;
            args[1] = strId;
            browserWindow.call("jsGetCookie", args);
        }
        
    }
    
    /** Callback for JavaScript to add the cookie to highscore  */
    public void cbAddScore(String strScore) {
        StringTokenizer st = new StringTokenizer(strScore, ";");
        if(st.countTokens() == 6) {
            try {
                MemoryScoreEntry mse = new MemoryScoreEntry(
                Integer.parseInt(st.nextToken()),
                st.nextToken(),
                Integer.parseInt(st.nextToken()),
                Integer.parseInt(st.nextToken()),
                Integer.parseInt(st.nextToken()),
                st.nextToken());
                m_memory.addToHighscore(mse);
            }
            catch(NumberFormatException e) { }
        }
    }
}
