/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MemoryHighscore
extends Frame {
    private AppletContext m_appletcontext;
    private Image m_imageUrlCat;
    private Memory m_memory;
    private MemoryImageButton m_imageButtonCat;
    private String m_strPicturePath;
    private Button m_buttonOk;
    private Canvas m_canvasPic;
    private List m_listHighscore;

    public MemoryHighscore(AppletContext appletContext, Image image) {
        super("Memory Highscore");
        this.m_appletcontext = appletContext;
        this.m_imageUrlCat = image;
        ((Component)this).setBackground(new Color(0xFFFF99));
        this.initComponents();
        ((Component)this).setSize(460, 350);
        ((Component)this).setLocation(20, 20);
    }

    private void initComponents() {
        this.m_canvasPic = new MemoryCatPicture(this.m_imageUrlCat);
        Label label = new Label();
        this.m_listHighscore = new List();
        this.m_buttonOk = new Button();
        this.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MemoryHighscore.this.exitForm(windowEvent);
            }
        });
        this.m_canvasPic.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryHighscore.this.m_canvasPicMouseClicked(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                MemoryHighscore.this.m_canvasPicMouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                MemoryHighscore.this.m_canvasPicMouseExited(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add((Component)this.m_canvasPic, gridBagConstraints);
        label.setFont(new Font("Dialog", 1, 24));
        label.setText("Memory by Markus Eichenberger");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)label, gridBagConstraints);
        this.m_listHighscore.setFont(new Font("Monospaced", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.m_listHighscore, gridBagConstraints);
        this.m_buttonOk.setLabel("Close");
        this.m_buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryHighscore.this.m_buttonOkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.m_buttonOk, gridBagConstraints);
        this.pack();
    }

    private void m_canvasPicMouseEntered(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    private void m_canvasPicMouseExited(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(0));
    }

    private void m_canvasPicMouseClicked(MouseEvent mouseEvent) {
        try {
            URL uRL = new URL("http://mypage.bluewin.ch/katzenseite/index_en.html");
            this.m_appletcontext.showDocument(uRL, "_blank");
        }
        catch (MalformedURLException malformedURLException) {
            this.m_appletcontext.showStatus(malformedURLException.getMessage());
        }
    }

    private void m_buttonOkActionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
    }

    private void exitForm(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void listHighscore(Vector vector) {
        this.m_listHighscore.removeAll();
        this.m_listHighscore.add(new MemoryScoreEntry().getFormatedHeader());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MemoryScoreEntry memoryScoreEntry = (MemoryScoreEntry)enumeration.nextElement();
            this.m_listHighscore.add(memoryScoreEntry.getFormatedScore());
        }
    }

    public void listHighscore(URL uRL) {
        this.m_listHighscore.removeAll();
        this.m_listHighscore.add(new MemoryScoreEntry().getFormatedHeader());
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (stringTokenizer.countTokens() != 6) continue;
                int n = Integer.parseInt(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                String string3 = stringTokenizer.nextToken();
                MemoryScoreEntry memoryScoreEntry = new MemoryScoreEntry(n, string2, n2, n3, n4, string3);
                this.m_listHighscore.add(memoryScoreEntry.getFormatedScore());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.m_appletcontext.showStatus(exception.getMessage());
        }
    }
}

