/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Memory
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener {
    private Thread m_thread = null;
    private MemoryImageContainer m_imageContainer;
    private MemoryImageButtonContainer m_imageButtonContainer;
    private MemoryImageFieldContainer m_imageFieldContainer;
    private MemoryNumberDisplay m_memoryNumberDisplayLevel;
    private MemoryNumberDisplay m_memoryNumberDisplaySeconds;
    private MemoryNumberDisplay m_memoryNumberDisplayAttempts;
    private MemoryNumberDisplay m_memoryNumberDisplayHits;
    private MediaTracker m_mediaTracker;
    private String m_strPicturePath = "./images/";
    private String m_strSoundPath = "./sounds/";
    private int m_nLevel = 4;
    private int m_nSeconds = 0;
    private int m_nAttempts = 0;
    private int m_nHits = 0;
    private int m_nPoints = 0;
    private int m_nHighscore = 0;
    private boolean m_bTimeout = false;
    private MemoryPreloader m_fPreloader;
    private MemoryPlayerName m_fPlayerName;
    private MemoryHighscore m_fHighscore;
    private MemoryImageButton m_imageButtonCat;
    private AudioClip m_soundTurncard;
    private AudioClip m_soundDontmatch;
    private AudioClip m_soundMatch;
    private AudioClip m_soundGameover;
    private String m_strPlayerName = "xxx";
    private Vector m_vectorHighscore;
    private MemoryCookieWrapper m_cookieWrapper;
    private boolean m_bPhpHighscore = false;
    private String m_strPhpSaveScore = "save_score.php";
    private String m_strPhpGetScore = "get_score.php";

    public void init() {
        this.setCursor(new Cursor(3));
        this.m_imageContainer = new MemoryImageContainer();
        this.m_imageButtonContainer = new MemoryImageButtonContainer();
        this.m_imageFieldContainer = new MemoryImageFieldContainer();
        this.showStatus("Initialize memory applet ...");
        this.initComponents();
        this.setBackground(new Color(0xFFFF99));
        this.m_fPreloader = new MemoryPreloader();
        Dimension dimension = this.getToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.m_fPreloader.getBounds();
        int n = (dimension.width - rectangle2.width) / 2;
        int n2 = (dimension.height - rectangle2.height) / 2;
        ((Component)this.m_fPreloader).setLocation(n, n2);
        ((Component)this.m_fPreloader).setVisible(true);
        this.m_fPreloader.m_lblPreloader.setText("Loading sound files ...");
        this.m_soundTurncard = this.getAudioClip(this.getCodeBase(), this.m_strSoundPath + "turncard.au");
        this.m_soundDontmatch = this.getAudioClip(this.getCodeBase(), this.m_strSoundPath + "dontmatch.au");
        this.m_soundMatch = this.getAudioClip(this.getCodeBase(), this.m_strSoundPath + "match.au");
        this.m_soundGameover = this.getAudioClip(this.getCodeBase(), this.m_strSoundPath + "gameover.au");
        this.m_mediaTracker = new MediaTracker(this);
        if (this.getParameter("picturepath") != null) {
            this.m_strPicturePath = this.getParameter("picturepath");
        }
        if (this.getParameter("soundpath") != null) {
            this.m_strSoundPath = this.getParameter("soundpath");
        }
        if (this.getParameter("highscore") != null && this.getParameter("highscore").equals("php")) {
            this.m_bPhpHighscore = true;
        }
        if (this.getParameter("get_score") != null) {
            this.m_strPhpGetScore = this.getParameter("get_score");
        }
        if (this.getParameter("save_score") != null) {
            this.m_strPhpSaveScore = this.getParameter("save_score");
        }
        this.m_fPreloader.m_lblPreloader.setText("Loading cat pictures ...");
        Image image = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "10.gif");
        this.m_mediaTracker.addImage(image, 0);
        Image image2 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "card.jpg");
        this.m_mediaTracker.addImage(image2, 0);
        Image image3 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic1.jpg");
        this.m_mediaTracker.addImage(image3, 0);
        Image image4 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic2.jpg");
        this.m_mediaTracker.addImage(image4, 0);
        Image image5 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic3.jpg");
        this.m_mediaTracker.addImage(image5, 0);
        Image image6 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic4.jpg");
        this.m_mediaTracker.addImage(image6, 0);
        Image image7 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic5.jpg");
        this.m_mediaTracker.addImage(image7, 0);
        Image image8 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic6.jpg");
        this.m_mediaTracker.addImage(image8, 0);
        Image image9 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic7.jpg");
        this.m_mediaTracker.addImage(image9, 0);
        Image image10 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "pic8.jpg");
        this.m_mediaTracker.addImage(image10, 0);
        Image image11 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + "urlcat.gif");
        this.m_mediaTracker.addImage(image11, 0);
        try {
            this.m_mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_fPreloader.m_lblPreloader.setText("Loading user interface ...");
        this.m_imageButtonContainer.add(this.loadImageButton("startstop1.gif", "startstop2.gif", "start", this.getSize().width - 90, 0, true));
        this.m_imageButtonContainer.add(this.loadImageButton("startstop3.gif", "startstop4.gif", "stop", this.getSize().width - 90, 38, false));
        this.m_imageContainer.add(this.loadImage("level.gif", this.getSize().width - 90, 79));
        this.m_imageButtonContainer.add(this.loadImageButton("plusminus3.gif", "plusminus4.gif", "minus", this.getSize().width - 82, 99, true));
        this.m_imageButtonContainer.add(this.loadImageButton("plusminus1.gif", "plusminus2.gif", "plus", this.getSize().width - 22, 99, true));
        this.m_imageContainer.add(this.getScaledImage(image, this.getSize().width - 90, 99, 90, 20));
        this.m_imageContainer.add(this.loadImage("time.gif", this.getSize().width - 90, 130));
        this.m_imageContainer.add(this.loadImage("s.gif", this.getSize().width - 15, 150));
        this.m_imageContainer.add(this.loadImage("attempts.gif", this.getSize().width - 90, 175));
        this.m_imageContainer.add(this.loadImage("10.gif", this.getSize().width - 15, 195));
        this.m_imageContainer.add(this.loadImage("found.gif", this.getSize().width - 90, 220));
        this.m_imageContainer.add(this.loadImage("10.gif", this.getSize().width - 15, 240));
        this.m_imageButtonContainer.add(this.loadImageButton("highscore.gif", "blank.gif", "highscore", this.getSize().width - 90, 285, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image3, "pic1", 0, 0, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image3, "pic1", 89, 0, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image4, "pic2", 178, 0, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image4, "pic2", 267, 0, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image5, "pic3", 0, 79, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image5, "pic3", 89, 79, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image6, "pic4", 178, 79, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image6, "pic4", 267, 79, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image7, "pic5", 0, 158, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image7, "pic5", 89, 158, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image8, "pic6", 178, 158, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image8, "pic6", 267, 158, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image9, "pic7", 0, 237, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image9, "pic7", 89, 237, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image10, "pic8", 178, 237, true));
        this.m_imageFieldContainer.add(this.getImageButton(image2, image10, "pic8", 267, 237, true));
        this.m_fPreloader.m_lblPreloader.setText("Loading other images ...");
        Image[] imageArray = new Image[11];
        int n3 = 0;
        while (n3 < 11) {
            imageArray[n3] = this.getImage(this.getDocumentBase(), this.m_strPicturePath + n3 + ".gif");
            this.m_mediaTracker.addImage(imageArray[n3], 1);
            ++n3;
        }
        this.m_fPreloader.m_lblPreloader.setText("Finishing loading ...");
        try {
            this.m_mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_memoryNumberDisplayLevel = new MemoryNumberDisplay(imageArray, this.getSize().width - 52, 99, 1, this.m_nLevel);
        this.m_memoryNumberDisplaySeconds = new MemoryNumberDisplay(imageArray, this.getSize().width - 90, 150, 5, this.m_nSeconds);
        this.m_memoryNumberDisplayAttempts = new MemoryNumberDisplay(imageArray, this.getSize().width - 90, 195, 5, this.m_nSeconds);
        this.m_memoryNumberDisplayHits = new MemoryNumberDisplay(imageArray, this.getSize().width - 90, 240, 5, this.m_nHits);
        this.m_fPlayerName = new MemoryPlayerName(this);
        ((Component)this.m_fPlayerName).setVisible(false);
        this.m_fHighscore = new MemoryHighscore(this.getAppletContext(), image11);
        ((Component)this.m_fHighscore).setVisible(false);
        this.m_vectorHighscore = new Vector();
        this.m_cookieWrapper = new MemoryCookieWrapper(this);
        this.loadHighscore();
        this.setCursor(new Cursor(0));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ((Component)this.m_fPreloader).setVisible(false);
    }

    public void start() {
        this.repaint();
    }

    public void stop() {
    }

    public MemoryImageButton loadImageButton(String string, String string2, String string3, int n, int n2, boolean bl) {
        Image image = this.getImage(this.getDocumentBase(), this.m_strPicturePath + string);
        Image image2 = this.getImage(this.getDocumentBase(), this.m_strPicturePath + string2);
        this.m_mediaTracker.addImage(image, 1);
        this.m_mediaTracker.addImage(image2, 1);
        return new MemoryImageButton(image, image2, string3, n, n2, bl);
    }

    public MemoryImageButton getImageButton(Image image, Image image2, String string, int n, int n2, boolean bl) {
        return new MemoryImageButton(image, image2, string, n, n2, bl);
    }

    public MemoryImage loadImage(String string, int n, int n2) {
        Image image = this.getImage(this.getDocumentBase(), this.m_strPicturePath + string);
        this.m_mediaTracker.addImage(image, 1);
        return new MemoryImage(image, n, n2);
    }

    public MemoryImage getScaledImage(Image image, int n, int n2, int n3, int n4) {
        return new MemoryImage(image.getScaledInstance(n3, n4, 2), n, n2);
    }

    private void initComponents() {
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics graphics) {
        Memory memory = this;
        synchronized (memory) {
            this.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(new Color(0x9999FF));
        graphics.fillRect(this.getSize().width - 90, 99, 90, 20);
        this.m_imageContainer.paint(graphics);
        this.m_imageButtonContainer.paint(graphics);
        this.m_imageFieldContainer.paint(graphics);
        this.m_memoryNumberDisplayLevel.paint(graphics);
        this.m_memoryNumberDisplaySeconds.paint(graphics);
        this.m_memoryNumberDisplayAttempts.paint(graphics);
        this.m_memoryNumberDisplayHits.paint(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.m_bTimeout) {
            Serializable serializable;
            String string = this.m_imageButtonContainer.getClickId(mouseEvent.getX(), mouseEvent.getY());
            String string2 = this.m_imageFieldContainer.getClickId(mouseEvent.getX(), mouseEvent.getY());
            if (string.equals("highscore") && this.m_thread == null) {
                if (!this.m_bPhpHighscore) {
                    this.sortScore();
                    this.m_fHighscore.listHighscore(this.m_vectorHighscore);
                } else {
                    try {
                        serializable = this.m_strPhpGetScore.indexOf("http:") >= 0 ? new URL(this.m_strPhpGetScore) : new URL(this.getCodeBase(), this.m_strPhpGetScore);
                        this.m_fHighscore.listHighscore((URL)serializable);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.getAppletContext().showStatus(malformedURLException.getMessage());
                    }
                }
                serializable = this.getLocationOnScreen();
                ((Component)this.m_fHighscore).setLocation(serializable.x, serializable.y - 50);
                this.m_fHighscore.show();
                this.m_fHighscore.toFront();
                this.m_fHighscore.requestFocus();
            }
            if (string.equals("start") && this.m_thread == null) {
                this.startMemory();
            }
            if (string.equals("stop") && this.m_thread != null) {
                this.m_nHits = 0;
                this.m_nAttempts = 0;
                this.m_nSeconds = 0;
                this.stopMemory();
                this.repaint();
            }
            if (string.equals("minus") && this.m_nLevel > 0) {
                this.m_memoryNumberDisplayLevel.setValue(--this.m_nLevel);
                this.m_nHits = 0;
                this.m_nAttempts = 0;
                this.m_nSeconds = 0;
                this.repaint();
            }
            if (string.equals("plus") && this.m_nLevel < 9) {
                this.m_memoryNumberDisplayLevel.setValue(++this.m_nLevel);
                this.m_nHits = 0;
                this.m_nAttempts = 0;
                this.m_nSeconds = 0;
                this.repaint();
            }
            if (string2.equals("") || this.m_thread == null) {
                // empty if block
            }
            if (!string2.equals("") && this.m_thread != null) {
                this.m_imageFieldContainer.showCard(mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
                if (this.m_imageFieldContainer.hasTwoCards()) {
                    this.m_memoryNumberDisplayAttempts.setValue(++this.m_nAttempts);
                    if (this.m_imageFieldContainer.isHit()) {
                        this.m_memoryNumberDisplayHits.setValue(++this.m_nHits);
                        if (this.m_nHits == 8) {
                            this.stopMemory();
                            this.calcPoints();
                            if (this.m_nPoints > this.m_nHighscore) {
                                this.m_nHighscore = this.m_nPoints;
                            }
                            this.m_fPlayerName.setTitle("Your score is " + this.m_nPoints + " points !");
                            serializable = this.getLocationOnScreen();
                            ((Component)this.m_fPlayerName).setLocation(serializable.x + 20, serializable.y + 20);
                            this.m_fPlayerName.show();
                            this.m_fPlayerName.m_textFieldPlayerName.requestFocus();
                            this.m_soundGameover.play();
                        } else {
                            this.m_soundMatch.play();
                        }
                    } else {
                        serializable = this;
                        synchronized (serializable) {
                            new MemoryTimer(2000 - this.m_nLevel * 200, this);
                            this.m_bTimeout = true;
                            this.m_soundDontmatch.play();
                        }
                    }
                }
            }
        }
    }

    private void startMemory() {
        this.m_imageButtonContainer.setActive("start", false);
        this.m_imageButtonContainer.setActive("stop", true);
        this.m_imageButtonContainer.setActive("minus", false);
        this.m_imageButtonContainer.setActive("plus", false);
        this.m_nAttempts = 0;
        this.m_memoryNumberDisplayAttempts.setValue(this.m_nAttempts);
        this.m_nHits = 0;
        this.m_memoryNumberDisplayHits.setValue(this.m_nHits);
        this.m_imageFieldContainer.hideAllCards();
        this.m_imageFieldContainer.shuffle();
        this.m_nPoints = 0;
        this.repaint();
        this.m_nSeconds = 0;
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    private void stopMemory() {
        this.m_thread = null;
        this.m_imageButtonContainer.setActive("start", true);
        this.m_imageButtonContainer.setActive("stop", false);
        this.m_imageButtonContainer.setActive("minus", true);
        this.m_imageButtonContainer.setActive("plus", true);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = this.m_imageButtonContainer.hasFocus(mouseEvent.getX(), mouseEvent.getY());
        boolean bl2 = this.m_imageFieldContainer.hasFocus(mouseEvent.getX(), mouseEvent.getY());
        if (bl || bl2) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"picturepath", "path", "Path to pictures"}, {"soundpath", "path", "Path to sounds"}, {"highscore", "string", "\"php\" to activate the PHP highscore"}, {"save_score", "url", "PHP script to save the highscore"}, {"show_score", "url", "PHP script to print out the highscore"}};
        return stringArray;
    }

    public String getAppletInfo() {
        return "Memory Applet 2002-2004 by Markus Eichenberger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.m_thread == thread) {
            Memory memory = this;
            synchronized (memory) {
                this.m_memoryNumberDisplaySeconds.setValue(++this.m_nSeconds);
            }
            this.repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public synchronized void timeExpired() {
        this.m_imageFieldContainer.hideSelectedCards();
        this.repaint();
        this.m_bTimeout = false;
    }

    private void drawHighscore(Graphics graphics) {
        graphics.setColor(new Color(0x9999FF));
        graphics.fillRect(this.getSize().width - 90, 262, 90, 48);
        graphics.setColor(Color.white);
        graphics.setFont(new Font("SansSerif", 0, 12));
        graphics.drawString("Points:", 365, 275);
        graphics.drawString("Player:", 365, 290);
        graphics.drawString("Top 1:", 365, 305);
        graphics.drawString("" + this.m_nPoints + "", 410, 290);
        graphics.drawString("" + this.m_nHighscore + "", 410, 305);
    }

    private void calcPoints() {
        this.m_nPoints = Math.round(100000 * (this.m_nLevel + 1) / this.m_nSeconds / this.m_nAttempts);
    }

    public void setPlayerName(String string) {
        this.m_strPlayerName = string;
    }

    public void addScore() {
        MemoryScoreEntry memoryScoreEntry = new MemoryScoreEntry(this.m_nPoints, this.m_strPlayerName, this.m_nSeconds, this.m_nAttempts, this.m_nLevel, "");
        if (!this.m_bPhpHighscore) {
            this.m_vectorHighscore.addElement(memoryScoreEntry);
            this.sortScore();
            this.saveHighscore();
            this.m_fHighscore.listHighscore(this.m_vectorHighscore);
        } else {
            try {
                URL uRL = this.m_strPhpSaveScore.indexOf("http:") >= 0 ? new URL(this.m_strPhpSaveScore + memoryScoreEntry.getURLScore()) : new URL(this.getCodeBase(), this.m_strPhpSaveScore + memoryScoreEntry.getURLScore());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.getAppletContext().showStatus(exception.getMessage());
            }
        }
    }

    public void sortScore() {
        int n = this.m_vectorHighscore.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = 0;
            while (n3 < n - 1) {
                int n4;
                int n5 = ((MemoryScoreEntry)this.m_vectorHighscore.elementAt(n3)).getPoints();
                if (n5 < (n4 = ((MemoryScoreEntry)this.m_vectorHighscore.elementAt(n3 + 1)).getPoints())) {
                    MemoryScoreEntry memoryScoreEntry = (MemoryScoreEntry)this.m_vectorHighscore.elementAt(n3);
                    this.m_vectorHighscore.setElementAt((MemoryScoreEntry)this.m_vectorHighscore.elementAt(n3 + 1), n3);
                    this.m_vectorHighscore.setElementAt(memoryScoreEntry, n3 + 1);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void addToHighscore(MemoryScoreEntry memoryScoreEntry) {
        this.m_vectorHighscore.addElement(memoryScoreEntry);
    }

    public void saveHighscore() {
        int n = 0;
        Enumeration enumeration = this.m_vectorHighscore.elements();
        while (enumeration.hasMoreElements()) {
            MemoryScoreEntry memoryScoreEntry = (MemoryScoreEntry)enumeration.nextElement();
            String string = "Score" + n++;
            String string2 = memoryScoreEntry.getCookieScore();
            if (!this.m_cookieWrapper.cookiesEnabled() || n > 10) continue;
            this.m_cookieWrapper.setCookie(string, string2);
        }
    }

    public void loadHighscore() {
        this.m_vectorHighscore.removeAllElements();
        int n = 0;
        while (n < 10) {
            if (this.m_cookieWrapper.cookiesEnabled()) {
                this.m_cookieWrapper.getCookie("Score" + n);
            }
            ++n;
        }
    }
}

