import java.awt.*;
import java.util.StringTokenizer;

public class AnimLignes extends java.applet.Applet implements Runnable
{
	// On cree un Thread pour l'Applet
	Thread runner;

	// Taille de l'ecran
	int width;
	int height;	
	
	// Position des points des lignes
	int xpos1;
	int ypos1;
	int xpos2;
	int ypos2;
	int colorNum = 0;
	
	// Couleur du fond
	Color bgColor;
	
	// Pour le double buffering
	Image offscreenImg;
	Graphics offscreenG;
	
	// Temps d'attente entre 2 plans
	int timeSleep;
	
	// Le pas en pixel entre 2 traits
	int step;
	
	// Marge sur les bords
	int margin = 10;

	// Pour la gestion des couleurs RGB
    String rgbDelimiter = ":,.";
    StringTokenizer st;

	
	public void init()
	{
		String s;
		Integer intObj;

		// Pour obtenir la taille de l'Applet en pixels.
        try
        {
            intObj = new Integer(getParameter("width"));
            width = intObj.intValue();
        } 
        catch (Exception e)
        {
            width = 300;
        }

        try
        {
            intObj = new Integer(getParameter("height"));
            height = intObj.intValue();
        }
        catch (Exception e)
        {
            height = 100;
        }

        try
        {
            intObj = new Integer(getParameter("step"));
            step = intObj.intValue();
        }
        catch (Exception e)
        {
            step = 5;
        }

        try
        {
            intObj = new Integer(getParameter("timeSleep"));
            timeSleep = intObj.intValue();
        }
        catch (Exception e)
        {
            timeSleep = 40;
        }


        s = getParameter("bgColor");
        if (s != null) st = new StringTokenizer(s, rgbDelimiter);

        if (s == null)
            bgColor = Color.lightGray;
        else if (s.equalsIgnoreCase("white"))
            bgColor = Color.white;
        else if (s.equalsIgnoreCase("black"))
            bgColor = Color.black;
        else if (s.equalsIgnoreCase("gray"))
            bgColor = Color.gray;
        else if (s.equalsIgnoreCase("darkGray"))
            bgColor = Color.darkGray;
        else if (s.equalsIgnoreCase("red"))
            bgColor = Color.red;
        else if (s.equalsIgnoreCase("green"))
            bgColor = Color.green;
        else if (s.equalsIgnoreCase("blue"))
            bgColor = Color.blue;
        else if (s.equalsIgnoreCase("yellow"))
            bgColor = Color.yellow;
        else if (s.equalsIgnoreCase("magenta"))
            bgColor = Color.magenta;
        else if (s.equalsIgnoreCase("cyan"))
            bgColor = Color.cyan;
        else if (s.equalsIgnoreCase("pink"))
            bgColor = Color.pink;
        else if (s.equalsIgnoreCase("orange"))
            bgColor = Color.orange;
        else if (st.countTokens() == 3) {
            Integer r = new Integer(st.nextToken());
            Integer g = new Integer(st.nextToken());
            Integer b = new Integer(st.nextToken());
            bgColor = new Color(r.intValue(), g.intValue(), b.intValue());
        } else
            bgColor = Color.lightGray; 

	
		setBackground(bgColor);
		
		margin = 10;
		
		xpos1 = margin;
		ypos1 = margin;
		xpos2 = width - margin;
		ypos2 = height - margin;

		
		offscreenImg = createImage(width,height);
		offscreenG = offscreenImg.getGraphics();
		
		// Pour au fond sa couleur (sinon ca ne marche pas)
		offscreenG.setColor(bgColor);
		offscreenG.fillRect(0, 0, width, height);
	}
	
	public void start()
	{
		if (runner == null);
		{
			runner = new Thread(this);
			runner.start();
		}
	}
	
	public void stop()
	{
		if (runner != null)
		{
		runner.stop();
		runner = null;
		}
	}
	
	public void run()
	{
		while (true)
		{
			for (xpos1 = margin; xpos1 <= width - margin; xpos1 += step)
			{
				xpos2 = width - xpos1;
				colorNum++;
				if (colorNum == margin) colorNum = 0;
				repaint();
				try { Thread.sleep(timeSleep); }
				catch (InterruptedException e) { }
			}
			
			for (xpos1 = width - margin; xpos1 > margin; xpos1 -= step)
			{
				xpos2 = width - xpos1;
				colorNum++;
				if (colorNum == 10) colorNum = 0;
				repaint();
				
				try { Thread.sleep(timeSleep); }
				catch (InterruptedException e) { }
			}
		}
	}
	
	public void update(Graphics g)
	{
		paint(g);
	}
	
	public void paint(Graphics g)
	{
		switch (colorNum)
		{
		case 0: offscreenG.setColor(Color.lightGray); break;
		case 1: offscreenG.setColor(Color.gray); break;
		case 2: offscreenG.setColor(Color.darkGray); break;
		case 3: offscreenG.setColor(Color.red); break;
		case 4: offscreenG.setColor(Color.green); break;
		case 5: offscreenG.setColor(Color.blue); break;
		case 6: offscreenG.setColor(Color.yellow); break;
		case 7: offscreenG.setColor(Color.magenta); break;
		case 8: offscreenG.setColor(Color.cyan); break;
		case 9: offscreenG.setColor(Color.orange); break;			
		}

		offscreenG.drawLine(xpos1, ypos1, xpos2, ypos2);
		
		g.drawImage(offscreenImg, 0, 0, this);
	}
}
