/**
  NAME:         pactext.java
                Copyright (c) 1995 Liam Relihan. All rights reserved.
  PURPOSE:      
  AUTHOR:       Liam Relihan
                <relihanl@ul.ie>
  SCCS:         %M%        %R%.%L% %D%
  DATE:         29-Nov-1995
  PARAMETERS:   
  CALLED BY:
  MODIFIED:     
  BUGS:         
 */

import java.awt.*;
import java.applet.*;

public class pactext extends java.applet.Applet implements Runnable {
  Thread artist=null;
  int jaw_angle=0;
  String s=null;
  char characters[];
  int pac_size;
  int pac_x;
  int pac_y=10;
  int text_start_x=100;
  int text_y=36;
  int winheight=70;
  int winwidth=500;
  int first_living_char;
  boolean jaw_opening=true;
  private Image offScreenImage;
  private Dimension offScreenSize;
  private Graphics offScreenGraphics;
  private Color bgcolor;
  private Color paccolor;
  private Color textcolor;

  /** initialize settings and get parameters, etc. */
  public void init() {
    Font tfont;
    tfont=new Font("TimesRoman",Font.BOLD,20);

    bgcolor=getColorParameter("bgcolor");
    if (bgcolor==null) bgcolor=Color.lightGray;

    paccolor=getColorParameter("paccolor");
    if (paccolor==null) paccolor=Color.green;

    textcolor=getColorParameter("textcolor");
    if (textcolor==null) textcolor=Color.red;

    resize(winwidth,winheight);             
    setFont(tfont);

    s = getParameter("text");
    if (s == null) {
      s = "HELP !";
    }

    this.setBackground(bgcolor);

    initialize_variables();
  }

  protected Color getColorParameter(String name){
    String value=this.getParameter(name);
    int intvalue;
    try { intvalue=Integer.parseInt(value,16);}
    catch (NumberFormatException e) {return null;}
    return new Color(intvalue);
  }

  /** setup pacman characteristics */
  public void initialize_variables(){
    characters =  new char [s.length()];
    s.getChars(0,s.length(),characters,0);
    pac_size=50;
    pac_x=-pac_size;
    first_living_char=0;
  }

  /** make the pacman's mouth move */
  public void change_jaw_angle(){

    if (jaw_opening) {
      if (jaw_angle < 45) {
	jaw_angle=jaw_angle+10;
      } else {
	jaw_opening = false;
      }
    } else {
      if (jaw_angle > 0) {
	jaw_angle=jaw_angle-10;
      } else {
	jaw_opening = true;
      }
    }
  }

  /** paint the background with the pacman and text */
  public void paint(Graphics g) {
    int x_coord,y_coord;
    
    Dimension d = this.size();

    g.setColor(this.getBackground());
    g.fillRect(0,0,d.width,d.height);

    g.setColor(textcolor);

    for(int i=first_living_char;i<s.length();i++) {
      x_coord = text_start_x + (int) (Math.random()*5+30*i);
      y_coord = text_y + (int) (Math.random()*5);
      g.drawChars(characters, i,1,x_coord,y_coord);
      if (pac_x+(pac_size / 2) > x_coord) first_living_char++;
    }
    g.setColor(paccolor);
    change_jaw_angle();
    pac_x=pac_x+5;
    g.fillArc(pac_x,
	      pac_y,
	      pac_size,
	      pac_size,
	      jaw_angle,
	      360-(jaw_angle*2));
    if (pac_x > winwidth) initialize_variables();

  }

  /** new thread */
  public void start() {
    if (artist == null) {
      artist = new Thread(this);
      artist.start();
    }
  }
  
  public void stop() {
    artist = null;
  }

  /** create background and start animation*/
  public void run() {
    Dimension d = this.size();

    if((offScreenImage == null) || (d.width != offScreenSize.width) ||  
       (d.height != offScreenSize.height)) {
      offScreenImage = createImage(d.width, d.height);
      offScreenSize = d;
      offScreenGraphics = offScreenImage.getGraphics();
    }

    while (artist != null) {
      try {Thread.sleep(30);} catch (InterruptedException e){}
      paint(offScreenGraphics);
      this.getGraphics().drawImage(offScreenImage, 0, 0, null);
    }
    artist = null;
  }

}




