(*

This Unit Intend To Copy   1 Or More Files Using Window Api.
Alsow Includ Way To Move   1 Or More Files Using Window Api.
Alsow Includ Way To Delete 1 Or More Files To The Recycle Bin Using Window Api.

Some Of The Idea Taken From The Internet.
Fill Free To Use As Needed.

 *** 
 *** TO Be Use On Self responsibility ***
 ***

*)


unit uFileUtil;

interface

procedure CopyOneFile(Source, Dest : string);    // Like Source := 'c:\temp\kuku.txt'
                                                 //      Dest   := 'd:\temp\kuku.txt'
Procedure COPY_FILES(Source, Dest : string );    // Like Source := 'c:\idapi\*.*';
                                                 //      Dest   := 'c:\test';
Procedure MOVE_FILES(Source, Dest : string; Confirmation : Boolean);
                                                 // Like Source := 'c:\idapi\*.*';
                                                 //      Dest   := 'c:\test';
Procedure DELETE_FILES(Source : string; SilentMode : Boolean); // Like Source := 'c:\idapi\*.*';

implementation

uses
  Windows, Forms, WinTypes, SysUtils, Dialogs, LZExpand, ShellAPI;


procedure CopyOneFile(Source, Dest : string);
var
  SourceFile  : Integer;         { The LZ* functions use File Handles }
  DestFile    : Integer;
  RetCode     : Longint;
  OpenFileBuf : TOFStruct;       { Record needed by LZOpenFile }
  FileNameStz : array[ 0..255 ] of Char;
  E           : EInOutError;     { Exception Object, just in case }
begin
  StrPCopy( FileNameStz, Source );
  SourceFile := LZOpenFile( FileNameStz, OpenFileBuf, of_Read );

  if SourceFile < 0 then
  begin
    E := EInOutError.CreateFmt( 'Could not open %s', [ Source ] );
    E.ErrorCode := SourceFile;
    raise E;                     { Raise an Exception }
  end;

  StrPCopy( FileNameStz, Dest );
  DestFile := LZOpenFile( FileNameStz, OpenFileBuf, of_Create );

  if DestFile < 0 then
  begin
    LZClose( SourceFile );       { Be sure to close Source File }
    E := EInOutError.CreateFmt( 'Could not create %s', [ Dest ] );
    E.ErrorCode := DestFile;
    raise E;                     { Raise an Exception }
  end;

  RetCode := LZCopy( SourceFile, DestFile );

  LZClose( SourceFile );         { Even if LZCopy fails, we }
  LZClose( DestFile );           { still must close the files }

  if RetCode < 0 then
  begin
    E := EInOutError.CreateFmt( 'Could not copy %s to %s',
                                [ Source, Dest ] );
    E.ErrorCode := RetCode;
    raise E;                     { Raise an Exception }
  end;
end; {= CopyFile =}

Procedure MOVE_FILES(Source, Dest : string; Confirmation : Boolean);
// Like Source := 'c:\idapi\*.*';
var
  FOS              : TSHFileOpStruct;
  CopySourceString : String;
  CopyDestString   : String;
begin
  ZeroMemory(@FOS, sizeof(TSHFileOpStruct));
  CopySourceString := Source + #0#0;
  CopyDestString   := Dest;
  with FOS do begin
    Wnd                   := Application.Handle;
    wFunc                 := FO_MOVE;
    pFrom                 := Pchar(CopySourceString);
    pTo                   := Pchar(CopyDestString);
    fFlags                := FOF_SIMPLEPROGRESS;
    IF Not Confirmation Then
      fFlags := fFlags + FOF_NOCONFIRMATION;
    fAnyOperationsAborted := True;
    lpszProgressTitle     := Pchar(Application.Title);
  end;
  SHFileOperation(FOS);
end;

Procedure COPY_FILES(Source, Dest : string);
var
  FOS              : TSHFileOpStruct;
  CopySourceString : String;
  CopyDestString   : String;
begin
  ZeroMemory(@FOS, sizeof(TSHFileOpStruct));
  CopySourceString := Source + #0#0;
  CopyDestString   := Dest;
  with FOS do begin
    Wnd                   := Application.Handle;
    wFunc                 := FO_COPY;
    pFrom                 := Pchar(CopySourceString);
    pTo                   := Pchar(CopyDestString);
    fFlags                := FOF_SIMPLEPROGRESS;
    fAnyOperationsAborted := True;
    lpszProgressTitle     := Pchar(Application.Title);
  end;
  SHFileOperation(FOS);
end;

Procedure DELETE_FILES(Source : string; SilentMode : Boolean);
var
  FOS       : TSHFileOpStruct;
  DelString : String;
begin
  IF Not FileExists(Source) Then
    Exit;
  DelString := Source + #0#0;
  ZeroMemory(@FOS, sizeof(TSHFileOpStruct));
  with FOS do begin
    Wnd                   := Application.Handle;
    wFunc                 := FO_DELETE;
    pFrom                 := Pchar(DelString);
    fFlags                := FOF_ALLOWUNDO + FOF_SIMPLEPROGRESS;
    lpszProgressTitle     := Pchar(Application.Title);
    fAnyOperationsAborted := True;
    IF SilentMode Then
      fFlags := fFlags + FOF_NOCONFIRMATION;
  end;
  SHFileOperation(FOS);
end;

end.