unit WinReboot;

(* TWinReboot component (freeware)
   by Barry Brannan, September 1997
   (barrylb@poboxes.com)


   Usage:

   1. Drop TWinReboot component on a form.
   2. Call WinReboot1.WinExit(flags)

   Where flags must be one of the following:

   EWX_LOGOFF     - Shuts down processes and logs user off
   EWX_REBOOT     - Shuts down the restarts the system
   EWX_SHUTDOWN   - Shuts down system

   The following attributes may be combined (OR'd) with above flags

   EWX_POWEROFF  - shuts down system and turns off the power.
   EWX_FORCE     - forces processes to terminate.


   Example:
           WinReboot1.WinExit(EWX_REBOOT or EWX_FORCE);
*)

interface

uses
  Windows, Classes;

type
  TWinReboot = class(TComponent)
  private
    function SetPrivilege(privilegeName: string; enable: boolean): boolean;
  public
    function WinExit(flags: integer): boolean;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TWinReboot]);
end;

function TWinReboot.SetPrivilege(privilegeName: string; enable: boolean): boolean;
var
  tpPrev,
  tp         : TTokenPrivileges;
  token      : THandle;
  dwRetLen   : DWord;
begin
  result := False;

  OpenProcessToken(GetCurrentProcess, TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, @token);

  tp.PrivilegeCount := 1;
  if LookupPrivilegeValue(nil, pchar(privilegeName), tp.Privileges[0].LUID) then
  begin
    if enable then
      tp.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED
    else
      tp.Privileges[0].Attributes := 0;

    dwRetLen := 0;
    result := AdjustTokenPrivileges(token, False, tp, SizeOf(tpPrev), tpPrev, dwRetLen);
  end;
  CloseHandle(token);
end;


function TWinReboot.WinExit(flags: integer): boolean;
begin
  Result := True;
  SetPrivilege('SeShutdownPrivilege', true);
  if not ExitWindowsEx(flags, 0) then
      Result := False;
  SetPrivilege('SeShutdownPrivilege', False);
end;

end.
