unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, DXClass, DXDraws, ActnList,inifiles,KeyStringList;

type
  TMainForm = class(TDXForm)
    DXDraw: TDXDraw;
    DXTimer: TDXTimer;
    ActionList1: TActionList;
    Action1: TAction;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DXDrawFinalize(Sender: TObject);
    procedure DXDrawInitialize(Sender: TObject);
    procedure DXTimerTimer(Sender: TObject; LagCount: Integer);
    procedure FormCreate(Sender: TObject);

    public
    PressedKeyNumber: word;

    KeyBoardIniFileName: string;
    nTestKey:TShortCut;
    nMoveUp:TShortCut;
    nClose:TShortCut;
    nFullvsNormalScreen: TShortCut;

    procedure TestProc;
    procedure MoveUpProc;

  end;

var
  MainForm: TMainForm;

implementation

uses MMSystem, HelperUnit;

{$R *.DFM}

procedure TMainForm.DXDrawInitialize(Sender: TObject);
begin
  DXTimer.Enabled := True;
end;

procedure TMainForm.DXDrawFinalize(Sender: TObject);
begin
  DXTimer.Enabled := False;
end;


procedure TMainForm.DXTimerTimer(Sender: TObject; LagCount: Integer);
begin
  if not DXDraw.CanDraw then exit;

  DXDraw.Surface.Fill(0);

  TextOutSurface(DXDraw.Surface,
    20, 10, clWhite, 12, DateTimeToStr(Now));
  TextOutSurface(DXDraw.Surface,
    20, 30, clAqua, 12, 'FPS: '+inttostr(DXTimer.FrameRate));
  TextOutSurface(DXDraw.Surface,
    20, 30+20, clWhite, 12, format('Virtual Key code : %d',[PressedKeyNumber]));

  DXDraw.Flip;
end;



{
  processes key mapping
}
procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  ShortCutKey:TShortCut;
  s: string;
begin
  PressedKeyNumber:= key;
  ShortCutKey:= ShortCut(Key, Shift);

  if ShortCutKey = nClose then
  begin
    caption:= 'ESC pressed';
    Close;
  end;

  if ShortCutKey = nMoveUp then
  begin
    PressedKeyNumber:= nMoveUp;
    s:='Move Up Key Pressed';
    caption:= s;
    MoveUpProc;
    exit;
  end
  else
  begin
    s:='( unimplemented key )';
    caption:= s;
  end;

  if ShortCutKey = nTestKey then
  begin
    PressedKeyNumber:= nTestKey;
    s:='Test Key Pressed';
    caption:= s;
    TestProc;
    exit;
  end
  else
  begin
    s:='( unimplemented key )';
    caption:= s;
  end;

  if ShortCutKey = nFullvsNormalScreen then
    FullvsNormalScreen(MainForm, MainForm.DXDraw);
end;


procedure TMainForm.FormCreate(Sender: TObject);
var
  sIniFile:string;
  SectionName:string;
  KeyStrList: TKeyStringList;
begin
  PressedKeyNumber:= 0;
  KeyBoardIniFileName:= 'Keyboard.ini';
  KeyStrList:= TKeyStringList.create;

  try

    sIniFile:= ExtractFilePath(ParamStr(0)) + KeyBoardIniFileName;
    SectionName:= 'KeyboardMap';
    KeyStrList.IniFileAndSectionName(sIniFile, SectionName);

    nMoveUp := KeyStrList.KeyValue('MoveUp');
    nTestKey :=  KeyStrList.KeyValue('TestKey');
    nClose :=  KeyStrList.KeyValue('Close');
    nFullvsNormalScreen := KeyStrList.KeyValue('FullvsNormalScreen');
  finally
    KeyStrList.Free;
  end;
end;




procedure TMainForm.MoveUpProc;
begin
//
end;

procedure TMainForm.TestProc;
begin
//
end;

end.
