{ Houses some helper functions that encapsulates
some frequently repeated methods
such as; drawing a text on DXDraw surface,
fullscreen v.s normal window change
- DelphiX package
}
unit HelperUnit;

interface

uses
  Windows, Messages,
  SysUtils, Classes,
  Graphics, Controls,
  Forms, Dialogs,
  StdCtrls, DXClass,
  DXDraws;

{
draw a text on the dxdraw surface canvas
brush sytle is bsClear by default
}
procedure TextOutSurface(
  ASurface: TDirectDrawSurface; PosX, PosY: integer;
  AColor: TColor; ASize: integer; AText: string);


{
change between fullscreen v.s normal window view
input: TDXForm and its TDXDraw type class
}
procedure FullvsNormalScreen(ADXForm: TDXForm; ADXDraw : TDXDraw);




implementation


procedure TextOutSurface(
  ASurface: TDirectDrawSurface; PosX, PosY: integer;
  AColor: TColor; ASize: integer; AText: string);
begin

  with ASurface.Canvas do
  begin

    try
      Brush.Style := bsClear;
      Font.Color := AColor;
      Font.Size := ASize;
      Textout(PosX, PosY, AText);
    finally
      release;
    end;

  end;


end;


procedure FullvsNormalScreen(ADXForm: TDXForm; ADXDraw : TDXDraw);
begin

    ADXDraw.Finalize;

    if doFullScreen in ADXDraw.Options then
    begin
      ADXForm.RestoreWindow;

      ADXDraw.Cursor := crDefault;
      ADXForm.BorderStyle := bsNone;
      ADXDraw.Options := ADXDraw.Options - [doFullScreen];
    end else
    begin
      ADXForm.StoreWindow;

      ADXDraw.Cursor := crNone;
      ADXForm.BorderStyle := bsNone;
      ADXDraw.Options := ADXDraw.Options + [doFullScreen];
    end;

    ADXDraw.Initialize;

end;



end.
