unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ActnList;

type
  TForm1 = class(TForm)
    ButtonClose: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ButtonCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    KeyBoardIniFileName : string;

    nMoveUp : TShortCut;
    nClose : TShortCut;

  end;

var
  Form1: TForm1;

implementation
uses
  KeyStringList, Menus;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  sIniFile:string;
  SectionName:string;
  KeyStrList: TKeyStringList;
begin
  KeyBoardIniFileName:= 'keyboard.ini';
  KeyStrList:= TKeyStringList.create;

  try

    sIniFile:= ExtractFilePath(ParamStr(0)) + KeyBoardIniFileName;
    SectionName:= 'KeyboardMap';
    KeyStrList.IniFileAndSectionName(sIniFile, SectionName);

    nMoveUp := KeyStrList.KeyValue('MoveUp');
    nClose :=  KeyStrList.KeyValue('Close');
  finally
    KeyStrList.Free;
  end;

end;

{ when pressed UP key
a message is displayed
when ESC close the application
}
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  s : string;
  ShortCutKey : TShortCut;
begin

  ShortCutKey := ShortCut(Key, Shift);
  if ShortCutKey = nClose then
  begin
    Close;
  end;

  if ShortCutKey = nMoveUp then
    s := 'Move Up Key Pressed'
  else
    s := '( unimplemented key )';

  Self.Invalidate;
  Application.ProcessMessages;
  SetBkMode(canvas.handle, TRANSPARENT);
  with canvas do
  begin
    Font.Size := 14;
    Font.Color := clBlack;
    TextOut(32+1, 32+1, s);

    Font.Size := 14;
    Font.Color := clBlue;
    TextOut(32, 32, s);
  end;

end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;

end.
