{
register procedure omited to
allow the registration by the user
}
unit KeyStringList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

{$I VirtualKeyMap_value.inc}
{$I VirtualKeyMap_string.inc}

type
  TKeyStringList = class(TStringList)
  private
    { Private declarations }
    FKeyboardListLoaded : boolean;
    FKeyList:TStringList;
    FKeyValueList: TStringList;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor create; virtual;
    destructor destroy; override;

    procedure IniFileAndSectionName(const AFileName: string;
      ASectionName: string);
    function KeyValue(const AValue: string) : TShortCut;
  published
    { Published declarations }
  end;


//procedure Register;

implementation
uses
  Menus, inifiles;

{
procedure Register;
begin
  RegisterComponents('Samples', [TKeyStringList]);
end;
}

{ TKeyStringList }

constructor TKeyStringList.create;
var
  i : integer;
begin
  inherited create;
  Self.Sorted:= false;
//  Self.Changing;
  for i:= low(VirtualKeyMapValue) to high(VirtualKeyMapValue) do
  begin
    Self.Append(VirtualKeyMapString[i]);
  end;
//  Self.Changed;

  FKeyList:=TStringList.Create;
  FKeyValueList:= TStringList.Create;

  FKeyboardListLoaded := false;

end;

destructor TKeyStringList.destroy;
begin
  FKeyList.Free;
  FKeyValueList.Free;

  inherited destroy;
end;


procedure TKeyStringList.IniFileAndSectionName(const AFileName: string;
  ASectionName: string);
var
  IniFile : TIniFile;
begin

  FKeyboardListLoaded := false;
  IniFile := TIniFile.Create(AFileName);
  try
    IniFile.ReadSection(ASectionName, FKeyList);
    IniFile.ReadSectionValues(ASectionName, FKeyValueList);
    FKeyboardListLoaded:= true;
  finally
    IniFile.Free;
  end;

end;

{
make sure called .IniFileAndSectionName before
calling .KeyValue
finds a particular string type key value's
virtual key code
}
function TKeyStringList.KeyValue(const AValue: string): TShortCut;
var
  s: string;
begin
  if not FKeyboardListLoaded then
    raise exception.Create(
      '1st call IniFileAndSectionName with an '+
      'appropriate ini file name and a section name');


  result := 0;

  s:='';
  s:= FKeyValueList.Values[AValue];

  if pos('VK_', s) > 0 then
  begin
    result := VirtualKeyMapValue[Self.IndexOf(s)];
  end
  else
    result := TextToShortCut(s);

end;


end.
