{************************ Autor: William Zonta Mendona ***********************}
{**************************** Empresa: WZM SoftWare ***************************}
{********************** Data ltima alterao: 24/11/2003 *********************}
{********************************* Verso: 1.1 ********************************}
unit util;

interface

uses
  Windows, Forms, SysUtils, Checklst, Controls, Db, ShellApi, Dialogs, DBTables,
  RxVerInf, IBTable, Registry, RxMemDS;

{***************************** Caixa de Mensagens *****************************}
procedure msgErro(Mensagem, Caption: String);
function msgPergunta(Mensagem, Caption: String): Boolean;
procedure msgInformacao(Mensagem, Caption: String);
function InserirValor(Mensagem, Caption: String): String;
procedure msgErroFmt(Mensagem: String; Args: Array of Const; Caption: String);
{******************************* Nmeros e Texto ******************************}
procedure SomenteNumeros(var Key: Char);
function CompletarQuantidade(Quantidade: Integer; Texto: String;
  Direita: Boolean): String;
function RetirarCaracterEspecial(Texto: String; Caracter: Char;
  Direita: Boolean): String;
function UnidadeExtenso(Numero: Integer): String;
function DezenaExtenso(Numero: Integer): String;
function CentenaExtenso(Numero: Integer): String;
function MilharExtenso(Numero: Integer): String;
function DezenaMilharExtenso(Numero: Integer): String;
function CentenaMilharExtenso(Numero: Integer): String;
function NumeroPorExtenso(Numero: String; PrimeiraMaiuscula, TodasMaiusculas,
  Dinheiro: Boolean; NomeMoeda, NomeCentavos: String): String;
function PrimeiraLetraMaiuscula(Texto: String): String;
function TodasLetrasMaiusculas(Texto: String): String;
function TodasLetrasMinusculas(Texto: String): String;
function Criptografia(Texto: String; Chave: LongWord): String;
function ValidarEmail(Email: String): Boolean;
function VerificarTipoFormaPagamento(TipoPagamento,
  FormaPagamento: String): Boolean;
function TipoBorderoItau(FormaPagamento: String): Integer;
function ValidarCFP(CPF: String): Boolean;
function ValidarCGC(CGC: String): Boolean;
function vChar(C: Char): Byte;
{************************************ Forms ***********************************}
procedure AbrirForm(Form: TForm; FormClass: TFormClass; bShowModal: Boolean);
procedure AnimarForm(Form: TForm; Animacao: Integer);
{******************************** CheckListBox ********************************}
procedure SelecionarTodosItens(CheckListBox: TCheckListBox; Opcao: Boolean);
procedure InverterItens(CheckListBox: TCheckListBox);
{********************************* Data e Hora ********************************}
function VerificarData(Data: TDateTime): Boolean;
function VerificarHora(Hora: TDateTime): Boolean;
function RetornarPrimeiroDiaMes(Data: TDateTime): TDateTime;
function RetornarUltimoDiaMes(Data: TDateTime): TDateTime;
function RetornarDia(Data: TDateTime): Integer;
function RetornarMes(Data: TDateTime): Integer;
function RetornarAno(Data: TDateTime): Integer;
function DataExtenso(Data: TDateTime): String;
function DataAtualExtenso: String;
{******************************* Banco de Dados *******************************}
function StatusTabela(Tabela: TDataSet): String;
function AbrirTabelas(Tabela: Array of TIBTable): Boolean;
function FecharTabelas(Tabela: Array of TIBTable): Boolean;
procedure CopiarValores(dsDe: TDataSet; dsPara: TRxMemoryData);
{******************************* Sobre o Projeto ******************************}
function Versao: String;
function Compilacao: String;
{*********************************** Arquivo **********************************}
procedure GerarLog(Caption, Mensagem: String);
procedure GerarArquivoBackup(Diretorio, Linha: String);
procedure GerarArquivoCVS(Diretorio, Arquivo, Linha: String);
procedure GerarArquivoTXT(Diretorio, Arquivo, Linha: String);
procedure GerarArquivo(Diretorio, Arquivo, Linha, Extensao: String);
function LerArquivo(Arquivo: String): String;
procedure CriarDiretorio(Diretorio: String);
{*********************************** Registro *********************************}
procedure AutoExecutarIniciar(NomeAplicativo: String);

var
  oVI: TVersionInfo;
  vet_valido: Array [0..35] of String = ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
  UsuarioLogado: String = '';

const
  Dias: Array [1..7] of String = ('Domingo', 'Segunda-Feira', 'Tera-Feira', 'Quarta-Feira', 'Quinta-Feira', 'Sexta-Feira', 'Sbado');
  Meses: Array [1..12] of String = ('Janeiro', 'Fevereiro', 'Maro', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro');
  Unidades: Array [1..9] of String = ('um', 'dois', 'trs', 'quatro', 'cinco', 'seis', 'sete', 'oito', 'nove');
  dDezenas: Array [11..19] of String = ('onze', 'doze', 'treze', 'quatorze', 'quinze', 'dezesseis', 'dezesete', 'dezoito', 'dezenove');
  Dezenas: Array [1..9] of String = ('dez', 'vinte', 'trinta', 'quarenta', 'cinquenta', 'sescenta', 'setenta', 'oitenta', 'noventa');
  Centena = 'cem';
  Mil = 'mil';
  E = ' e ';
  Centenas: Array [1..9] of String = ('cento', 'duzentos', 'trezentos', 'quatrocentos', 'quinhentos', 'seiscentos', 'setecentos', 'oitocentos', 'novecentos');
  Milhar: Array [1..4] of String = ('milho', 'bilho', 'trilho', 'quatrilho');
  Milhares: Array [1..4] of String = ('milhes', 'bilhes', 'trilhes', 'quatrilhes');
  msg1 = 'Caractere(s) invlido(s) no incio do e-mail';
  msg2 = 'Smbolo @ no foi encontrado';
  msg3 = 'Excesso do smbolo @';
  msg4 = 'Caractere(s) invlido(s) antes do smbolo @';
  msg5 = 'Caractere(s) invlido(s) depois do smbolo @';
  msg6 = 'Agrupamento de caractere(s) invlido(s) a esqueda do @';
  msg7 = 'No existe ponto(s) digitado(s)';
  msg8 = 'Ponto encontrado no final do e-mail';
  msg9 = 'Ausncia de caractere(s) aps o ltimo ponto';
  msg10 = 'Excesso de ponto(s) a direita do @';
  msg11 = 'Ponto(s) disposto(s) de forma errada aps o @';
  msg12 = 'Caractere(s) invlido(s) antes do ponto';
  msg13 = 'Caractere(s) invlido(s) depois do ponto';
  C1 = 52845;
  C2 = 22719;
  TXT = '.txt';
  CVS = '.cvs';
  LOG = '.log';
  WTX = '.wtx';

implementation

procedure msgErro(Mensagem, Caption: String);
begin
  Application.MessageBox(PChar(Mensagem), PChar(Caption), mb_Ok + mb_IconError);
end;

function msgPergunta(Mensagem, Caption: String): Boolean;
begin
  Result := Application.MessageBox(PChar(Mensagem), PChar(Caption), mb_YesNo + mb_DefButton2 + mb_IconQuestion) = IdYes;
end;

procedure msgInformacao(Mensagem, Caption: String);
begin
  Application.MessageBox(PChar(Mensagem), PChar(Caption), mb_Ok + mb_IconInformation);
end;

function InserirValor(Mensagem, Caption: String): String;
begin
  InputQuery(Caption, Mensagem, Result);
end;

procedure msgErroFmt(Mensagem: String; Args: Array of Const; Caption: String);
begin
  msgErro(Format(Mensagem, Args), Caption);
end;

procedure SomenteNumeros(var Key: Char);
begin
  if not (Key in (['0'..'9'])) then
    Key := #0;
end;

function CompletarQuantidade(Quantidade: Integer; Texto: String;
  Direita: Boolean): String;
var
  iCount: Integer;
begin
  Result := '';
  for iCount := 1 to Quantidade do
    if Direita then
      Result := Texto + Result
    else
      Result := Result + Texto;
end;

function RetirarCaracterEspecial(Texto: String; Caracter: Char;
  Direita: Boolean): String;
var
  QuantidadeAcrescentar, TamanhoTexto, PosicaoInicial, iCount: Integer;
begin
  case Caracter of
    '0'..'9','a'..'z','A'..'Z': ; //No faz nada
  else
    Caracter := ' ';
  end;
  Texto := Trim(Texto);
  TamanhoTexto := Length(Texto);
  for iCount := 1 to Length(Texto) do
  begin
    if Pos(Texto[iCount], ' 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~''"!@#$%^&*()_-+=|/\{}[]:;,.<>') = 0 then
    begin
      case Texto[iCount] of
        '', '': Texto[iCount] := 'A';
        '', '': Texto[iCount] := 'E';
        '', '': Texto[iCount] := 'I';
        '', '': Texto[iCount] := 'O';
        '', '': Texto[iCount] := 'U';
        '', '': Texto[iCount] := 'A';
        '', '': Texto[iCount] := 'E';
        '', '': Texto[iCount] := 'I';
        '', '': Texto[iCount] := 'O';
        '', '': Texto[iCount] := 'U';
        '', '': Texto[iCount] := 'A';
        '', '': Texto[iCount] := 'E';
        '', '': Texto[iCount] := 'I';
        '', '': Texto[iCount] := 'O';
        '', '': Texto[iCount] := 'U';
        '', '': Texto[iCount] := 'A';
        '', '': Texto[iCount] := 'E';
        '', '': Texto[iCount] := 'I';
        '', '': Texto[iCount] := 'O';
        '', '': Texto[iCount] := 'U';
        '', '': Texto[iCount] := 'A';
        '', '': Texto[iCount] := 'O';
        '', '': Texto[iCount] := 'C';
        '', '': Texto[iCount] := 'N';
      else
        Texto[iCount] := ' ';
      end;
    end;
  end;
  QuantidadeAcrescentar := Length(Texto) - TamanhoTexto;
  if QuantidadeAcrescentar < 0 then
    QuantidadeAcrescentar := 0;
  if Caracter = '' then
    Caracter := ' ';
  if TamanhoTexto >= Length(Texto) then
    PosicaoInicial := TamanhoTexto - Length(Texto) + 1
  else
    PosicaoInicial := 1;
  if Direita then
    Texto := Copy(Texto, 1, Length(Texto)) + StringOfChar(Caracter, QuantidadeAcrescentar)
  else
    Texto := StringOfChar(Caracter, QuantidadeAcrescentar) + Copy(Texto, PosicaoInicial, Length(Texto));
  Result := AnsiUpperCase(Texto);
end;

function UnidadeExtenso(Numero: Integer): String;
begin
  Result := Unidades[Numero];
end;

function DezenaExtenso(Numero: Integer): String;
begin
  Result := '';
  if Numero in ([11..19]) then
    Result := dDezenas[Numero]
  else if (Numero mod 10) = 0 then
    Result := Dezenas[StrToInt(Copy(IntToStr(Numero), 1, 1))]
  else if StrToInt(Copy(IntToStr(Numero), 1, 1)) = 0 then
    Result := UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 2, 1)))
  else
    Result := Dezenas[StrToInt(Copy(IntToStr(Numero), 1, 1))] + E + UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 2, 1)));
end;

function CentenaExtenso(Numero: Integer): String;
begin
  Result := '';
  if Numero > 100 then
  begin
    if (Numero mod 100) = 0 then
      Result := Centenas[StrToInt(Copy(IntToStr(Numero), 1, 1))]
    else if StrToInt(Copy(IntToStr(Numero), 2, 1)) = 0 then
      Result := Centenas[StrToInt(Copy(IntToStr(Numero), 1, 1))] + E + UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 3, 1)))
    else
      Result := Centenas[StrToInt(Copy(IntToStr(Numero), 1, 1))] + E + DezenaExtenso(StrToInt(Copy(IntToStr(Numero), 2, 2)));
  end
  else if Numero < 100 then
  begin
    case Numero of
      1..9: Result := UnidadeExtenso(Numero);
      11..99: Result := DezenaExtenso(Numero);
    end;
  end
  else
    Result := Centena;
end;

function MilharExtenso(Numero: Integer): String;
begin
  Result := '';
  if (Numero mod 1000) = 0 then
    Result := UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 1, 1))) + ' ' + Mil
  else if (Numero mod 100) = 0 then
    Result := UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 1, 1))) + ' ' + Mil + E + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 2, 3)))
  else
    Result := UnidadeExtenso(StrToInt(Copy(IntToStr(Numero), 1, 1))) + ' ' + Mil + ' ' + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 2, 3)));
end;

function DezenaMilharExtenso(Numero: Integer): String;
begin
  Result := '';
  if ((Numero mod 10000) = 0) or ((Numero mod 1000) = 0) then
    Result := DezenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 2))) + ' ' + Mil
  else if (Numero mod 100) = 0 then
    Result := DezenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 2))) + ' ' + Mil + ' e ' + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 3, 3)))
  else
    Result := DezenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 2))) + ' ' + Mil + ' ' + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 3, 3)));
end;

function CentenaMilharExtenso(Numero: Integer): String;
begin
  if ((Numero mod 100000) = 0) or ((Numero mod 10000) = 0) then
    Result := CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 3))) + ' ' + Mil
  else if (Numero mod 100) = 0 then
  begin
    if StrToInt(Copy(IntToStr(Numero), 4, 3)) > 0 then
      Result := CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 3))) + ' ' + Mil + ' e ' + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 4, 3)))
    else
      Result := CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 3))) + ' ' + Mil;
  end
  else
    Result := CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 1, 3))) + ' ' + Mil + ' ' + CentenaExtenso(StrToInt(Copy(IntToStr(Numero), 4, 3)))
end;

function NumeroPorExtenso(Numero: String; PrimeiraMaiuscula, TodasMaiusculas,
  Dinheiro: Boolean; NomeMoeda, NomeCentavos: String): String;
var
  Inteiro, Decimal: Integer;
  Texto: String;
begin
  if StrToInt(Numero) = 0 then
    Abort;
  if Pos(',', Numero) > 0 then
  begin
    Inteiro := StrToInt(Copy(Numero, 1, Pos(',', Numero) - 1));
    Decimal := StrToInt(Copy(Numero, Pos(',', Numero) + 1, Length(Numero)));
  end
  else
  begin
    Inteiro := StrToInt(Numero);
    Decimal := 0;
  end;
  case Length(IntToStr(Inteiro)) of
    1: Texto := UnidadeExtenso(Inteiro); //Unidades
    2: Texto := DezenaExtenso(Inteiro); //Dezenas
    3: Texto := CentenaExtenso(Inteiro); //Centenas
    4: Texto := MilharExtenso(Inteiro); //Milhares
    5: Texto := DezenaMilharExtenso(Inteiro); //Dezenas de Milhares
    6: Texto := CentenaMilharExtenso(Inteiro); //Centenas de Milhares
  else
    Texto := 'Nmero muito grande';
  end;
  if PrimeiraMaiuscula then
    Texto := PrimeiraLetraMaiuscula(Texto);
  if Dinheiro then
    Texto := Texto + ' ' + NomeMoeda;
  if TodasMaiusculas then
    Texto := TodasLetrasMaiusculas(Texto);
  if Decimal > 0 then
  begin
    Texto := Texto + E;
    case Length(IntToStr(Decimal)) of
      1: Texto := Texto + UnidadeExtenso(Decimal); //Unidades
      2: Texto := Texto + DezenaExtenso(Decimal); //Dezenas
      3: Texto := Texto + CentenaExtenso(Decimal); //Centenas
      4: Texto := Texto + MilharExtenso(Decimal); //Milhares
      5: Texto := Texto + DezenaMilharExtenso(Decimal); //Dezenas de Milhares
      6: Texto := Texto + CentenaMilharExtenso(Decimal); //Centenas de Milhares
    end;
    if PrimeiraMaiuscula then
      Texto := PrimeiraLetraMaiuscula(Texto);
    if Dinheiro then
      Texto := Texto + ' ' + NomeCentavos;
    if TodasMaiusculas then
      Texto := TodasLetrasMaiusculas(Texto);
  end;
  Result := Texto;
end;

function PrimeiraLetraMaiuscula(Texto: String): String;
begin
  Result := UpperCase(Copy(Texto, 1, 1)) + LowerCase(Copy(Texto, 2, Length(Texto)));
end;

function TodasLetrasMaiusculas(Texto: String): String;
begin
  Result := UpperCase(Texto);
end;

function TodasLetrasMinusculas(Texto: String): String;
begin
  Result := LowerCase(Texto);
end;

function Criptografia(Texto: String; Chave: LongWord): String;
var
  I: Integer;
  OutValue: String;
begin
  OutValue := '';
  for I := 1 to Length(Texto) do
    OutValue := OutValue + Char(not(Ord(Texto[I]) - Chave * 2654895 div 5456));
  Result := OutValue;
end;

function ValidarEmail(Email: String): Boolean;
var
  i, j, tam_email, simb_arroba, simb_arroba2, qtd_arroba, qtd_pontos, qtd_pontos_esq, qtd_pontos_dir, posicao, posicao2, ponto, ponto2: Integer;
  vet_email: Array [0..49] of String;
  msg: String;
begin
  qtd_pontos := 0;
  qtd_pontos_esq := 0;
  qtd_pontos_dir := 0;
  qtd_arroba := 0;
  posicao := 0;
  posicao2 := 0;
  simb_arroba := 0;
  simb_arroba2 := 0;
  ponto := 0;
  ponto2 := 0;
  msg := '';
  Result := True;
  //Verificando parte inicial do E-mail
  tam_email := Length(Email);
  for i := 0 to tam_email - 1 do
  begin
    vet_email[i] := Copy(Email, i + 1, 1);
    if vet_email[i] = '@' then
    begin
      inc(qtd_arroba);
      posicao := i;
    end;
  end;
  if ((vet_email[0] = '@') or (vet_email[0] = '.') or (vet_email[0] = '-')) then
  begin
    Result := False;
    msg := msg1;
  end;
  //Verificando se tem o smbolo @ e quantos tem
  if qtd_arroba < 1 then
  begin
    Result := False;
    msg := msg2;
  end
  else if qtd_arroba > 1 then
  begin
    Result := False;
    msg := msg3 + ' Encontrado(s): ' + IntToStr(qtd_arroba);
  end
  else //Verificando o que vem antes e depois do smbolo @
  begin
    for i := 0 to 35 do
    begin
      if vet_email[posicao - 1] <> vet_valido[i] then
        inc(simb_arroba)
      else
        dec(simb_arroba);
      if vet_email[posicao + 1] <> vet_valido[i] then
        inc(simb_arroba2)
      else
        dec(simb_arroba2);
    end;
    if simb_arroba = 36 then
    begin
      //Antes do arroba h um smbolo desconhecido do vetor vlido
      Result := False;
      msg := msg4;
    end
    else
      if simb_arroba2 = 36 then
      begin
        //Depois do arroba h um smbolo desconhecido do vetor vlido
        Result := False;
        msg := msg5;
      end
  end;
  //Verificando se h pontos e quantos, e Verificando parte final do e-mail
  for j := 0 to tam_email - 1 do
    if vet_email[j] = '-' then
      if ((vet_email[j - 1] = '.') or (vet_email[j - 1] = '-')) then
      begin
        Result := False;
        msg := msg6;
      end;
  for i := 0 to tam_email - 1 do
    if vet_email[i] = '.' then
    begin
      inc(qtd_pontos);
      posicao2 := i + 1;
      if i > posicao then
        inc(qtd_pontos_dir)
      else
        inc(qtd_pontos_esq);
      if ((vet_email[i - 1] = '.') or (vet_email[i - 1] = '-')) then
      begin
        Result := False;
        msg := msg6;
      end;
    end;
  if qtd_pontos < 1 then
  begin
    Result := False;
    msg := msg7;
  end
  else if vet_email[tam_email - 1] = '.' then
  begin
    Result := False;
    msg := msg8;
  end
  else if vet_email[tam_email - 2] = '.' then
  begin
    Result := False;
    msg := msg9;
  end
  else if qtd_pontos_dir > 2 then
  begin
    Result := False;
    msg := msg10 + ' Encontrado(s): ' + IntToStr(qtd_pontos) + #10 + 'Encontrado(s) a direita do @: ' + IntToStr(qtd_pontos_dir);
  end
  else if (not ((((tam_email - posicao2) = 3) and (qtd_pontos_dir = 1)) or (((tam_email - posicao2) = 2) and (qtd_pontos_dir = 2)) or (((tam_email - posicao2) = 2) and (qtd_pontos_dir = 1)))) then
  begin
    Result := False;
    msg := msg11 + #10 + 'Encontrado(s) a esquerda do @: ' + IntToStr(qtd_pontos_esq) + #10 + 'Encontrado(s) a direita do @: ' + IntToStr(qtd_pontos_dir);
  end
  else
  //Verificando o que vem antes e depois do ponto
  begin
    for i := 0 to 35 do
    begin
      if vet_email[posicao2-2] <> vet_valido[i] then
        inc(ponto)
      else
        dec(ponto);
      if vet_email[posicao2] <> vet_valido[i] then
        inc(ponto2)
      else
        dec(ponto2);
    end;
    if ponto = 36 then
    begin
      //Antes do ponto h um smbolo desconhecido do vetor vlido
      Result := False;
      msg := msg12;
    end
    else if ponto2 = 36 then
    begin
      //Depois do ponto h um smbolo desconhecido do vetor vlido
      Result := False;
      msg := msg13;
    end
  end;
  //Verificao final
  if not Result then
  begin
    msg := msg + #10 + 'Formato de E-mail invlido';
    MsgErro(msg, 'Erro');
  end;
end;

function VerificarTipoFormaPagamento(TipoPagamento,
  FormaPagamento: String): Boolean;
begin
  try
    if (TipoPagamento = '30') and (FormaPagamento = '01') then //Salrios x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '30') and (FormaPagamento = '60') then //Salrios x Carto salrio
      Result := True
    else if (TipoPagamento = '30') and (FormaPagamento = '02') then //Salrios x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '30') and (FormaPagamento = '03') then //Salrios x DOC "C"
      Result := True
    else if (TipoPagamento = '30') and (FormaPagamento = '10') then //Salrios x Ordem de pagamento  disposio
      Result := True
    else if  (TipoPagamento = '30') and (FormaPagamento = '41') then //Salrios x TED - outro titular
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '01') then //Dividendos x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '05') then //Dividendos x Crdito em conta poupana no Ita
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '02') then //Dividendos x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '03') then //Dividendos x DOC "C"
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '10') then //Dividendos x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '10') and (FormaPagamento = '41') then //Dividendos x TED - outro titular
      Result := True
    else if  (TipoPagamento = '15') and (FormaPagamento = '01') then //Debntures x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '15') and (FormaPagamento = '02') then //Debntures x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '15') and (FormaPagamento = '03') then //Debntures x DOC "C"
      Result := True
    else if (TipoPagamento = '15') and (FormaPagamento = '10') then //Debntures x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '15') and (FormaPagamento = '41') then //Debntures x TED - outro titular
      Result := True
    else if (TipoPagamento = '60') and (FormaPagamento = '01') then //Despesas viajante em trnsito x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '60') and (FormaPagamento = '02') then //Despesas viajante em trnsito x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '60') and (FormaPagamento = '03') then //Despesas viajante em trnsito x DOC "C"
      Result := True
    else if (TipoPagamento = '60') and (FormaPagamento = '10') then //Despesas viajante em trnsito x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '60') and (FormaPagamento = '41') then //Despesas viajante em trnsito x TED - outro titular
      Result := True
    else if (TipoPagamento = '80') and (FormaPagamento = '01') then //Representantes autorizados x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '80') and (FormaPagamento = '02') then //Representantes autorizados x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '80') and (FormaPagamento = '03') then //Representantes autorizados x DOC "C"
      Result := True
    else if (TipoPagamento = '80') and (FormaPagamento = '10') then //Representantes autorizados x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '80') and (FormaPagamento = '41') then //Representantes autorizados x TED - outro titular
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '01') then //Fornecedores x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '06') then //Fornecedores x Crdito em conta corrente de mesma titularidade
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '05') then //Fornecedores x Crdito em conta poupana no Ita
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '02') then //Fornecedores x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '03') then //Fornecedores x DOC "C"
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '07') then //Fornecedores x DOC "D"
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '10') then //Fornecedores x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '30') then //Fornecedores x Pagamento de ttulos em cobrana no Ita
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '31') then //Fornecedores x Pagamento de ttulos em cobrana em outros bancos
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '13') then //Fornecedores x Pagamento de concessionrias
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '41') then //Fornecedores x TED - outro titular
      Result := True
    else if (TipoPagamento = '20') and (FormaPagamento = '43') then //Fornecedores x TED = mesmo titular
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '01') then //Benefcios x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '05') then //Benefcios x Crdito em conta poupana no Ita
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '02') then //Benefcios x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '03') then //Benefcios x DOC "C"
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '10') then //Benefcios x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '90') and (FormaPagamento = '41') then //Benefcios x TED - outro titular
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '01') then //Sinistros de seguros x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '05') then //Sinistros de seguros x Crdito em conta poupana no Ita
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '02') then //Sinistros de seguros x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '03') then //Sinistros de seguros x DOC "C"
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '10') then //Sinistros de seguros x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '50') and (FormaPagamento = '41') then //Sinistros de seguros x TED - outro titular
      Result := True
    else if (TipoPagamento = '40') and (FormaPagamento = '01') then //Fundos de investimentos x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '40') and (FormaPagamento = '02') then //Fundos de investimentos x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '40') and (FormaPagamento = '10') then //Fundos de investimentos x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '01') then //Diversos x Crdito em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '06') then //Diversos x Crdito em conta corrente de mesma titularidade
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '05') then //Diversos x Crdito em conta poupana no Ita
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '02') then //Diversos x Cheque em conta corrente no Ita
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '03') then //Diversos x DOC "C"
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '07') then //Diversos x DOC "D"
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '10') then //Diversos x Ordem de pagamento  disposio
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '30') then //Diversos x Pagamento de ttulos em cobrana no Ita
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '31') then //Diversos x Pagamento de ttulos em cobrana em outros bancos
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '13') then //Diversos x Pagamento de concessionrias
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '41') then //Diversos x TED - outro titular
      Result := True
    else if (TipoPagamento = '98') and (FormaPagamento = '43') then //Diversos x TED = mesmo titular
      Result := True
    else if (TipoPagamento = '22') and (FormaPagamento = '16') then //Tributos x DARF normal
      Result := True
    else if (TipoPagamento = '22') and (FormaPagamento = '17') then //Tributos x GPS - guia da previdncia social
      Result := True
    else if (TipoPagamento = '22') and (FormaPagamento = '18') then //Tributos x DARF simples
      Result := True
    else if (TipoPagamento = '22') and (FormaPagamento = '21') then //Tributos x DARJ
      Result := True
    else
      Result := False;
  except
    Result := False;
  end;
end;

function TipoBorderoItau(FormaPagamento: String): Integer;
begin
  case StrToInt(FormaPagamento) of
    1..3, 7, 10, 41, 43: Result := 1;
    30, 31: Result := 2;
    13: Result := 3;
    16..18, 21: Result := 4
  end;
end;

function ValidarCFP(CPF: String): Boolean;
const
  peso1: Array [1..9] of Integer = (0, 9, 8, 7, 6, 5, 4, 3, 2);
  peso2: Array [1..10] of Integer = (1, 0, 9, 8, 7, 6, 5, 4, 3, 2);
var
  i, Soma, iCount: Integer;
  d1, d2: Byte;
  function vpeso1: Integer;
  begin
    if (i = 1) and (peso1[i] = 0) then
      vpeso1 := 10
    else
      vpeso1 := peso1[i];
  end;
  function vpeso2: Integer;
  begin
    if (i = 1) and (peso2[i] = 1) then
      vpeso2 := 11
    else if (i = 2) and (peso2[i] = 0) then
      vpeso2 := 10
    else
      vpeso2 := peso2[i];
  end;
begin
  if CPF = '' then
  begin
     Result := False;
     Exit;
  end;
  for iCount := 0 to Length(Trim(CPF)) do
  begin
    if CPF[iCount] = '.' then
      Delete(CPF, iCount, 1);
    if CPF[iCount] = '-' then
      Delete(CPF, iCount, 1);
    if CPF[iCount] = '/' then
      Delete(CPF, iCount, 1);
  end;
  Insert(Copy('00000000000', 1, 11 - Length(CPF)), CPF, 1);
  Soma := 0;
  for i := 1 to 9 do
    Soma := Soma + vpeso1 * vChar(CPF[i]);
  d1 := Soma mod 11;
  if (d1 = 0) or (d1 = 1) then
    d1:= 0
  else
    d1 := 11 - d1;
  if d1 <> vChar(CPF[10]) then
  begin
    Result := false;
    Exit;
  end;
  Soma:= 0;
  for i := 1 to 10 do
    Soma := Soma + vpeso2 * vChar(CPF[i]);
  d2 := Soma mod 11;
  if (d2 = 0) or (d2 = 1) then
    d2 := 0
  else
    d2 := 11 - d2;
  Result := d2 = vChar(CPF[11]);
end;

function ValidarCGC(CGC: String): Boolean;
const
  peso1: Array [1..12] of Integer = (5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2);
  peso2: Array [1..13] of Integer = (6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2);
var
  i, Soma, iCount: Integer;
  d1, d2: Byte;
begin
  if CGC = '' then
  begin
    Result := False;
    Exit;
  end;
  for iCount := 0 to Length(Trim(CGC)) do
  begin
    if CGC[iCount] = '.' then
      Delete(CGC, iCount, 1);
      if CGC[iCount] = '-' then
        Delete(CGC, iCount, 1);
      if CGC[iCount] = '/' then
        Delete(CGC, iCount, 1);
  end;
  Insert(Copy('00000000000000', 1, 14 - Length(CGC)), CGC, 1);
  Soma := 0;
  for i := 1 to 12 do
    Soma := Soma + peso1[i] * vChar(CGC[i]);
  d1 := Soma mod 11;
  if (d1 = 0) or (d1 = 1) then
    d1 := 0
  else
    d1 := 11 - d1;
  if d1 <> vChar(CGC[13]) then
  begin
    Result := False;
    Exit;
  end;
  Soma := 0;
  for i := 1 to 13 do
    Soma := Soma + peso2[i] * vChar(CGC[i]);
  d2 := Soma mod 11;
  if (d2 = 0) or (d2 = 1) then
    d2 := 0
  else
    d2 := 11 - d2;
  Result := d2 = vChar(CGC[14]);
end;

function vChar(C: Char): Byte;
begin
  Result := Ord(C) - 48;
end;

procedure AbrirForm(Form: TForm; FormClass: TFormClass; bShowModal: Boolean);
begin
  if not Assigned(Form) then
    Application.CreateForm(FormClass, Form);
  if bShowModal then
    Form.Show
  else
    Form.ShowModal;
end;

procedure AnimarForm(Form: TForm; Animacao: Integer);
begin
  case Animacao of
    0: AnimateWindow(Form.Handle, 2000, AW_BLEND);
    1: AnimateWindow(Form.Handle, 2000, AW_CENTER);
    2: AnimateWindow(Form.Handle, 2000, AW_HOR_POSITIVE);
    3: AnimateWindow(Form.Handle, 2000, AW_HOR_NEGATIVE);
    4: AnimateWindow(Form.Handle, 2000, AW_VER_POSITIVE);
    5: AnimateWindow(Form.Handle, 2000, AW_VER_NEGATIVE);
  end;
end;

procedure SelecionarTodosItens(CheckListBox: TCheckListBox; Opcao: Boolean);
var
  iCount: Integer;
begin
  for iCount := 0 to CheckListBox.Items.Count - 1 do
    CheckListBox.Checked[iCount] := Opcao;
end;

procedure InverterItens(CheckListBox: TCheckListBox);
var
  iCount: Integer;
begin
  for iCount := 0 to CheckListBox.Items.Count - 1 do
    CheckListBox.Checked[iCount] := not CheckListBox.Checked[iCount];
end;

function VerificarData(Data: TDateTime): Boolean;
var
  Temp: String;
begin
  try
    Result := True;
    Temp := DateToStr(Data);
  except
    Result := False;
  end;
end;

function VerificarHora(Hora: TDateTime): Boolean;
var
  Temp: String;
begin
  try
    Result := True;
    Temp := TimeToStr(Hora);
  except
    Result := False;
  end;
end;

function RetornarPrimeiroDiaMes(Data: TDateTime): TDateTime;
var
  Dia, Mes, Ano: Word;
begin
  DecodeDate(Data, Ano, Mes, Dia);
  Result := EncodeDate(Ano, Mes, 1);
end;

function RetornarUltimoDiaMes(Data: TDateTime): TDateTime;
begin
  Result := IncMonth(RetornarPrimeiroDiaMes(Data), 1) - 1;
end;

function RetornarDia(Data: TDateTime): Integer;
var
  Dia, Mes, Ano: Word;
begin
  DecodeDate(Data, Ano, Mes, Dia);
  Result := Dia;
end;

function RetornarMes(Data: TDateTime): Integer;
var
  Dia, Mes, Ano: Word;
begin
  DecodeDate(Data, Ano, Mes, Dia);
  Result := Mes;
end;

function RetornarAno(Data: TDateTime): Integer;
var
  Dia, Mes, Ano: Word;
begin
  DecodeDate(Data, Ano, Mes, Dia);
  Result := Ano;
end;

function DataExtenso(Data: TDateTime): String;
var
  iDia: Integer;
begin
  iDia := DayOfWeek(Data);
  Result := Dias[iDia] + ', ' + IntToStr(RetornarDia(Data)) + ' de ' + Meses[RetornarMes(Data)] + ' de ' + FloatToStr(RetornarAno(Data));
end;

function DataAtualExtenso: String;
begin
  Result := DataExtenso(Now);
end;

function StatusTabela(Tabela: TDataSet): String;
begin
  if Tabela.State = dsInactive then
     Result := 'Inativo'
  else if Tabela.State = dsBrowse then
     Result := 'Navegar'
  else if Tabela.State = dsEdit then
     Result := 'Editar'
  else if Tabela.State = dsInsert then
     Result := 'Inserir'
  else if Tabela.State = dsSetKey then
     Result := 'Chave'
  else if Tabela.State = dsCalcFields then
     Result := 'Calculando'
  else if Tabela.State = dsFilter then
     Result := 'Filtro'
  else if Tabela.State = dsNewValue then
     Result := 'Novo'
  else if Tabela.State = dsOldValue then
     Result := 'Valor Antigo'
  else if Tabela.State = dsCurValue then
     Result := 'Valor Corrente';
end;

function AbrirTabelas(Tabela: Array of TIBTable): Boolean;
var
 iCount: Integer;
begin
  try
    Result := True;
    for iCount := 0 to High(Tabela) do
      Tabela[iCount].Open;
  except
    Result := False;
    msgErro('Impossvel abrir a(s) tabela(s)', 'Erro');
  end;
end;

function FecharTabelas(Tabela: Array of TIBTable): Boolean;
var
 iCount: Integer;
begin
  try
    Result := True;
    for iCount := 0 to High(Tabela) do
      Tabela[iCount].Close;
  except
    Result := False;
    msgErro('Impossvel fechar a(s) tabela(s)', 'Erro');
  end;
end;

procedure CopiarValores(dsDe: TDataSet; dsPara: TRxMemoryData);
var
  iCount: Integer;
begin
  dsPara.Close;
  dsPara.FieldDefs.Clear;
  for iCount := 0 to dsDe.FieldCount - 1 do
    dsPara.FieldDefs.Add(dsDe.Fields.Fields[iCount].FieldName, dsDe.Fields.Fields[iCount].DataType);
  dsPara.Open;
  dsPara.EmptyTable;
  dsDe.First;
  if dsDe.RecordCount > 0 then
    while not dsDe.Eof do
    begin
      dsPara.Append;
      for iCount := 1 to dsDe.Fields.Count do
        dsPara.Fields.Fields[iCount].AsVariant := dsDe.Fields.Fields[iCount].AsVariant;
      dsPara.Post;
    end;
end;

function Versao: String;
begin
  try
    with oVI.FileLongVersion do
      Result := Format('%d.%d.%d', [All[2], All[1], All[4]]);
  except
    Result := '';
  end;
end;

function Compilacao: String;
begin
  try
    with oVI.FileLongVersion do
      Result := IntToStr(All[3]);
  except
    Result := '';
  end;
end;

procedure GerarLog(Caption, Mensagem: String);
begin
  GerarArquivo(ExtractFilePath(ParamStr(0)), ExtractFilePath(ParamStr(0)) + 'Erro', UsuarioLogado + ' - ' + DateTimeToStr(Now) + ' - ' + Caption +  ' - ' + Mensagem, LOG);
end;

procedure GerarArquivoBackup(Diretorio, Linha: String);
begin
  GerarArquivo(Diretorio, 'Backup', Linha, WTX);
end;

procedure GerarArquivoCVS(Diretorio, Arquivo, Linha: String);
begin
  GerarArquivo(Diretorio, Arquivo, Linha, CVS);
end;

procedure GerarArquivoTXT(Diretorio, Arquivo, Linha: String);
begin
  GerarArquivo(Diretorio, Arquivo, Linha, TXT);
end;

procedure GerarArquivo(Diretorio, Arquivo, Linha, Extensao: String);
var
  Info: TextFile;
  sArquivo: String;
begin
  try
    CriarDiretorio(Diretorio);
    sArquivo := Diretorio + '\' + Arquivo + Extensao;
    AssignFile(Info, sArquivo);
    if not FileExists(sArquivo) then
      Rewrite(Info, sArquivo);
    Append(Info);
    WriteLn(Info, Linha);
  finally
    CloseFile(Info);
  end;
end;

function LerArquivo(Arquivo: String): String;
var
  Info: TextFile;
  Linha: String;
begin
  try
    AssignFile(Info, Arquivo);
    Reset(Info);
    ReadLn(Info, Linha);
    while not Eof(Info) do
    begin
      Result := Linha;
      ReadLn(Info, Linha);
    end;
  finally
    Result := Linha;
    CloseFile(Info);
  end;
end;

procedure AutoExecutarIniciar(NomeAplicativo: String);
var
  Reg: TRegIniFile;
  S, S2: String;
begin
  Reg := TRegIniFile.Create;
  S := ExtractFileDir(NomeAplicativo);
  S2 := ExtractFileName(NomeAplicativo);
  S := S + '\' + S2;
  Reg.RootKey := HKEY_USERS;
  Reg.Openkey('\.DEFAULT\Software\Microsoft\Windows\CurrentVersion', False);
  Reg.WriteString('Run', NomeAplicativo, S);
end;

procedure CriarDiretorio(Diretorio: String);
begin
  if not DirectoryExists(Diretorio) then
    ForceDirectories(Diretorio);
end;

initialization
  oVI := TVersionInfo.Create(Application.ExeName);
finalization
  oVI.Free;
end.
