unit UDemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBTables, DB, RPrint, Printers, ExtCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Table1Name: TStringField;
    Table1Capital: TStringField;
    Table1Continent: TStringField;
    Table1Area: TFloatField;
    Table1Population: TFloatField;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    RPrint1: TRPrint;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Table1.DatabaseName := ExtractFilePath(Application.ExeName);
  Table1.Open;
  {inicio rotina do relatorio}
  RPrint1.BeginDoc;
  RPrint1.Adjust(99);
  RPrint1.Out('PAISES', 99, [pcBold, pcCenter, pcLineFeed]);
  RPrint1.Out('Relatrio de Teste', 80, [pcBold]);
  RPrint1.Out('Pgina: ' + IntToStr(RPrint1.Page), 19, [pcBold, pcRight, pcLineFeed]);
  RPrint1.Out('-', 99, [pcFill, pcLineFeed]);
  RPrint1.Out('Pas',       25, [pcBold]);
  RPrint1.Out('Capital',    25, [pcBold]);
  RPrint1.Out('Continente', 25, [pcBold]);
  RPrint1.Out('rea',       12, [pcBold, pcRight]);
  RPrint1.Out('Populao',  12, [pcBold, pcRight, pcLineFeed]);
  RPrint1.Out('-', 99, [pcFill, pcLineFeed]);
  while (not Table1.EOF) do
    begin
      RPrint1.Out(Table1Name.Value    , 25, []);
      RPrint1.Out(Table1Capital.Value, 25, []);
      RPrint1.Out(Table1Continent.Value  , 25, []);
      RPrint1.Out(FloatToStrF(Table1Area.Value, ffNumber, 12, 0), 12, [pcRight]);
      RPrint1.Out(FloatToStrF(Table1Population.Value, ffNumber, 12, 0), 12, [pcRight, pcLineFeed]);
      Table1.Next;
    end;
  RPrint1.Out('-', 99, [pcFill, pcLineFeed]);
  RPrint1.Rect(-1, 29, 60, 32, 5);
  RPrint1.Row := 30;
  RPrint1.Col := 0;
  RPrint1.Out('Pequeno exemplo de texto SEM justificao em 60 colunas', 60, [pcLineFeed]);
  RPrint1.Out('Pequeno exemplo de texto COM justificao em 60 colunas', 60, [pcJustify]);
  RPrint1.EndDoc;
  {fim da rotina do relatorio}
  Table1.Close;
  Close;
end;

end.
