{
      Componente TMemoryResource
      ==========================

   Empressa: JJW Informtica LTDA.
   Descrio: Gerenciamento da Memria
   Verso: 1.0
   Autor: Roberto Germano Vieweg Neto
}

unit MemoryResource;

interface

uses
  Windows, Messages, SysUtils, Classes, DB, DBTables, Dialogs, Forms, ExtCtrls;

type
  TMemoryResource = class(TComponent)
  private
    { Private declarations }
    FTimer : TTimer;
    FInterval : Integer;
    FFreeMemoryPercent : Integer;
    FUseMemoryPercent : Integer;
    FAvailMem : Integer;
    FTotalMem : Integer;
    function GetInterval : Integer;
    procedure SetInterval(Value : Integer);
    procedure ATimer(Sender: TObject);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Interval          : Integer read GetInterval Write SetInterval;
    property FreeMemoryPercent : Integer read FFreeMemoryPercent;
    property UseMemoryPercent  : Integer read FUseMemoryPercent;
    property AvailibleMemory   : Integer read FAvailMem;
    property TotalMemory       : Integer read FTotalMem;
  end;

procedure Register;

implementation

function TMemoryResource.GetInterval : Integer;
begin
    Result := FInterval;
end;

procedure TMemoryResource.SetInterval(Value : Integer);
begin
    FInterval := Value;
    FTimer.Interval := Value;
end;

procedure TMemoryResource.ATimer(Sender: TObject);
var
  MS: TMemoryStatus;
  i : Integer;
begin
  GlobalMemoryStatus(MS);
  FUseMemoryPercent := trunc(((ms.dwTotalPhys - ms.dwAvailPhys) * 100.0) / ms.dwTotalPhys);
  FFreeMemoryPercent := trunc(((ms.dwAvailPhys) * 100.0) / ms.dwTotalPhys);
  FAvailMem := ms.dwAvailPhys;
  FTotalMem := ms.dwTotalPhys;
end;

constructor TMemoryResource.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
    FTimer := TTimer.Create(Self);
    FInterval := 100;
    FTimer.Enabled := True;
    FTimer.Interval := FInterval;
    FTimer.OnTimer := ATimer;
end;

destructor TMemoryResource.Destroy;
begin
    FTimer.Free;
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('JJW', [TMemoryResource]);
end;

end.
