unit TitleBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TTitlebar = class(TComponent)
  private
    { Private declarations }
    FTitleBarVisible: Boolean;
    FCreated: boolean;
  protected
    { Protected declarations }
    Procedure HideTitleBar;
    Procedure ShowTitleBar;
    procedure SetTitlebar(value: boolean);
    constructor create(aOwner : TComponent); override;
    Procedure Loaded; Override;
  public
    { Public declarations }
    Procedure Toggle;
  published
    { Published declarations }
    property Visible : boolean read FTitleBarVisible write SetTitlebar;
  end;

procedure Register;

implementation

constructor TTitleBar.Create(aOwner: TComponent);
begin
     inherited Create(aOwner);
     FTitlebarVisible := True;
end;

procedure TTitleBar.Toggle;
begin
     SetTitleBar(not FTitleBarVisible);
end;

procedure TTitlebar.SetTitlebar(value: boolean);
begin
     if not (csDesigning in componentstate) then
     begin
        if (value = True) then
           ShowTitleBar
        else HideTitleBar;
     end;
     FTitleBarVisible := Value;
end;


Procedure TTitleBar.HideTitlebar;
Var
  Save : LongInt;
  Form : TForm;
Begin
  Form := (Owner as TForm);
  if Form = nil then exit;
  with Form do
  begin
      case BorderStyle of
        bsNone,
        bsSizeToolWin,
        bsToolWindow: Exit;
      end;
      Save:=GetWindowLong(Handle,gwl_Style);
      If (Save and ws_Caption)=ws_Caption then Begin
        Case BorderStyle of
          bsSingle,
          bsSizeable : SetWindowLong(Handle,gwl_Style,Save and
            (Not(ws_Caption)) or ws_border);
          bsDialog : SetWindowLong(Handle,gwl_Style,Save and
            (Not(ws_Caption)) or ds_modalframe or ws_dlgframe);
        End;
      if not FTitleBarVisible then
      begin
           Height:=Height+getSystemMetrics(sm_cyCaption);
      end;
      Height:=Height-getSystemMetrics(sm_cyCaption);
      Refresh;
    End;
  End;
end;

procedure TTitleBar.Loaded;
var Form :TForm;
begin
 inherited Loaded;
end;

Procedure TTitleBar.ShowTitlebar;
Var
  Save : LongInt;
  Form : TForm;
begin
  if FTitleBarVisible then exit;
  Form := (Owner as TForm);
  if Form = nil then exit;
  with Form do
  begin
    If BorderStyle=bsNone then Exit;
    Save:=GetWindowLong(Handle,gwl_Style);
    If (Save and ws_Caption)<>ws_Caption then Begin
      Case BorderStyle of
        bsSingle,
        bsSizeable : SetWindowLong(Handle,gwl_Style,Save or ws_Caption or
          ws_border);
        bsDialog : SetWindowLong(Handle,gwl_Style,Save or ws_Caption or
          ds_modalframe or ws_dlgframe);
      End;
      if FTitleBarVisible then
      begin
           Height:=Height-getSystemMetrics(sm_cyCaption);
      end;
      Height:=Height+getSystemMetrics(sm_cyCaption);
      Refresh;
    End;
  End;
end;

procedure Register;
begin
  RegisterComponents('Form Tools', [TTitlebar]);
end;

end.



