{$A-,B-,D-,F-,G+,I-,K+,L-,N+,P+,Q-,R-,S-,T-,V+,W-,X+,Y-}
{=======================================================================}
{   TMREnter                                                            }
{                                                                       }
{   Autor : Martins(martins@mrw.com.br)                                 }
{                  (http://www.mrsoftware.com.br/user/martins)          }
{           10/08/1997                                                  }
{           So Paulo - Brazil                                          }
{                                                                       }
{   Colaboradores :                                                     }
{           Dennis Rosa (dra@svn.com.br)                                }
{           Mauricio Rother (mrother@plugon.com.br)                     }
{           Paulo H. Trentin (phtrentin@feob.br)                        }
{=======================================================================}
{ Historico                                                             }
{                                                                       }
{   30/05/2001 V 2.0                                                    }
{                                                                       }
{   Pessoal, o Lanamento da  versao 2.0 se deve ao fato de que         }
{   varias das mudancas foram significativas no funcionamento do        }
{   componente, claro que algumas coisas tambem foram bugs arrumados!   }
{                                                                       }
{   - ENTER --> ENTERENABLED                                            }
{     A Propriedade ENABLED foi alterada para ENTERENABLED              }
{     A funcionalidade permanece a mesma                                }
{                                                                       }
{   - COR EM FOCO                                                       }
{     Quando a cor de um determinado edit era mudada para a cor do      }
{     edit em foco, nao retornava mais para a cor original, ficava      }
{     sempre na cor branca, agora a cor original e' guardada e recu-    }
{     perada para o controle quando ele sai de foco.                    }
{                                                                       }
{   - SETA PARA CIMA EM GROUPBOX                                        }
{     Em alguns casos, normalmente quando os edits estao dentro de      }
{     containers como o GROUPBOX a seta para cima nao estava funcinando }
{     bem ... agora esta :))))                                          }
{                                                                       }
{   - EVENTO ONKEYDOWN                                                  }
{     Desde a criao do componente TMREnter eu tenho convivido com     }
{     um problema chato, e quando o programador quer codificar alguma   }
{     coisa no evento ONKEYDOWN para a tecla ENTER ??? Bem a situacao   }
{     agora  verificada, se o ENTER for precionado e existir algum     }
{     evento codifico em ONKEYDOWN o TMRENTER vai deixar passar esse    }
{     ENTER para o evento, fica entao ao encargo do programador passar  }
{     ou nao para o proximo controle.                                   }
{                                                                       }
{   - PROCESSAMENTO DE HINT                                             }
{     Agora existem mais duas propriedades no componente                }
{       HintEnabled - Indica que o componente vai processar o Hint      }
{       HintColor - Indica a cor que ser utilizada para mostrar o      }
{                   hint na tela                                        }
{     Este processamento de Hint se da quando o componente no form      }
{     recebe foco, independente se o Mouse esta ou nao sobre ele, isso  }
{     difere do comportamento tradicional do Hint, mas fica bem til    }
{     em uma digitacao em serie.                                        }
{                                                                       }
{   Bem, estas foram as alteracoes e os novos recursos que o componente }
{   agora tem, se tiverem ideias legais por favor mandem varios emails  }
{                                                                       }
{   []s Martins                                                         }
{                                                                       }
{                                                                       }
{   10/02/2001 V 1.8                                                    }
{                                                                       }
{   - so uma correcao de bug introduzido na retirada do plim            }
{   Preciso de novas ideias do que fazer com o componente  :))))        }
{                                                                       }
{   []s Martins                                                         }
{                                                                       }
{   21/12/2000 V 1.7                                                    }
{                                                                       }
{   - Foi implementada a capacidade de o ENTER funcionar como PROXI-    }
{     MA CELULA em um GRID.                                             }
{   - Aquele PLIM que ocorria hora ou outra foi suprimido.              }
{                                                                       }
{   []s Martins                                                         }
{                                                                       }
{   19/10/2000 V 1.6                                                    }
{   Como nada nesse mundo  perfeito eu tinha de deixar passar alguma   }
{   coisa errada.                                                       }
{                                                                       }
{   - quando maxlength estava setado e o usuario retornava no campo     }
{     usando Backspace ele pulava para o proximo campo                  }
{   - foi otimizado o reconhecimento da propriedade COLOR, no tem      }
{     mais flick.                                                       }
{   - FocusControl funciona com qualquer componente que tenha a pro-    }
{     priedade color e no apenas com TEdit e TDBEdit                   }
{                                                                       }
{   []s Martins                                                         }
{                                                                       }
{   17/10/2000 V 1.5                                                    }
{   Depois de um longo e tenebroso inverno eu consegui alterar algumas  }
{   coisas no componente, acho que esta melhor, testei por aqui nas     }
{   verses do Delphi 1,2,3,4 e 5  e esta funcionando legal, s em      }
{   Delphi 1 que nao esta l essas coisas, mas esta cada vez mais       }
{   dificil manter a compatibilidade ...                                }
{                                                                       }
{   Novas propriedades                                                  }
{     FocusEnabled                 Quando um TEdit ou TDBEdit           }
{                                  receber foco se deve destacar dos    }
{                                  demais                               }
{     FocusColor                   Cor de destaque                      }
{                                                                       }
{   As setas esto funcionando :)                                       }
{                                                                       }
{   Quando seleciona AutoSkip o proximo edit  selecionado quando o     }
{   edit atual esta totalmente completo e no no primeiro caracter do   }
{   proximo campo                                                       }
{   []s                                                                 }
{                                                                       }
{   22/05/1999 V 1.4                                                    }
{   Foi incluida uma nova funcionalidade, quando um derivado de TCustom }
{   edit chega ao final de seu limite do numero de caracteres ento ele }
{   passa para o prximo controle automaticamente.                      }
{   Para ativar esta funcionalidade deve-se setar AutoSkip para true, o }
{   default  false.                                                    }
{   Add('TRxDBLookupList');        Suporte aos componentes do RxLib     }
{   Add('TRxDBGrid');                                                   }
{   Add('TRxDBLookupCombo');       Paulo H. Trentin                     }
{   Add('TRxDBCalcEdit');          www.rantac.com.br/users/phtrentin    }
{   Add('TRxDBComboBox');                                               }
{   Add('TRxDBComboEdit');                                              }
{   Add('TDBDateEdit');                                                 }
{   Add('TRxCalcEdit');                                                 }
{   Add('TCurrencyEdit');                                               }
{   Add('TRxLookupEdit');                                               }
{                                                                       }
{   03/03/1999 V 1.3                                                    }
{   Foi incluida uma propriedade chamada                                }
{   KeyBoardArrows : Boolean                                            }
{   esta propriedade quando true permite voltar um componente ou avanar}
{   utilizando as setas no teclado, simulando TAB e SHIFT TAB           }
{   Infelizmente estou tendo problemas para simular o SHIFT TAB em D1   }
{   mas funciona perfeitamente em D2, D3 e D4 ...                       }
{   Como diversas pessoas utilizam o InfoPower os seus componentes mais }
{   comuns foram incluidos automaticamente no create                    }
{   TwwDBGrid                      Suporte aos componentes do InfoPower }
{   TwwDBEdit                      J que tem um monte de gente que usa }
{   TwwDBComboBox                  achei por bem deixar todos dispon-  }
{   TwwDBSpinEdit                  veis durante a criao do componen-  }
{   TwwDBComboDlg                  te, assim como os outros ....        }
{   TwwDBLookupCombo                                                    }
{   TwwDBLookupComboDlg            ideia do Dennis ...                  }
{   TwwIncrementalSearch           valeu ...                            }
{   TwwDBRitchEdit                 02/03/1999                           }
{   TwwKeyCombo                                                         }
{   Neste pacote esta sendo uncluido um arquivo .RES com um icone de    }
{   instalao do componente que foi feito pelo Mauricio                }
{   Este arquivo esta em 16 bits por motivo de compatibilidade, caso    }
{   o seu Delphi seja de 32 bits, abra o arquivo no Image Editor e      }
{   salve novamente. Valeu Mauricio...                                  }
{                                                                       }
{   17/10/1998 V 1.2                                                    }
{   Atendendo pedidos, outros eventos foram incluidos                   }
{                                                                       }
{   OnHint                                                              }
{   OnHelp                                                              }
{                                                                       }
{   03/10/1998 V 1.1                                                    }
{   Foram incluidos os eventos padro de TApplication, assim            }
{   pode-se escrever diretamente para estes eventos e no mais          }
{   apenas via codigo. So eles ...                                     }
{                                                                       }
{   OnMessage                                                           }
{   OnIdle                                                              }
{                                                                       }
{   13/09/1998                                                          }
{   Substitui a ao da tecla TAB por um ENTER em todos os forms        }
{   pertencentes a TApplication.                                        }
{                                                                       }
{   ClassList                                                           }
{   Armazena os nomes das classes em que este componente vai            }
{   atuar, as classes abaixo j esto registradas de fabrica :)         }
{                                                                       }
{   TMaskEdit                                                           }
{   TEdit                                                               }
{   TDBEdit                                                             }
{   TDBCheckBox                                                         }
{   TTabbedNoteBook                                                     }
{   TDBCheckDocEdit                                                     }
{   TMRDBExtEdit                                                        }
{   TDBDateEdit                                                         }
{=======================================================================}
{   NOTA                                                                }
{   Obrigado a todos os amigos que mandaram suas ideias e colaboraes, }
{   claro que todos temos nossos compromissos e dedicar um pouco do     }
{   tempo de vocs para colaborar com o desenvolvimento deste componen- }
{   te me deixa muito orgulhoso dos amigos que tenho e me lembra que a  }
{   vida  feita de atitudes e no apenas de boas intenes.            }
{                                                                       }
{   Um grande abrao a todos ...                                        }
{   Martins                                                             }
{   martins@mrsoftware.com.br                                           }
{=======================================================================}

unit Enterreg;

interface

uses
  Messages, WinTypes, WinProcs, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Dsgnintf;

procedure Register;

implementation

uses
  enter, ShellApi;

type

  { TAboutProperty }
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function  GetAttributes: TPropertyAttributes; override;
    function  GetValue : string; override;
  end;

  { TMRLinkLabelEditor }
  TMREnterEditor = class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

const
  IdVersion = '2.0';

{ ----------- }
  procedure GeneralShowAbout;
{ ----------- }
var
  msg: array[0..200] of Char;
begin
  StrPCopy(msg, 'TMREnter '+IdVersion+#13 +
                'Copyright '#169' 1998-2001 by Martins'#13#13+
                'Colaboradores'#13+
                '   Dennis Rosa (dra@svn.com.br)'#13+
                '   Mauricio Rother (mrother@plugon.com.br)'#13+
                '   Paulo H. Trentin (phtrentin@feob.br)');
  MessageBox(Application.Handle,msg, 'About TMREnter', MB_ICONINFORMATION);
end;

(* ================================================================
   TMREnter AboutProperty
   ================================================================ *)

{ ----------- }
  procedure TAboutProperty.Edit;
{ ----------- }
begin
  GeneralShowAbout;
end;

{ ----------- }
  function TAboutProperty.GetAttributes: TPropertyAttributes;
{ ----------- }
begin
  GetAttributes := [paDialog, paReadOnly];
end;

{ ----------- }
  function TAboutProperty.GetValue: String;
{ ----------- }
begin
  GetValue := '(About)';
end;


(* ================================================================
   TMREnterEditor
   ================================================================ *)

{ ----------- }
  procedure TMREnterEditor.ExecuteVerb(Index: Integer);
{ ----------- }
var
  pchAutorEmail    : array[0..80] of char;
  pchAutorHomePage : array[0..80] of char;
begin
  StrPCopy(pchAutorEmail,'mailto:martins@mrw.com.br?Subject=TMREnter user ...');
  StrPCopy(pchAutorHomePage,'http://www.mrsoftware.com.br/user/martins');
  case Index of
    0: GeneralShowAbout;
    3: ShellExecute(0,'Open',pchAutorEMail,nil,nil,Ord(sw_ShowNormal));
    4: ShellExecute(0,'Open',pchAutorHomePage,nil,nil,Ord(sw_ShowNormal));
  end;
end;

{ ----------- }
  function TMREnterEditor.GetVerb(Index: Integer): string;
{ ----------- }
begin
  case Index of
    0: Result := 'About TMREnter '+IdVersion;
    1: Result := '-';
    2: Result := 'Copyright '#169' 1998-2001 Martins';
    3: Result := 'Registre-se como usurio ...';
    4: Result := 'Visite Martins Delphi Page ...';
  end;
end;

{ ----------- }
  function TMREnterEditor.GetVerbCount: Integer;
{ ----------- }
begin
  Result := 5;
end;


procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TMREnter, 'About', TAboutProperty);
  RegisterComponentEditor(TMREnter, TMREnterEditor);
  RegisterComponents('MR', [TMREnter]);
end;

end.

