unit StackTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Stacks, Buttons;

type
  TForm1 = class(TForm)
    PushBtn: TButton;
    Edit1: TEdit;
    PopBtn: TButton;
    Edit2: TEdit;
    Memo1: TMemo;
    StackLabel: TLabel;
    CloseBtn: TBitBtn;
    cbInteger: TCheckBox;
    cbReal: TCheckBox;
    cbCurrency: TCheckBox;
    CheckBoxLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    procedure PushBtnClick(Sender: TObject);
    procedure PopBtnClick(Sender: TObject);
  private
    { Private declarations }
    FCount: word;                 // Number of lines in Memo1.
    FIntegerTotal: integer;       // Total of popped integers
    FFloatTotal: extended;        // Total of popped Floats
    FCurrencyTotal : currency;    // Total of popped Currencies
  public
    { Public declarations }
    property Count : word read FCount write FCount;
    property IntegerTotal: integer read FIntegerTotal write FIntegerTotal;
    property FloatTotal: extended read FFloatTotal write FFloatTotal;
    property CurrencyTotal : currency read FCurrencyTotal write FCurrencyTotal;
  end;

var
  Form1: TForm1;
{ Do not add "Stack : TStack" since Stack.pas creates global object: Stack. }

implementation

{$R *.DFM}

procedure TForm1.PushBtnClick(Sender: TObject);
begin
  if Edit1.Text <> '' then
    Stack.push(Edit1.Text);
  // return for more input
  Edit1.setfocus;
  Memo1.Lines.Insert(0, Edit1.Text);
  Edit1.Text := '';
  Count := Count + 1;
end;

procedure TForm1.PopBtnClick(Sender: TObject);
begin
  // Can only have one checkbox checked
  if (cbInteger.checked and cbReal.checked) or
     (cbInteger.checked and cbCurrency.checked) or
     (cbReal.checked    and cbCurrency.checked) then
     begin
       MessageDlg('You can only check one checkbox', mtInformation,
         [mbOK], 0);
       Exit;
     end;
  Edit2.Text := Stack.pop;
  Memo1.Lines.Delete(0);
  Count := Count - 1;
  if cbInteger.checked then
    begin
      IntegerTotal := IntegerTotal + StrToInt(Edit2.Text);
      showMessage('Total is ' + IntToStr(IntegerTotal));
    end;
  if cbReal.checked then
    begin
      FloatTotal := FloatTotal + StrToFloat(Edit2.Text); //returns extended
      showMessage('Total is ' + FloatToStrF(FloatTotal, ffFixed,
                                             18, 4));
    end;
  if cbCurrency.checked then
    begin
      CurrencyTotal := CurrencyTotal + StrToFloat(Edit2.Text);
      showMessage('Total is ' + FloatToStrF(CurrencyTotal, ffCurrency,
                                             18, 2));
    end;
  if Stack.StackEmpty then    // reset all totals
    begin
      IntegerTotal  := 0;
      FloatTotal   := 0;
      CurrencyTotal := 0;
    end;
end;

end.
