program SMTP;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  sockets,
  WINDOWS;

VAR
   COMANDO, PARAMETRO:STRING;
begin
  SetConsoleTextAttribute( GetStdHandle(STD_OUTPUT_HANDLE),
                                                           FOREGROUND_RED OR
                                                           FOREGROUND_GREEN OR
                                                           FOREGROUND_BLUE OR
                                                           BACKGROUND_RED);
     WRITELN('Terminal SMTP - by Paulo Henrique');
     WRITELN(#10+#13+'COMANDOS DISPONIVEIS:');
     WRITELN('---------------------');
     WRITELN('PORTA?');
     WRITELN('PORTA [NUMERO]');
     WRITELN('CONECTAR <SERVIDOR>');
     WRITELN('SITUACAO');
     WRITELN('MENU');
     WRITELN('AJUDA');
     WRITELN('SAIR');
     WRITELN('--------------------'+#10+#13+#13);
  SetConsoleTextAttribute( GetStdHandle(STD_OUTPUT_HANDLE),
                                                           FOREGROUND_GREEN OR
                                                           FOREGROUND_BLUE);
     //A rotina abaixo verifica se foi passado algum
     //parmetro ao prog
     If ParamCount > 0 then
        begin
     //se foi,  o endereo de algum servidor
             COMANDO:='CONNECTAR '+ PARAMSTR(1);
             WRITELN(COMANDO);
        END
        ELSE COMANDO:='';
     //LOOP DO PROGRAMA
     REPEAT
     {SE NO FOI PASSADO ALGUM PARMETRO, AGUARDA A ENTRADA
     DO USURIO}
        IF COMANDO='' THEN READLN(COMANDO);
     {Elimina todos os eventuais espaos duplicados, deixando
     apenas um entre cada palavra}
        while POS(#32#32, COMANDO) > 0 DO
           DELETE(COMANDO, POS(#32#32, COMANDO),1);
     //SAI DO PROG SE O USURIO DIGITOU EXIT
        IF UPPERCASE(COMANDO)='SAIR' THEN BREAK;
     //V SE EST CONECTADO
        IF NOT MAINTHREAD.CONNECTED THEN BEGIN
     //Se estiver conectado, ento todos os
     //comandos sero enviados para o servidor
           COMANDO:=TRIM(COMANDO);
     //ELIMINA OS ESPAOS ANTES E DEPOIS DO CMD
     //E VERIFICA SE O COMANDO  CONNECTAR
           IF COPY(UPPERCASE(COMANDO), 1,9)='CONECTAR ' THEN
             BEGIN
     //SE FOR, APAGA-O E PARA FICAR S O SERVIDOR
                DELETE(COMANDO, 1, 9);
                PARAMETRO:=TRIM(COMANDO);
     //L O ENDEREO DO SERVIDOR
                IF PARAMETRO<>'' THEN
     //CONECTA ! ! !
                   MAINTHREAD.CONNECT(PARAMETRO)
                ELSE
     //O USURIO NO DIGITOU O ENDEREO DO SERVIDOR
                   WRITELN(#13#10, 'Informe o servidor SMTP (EX.: www.zipmail.com.br)'+#10+#13+#13)
                end else
                if uppercase(COMANDO)='SITUACAO' THEN
                  IF MAINTHREAD.CONNECTED THEN
     //ENTO EXIBE O STATUS DA CONEXO
                     WRITELN(#13#10, 'CONECTADO AO SERVIDOR', MAINTHREAD.HOST, '.')
                  ELSE WRITELN(#13#10, 'DESCONECTADO!'+#10+#13+#13)
                ELSE
     //O COMMANDO  PARA ESPECIFICAR A PORTA?
                  IF UPPERCASE(COPY(COMANDO,1,6))='PORTA ' THEN
                  BEGIN
     //PEGA O N DA PORTA
                     PARAMETRO:=TRIM(COPY(COMANDO,7,LENGTH(COMANDO)));
                     IF PARAMETRO<>'' THEN
     //O USURIO INFORMOU O NOVO N DA PORTA?
                       TRY
                         PORTA:=STRTOINT(PARAMETRO); //tenta a converso
                       EXCEPT
     //se no converteu
                         WRITELN('VALOR INVLIDO!+#10+#13+#13');
                       END;
                       WRITELN('PORTA = ', PORTA);
     //EXIBE O N DA PORTA ATUAL
                  END ELSE
                  IF UPPERCASE(COPY(COMANDO,1,6))='PORTA?' THEN
                  BEGIN
     //EXIBE O N DA PORTA ATUAL
                     WRITELN('PORTA = ', PORTA);
                  END ELSE
     {O USURIO DIGITOU HELP MAS NO EST CONECTADO}
                  IF UPPERCASE(COMANDO)='AJUDA' THEN BEGIN
                        WRITELN(#10+#13+#13+'COMANDOS DISPONIVEIS:');
                        WRITELN(#13+'--------------------');
                        WRITELN('PORTA? (Exibe a porta utilizada)');
                        WRITELN('PORTA [NUMERO] (Ex.: PORTA 25);');
                        WRITELN('CONECTAR <SERVIDOR> (Ex.: CONECTAR WWW.ZIPMAIL.COM.BR);');
                        WRITELN('SITUACAO');
                        WRITELN('MENU');
                        WRITELN('SAIR');
                        WRITELN('-------------------'#10#13#13);
                        WRITELN('COMANDOS SMTP:');
                        WRITELN(#13+'--------------------');
                        WRITELN('MAIL FROM: <e-mail do remetente> <ENTER>');
                        WRITELN('RCPT TO: <e-mail do destinatrio> <ENTER para cada destinatario>');
                        WRITELN('DATA <ENTER>');
                        WRITELN('[Cabecalho] <ENTER para cada linha do cabecalho>');
                        WRITELN('[Mudanca de linha] <ENTER>');
                        WRITELN('[Texto da Mensagem] <ENTER para cada linha do texto da mensagem>');
                        WRITELN('[Fim da mensagem] . <ENTER>');
                        WRITELN('-------------------'#10#13#13);
                  END ELSE
     {O USURIO DIGITOU HELP MAS NO EST CONECTADO}
                  IF UPPERCASE(COMANDO)='MENU' THEN BEGIN
                        WRITELN(#10+#13+#13+'COMANDOS DISPONIVEIS:');
                        WRITELN(#13+'--------------------');
                        WRITELN('PORTA? (Exibe a porta utilizada)');
                        WRITELN('PORTA [NUMERO] (Ex.: PORTA 25);');
                        WRITELN('CONECTAR <SERVIDOR> (Ex.: CONECTAR WWW.ZIPMAIL.COM.BR);');
                        WRITELN('SITUACAO');
                        WRITELN('MENU');
                        WRITELN('AJUDA');
                        WRITELN('SAIR');
                        WRITELN('-------------------'#10#13);
                  END ELSE
     //DIGITOU UM COMANDO DESCONHECIDO
     //NO EST CONECTADO
                  IF COMANDO<>'' THEN
                    WRITELN(#13#10, 'COMANDO INEXISTENTE: "', COMANDO, '"!'+#10+#13+#13);
                  END ELSE
     //O USURIO DIGITOU UM COMANDO QUALQUER, EST CONECTADO E ESTE
     //COMANDO SER ENVIADO AO SERVIDOR
                     MAINTHREAD.SEND(COMANDO+ #13#10);
     //LIMPA A VARIVEL
                     COMANDO:='';
     UNTIL FALSE;
end.
 