program pYAFTP;
{
   This is the project file of pBoy's Yet Another FTP Client.
   Version number 1.0.3e, rev. extended essay edition

   Created by Pter Karsai, 1999.

   READ "README.TXT" FOR THE MODIFIED LICENCE AGREEMENT.
   IN SECTION "MODIFIED LICENCE AGREEMENT" YOU'LL FIND THE ONLY ONE
   VALID LICENCE AGREEMENT. ALL OTHER LICENCING, ORDERING INFORMATION ARE IGNORED.

}

uses
  Forms, WinTypes, Dialogs, Windows,
  FTPFormUnit in 'forms-[all]\FTPFormUnit.pas' {FTPForm},
  FTPFormTools in 'forms-[all]\FTPFormTools.pas',
  ControlConnection in 'external_classes-[source]\ControlConnection.pas',
  DataConnection in 'external_classes-[source]\DataConnection.pas',
  DirList in 'external_classes-[source]\DirList.pas',
  FTPCacheManager in 'external_classes-[source]\FTPCacheManager.pas',
  FTPSession in 'external_classes-[source]\FTPSession.pas',
  Tokenizer in 'external_classes-[source]\Tokenizer.pas',
  TransferFormUnit in 'forms-[all]\TransferFormUnit.pas' {TransferForm},
  SetupFormUnit in 'forms-[all]\SetupFormUnit.pas' {SetupForm},
  TransferRequestFormUnit in 'forms-[all]\TransferRequestFormUnit.pas' {TReqF},
  ResumeFormUnit in 'forms-[all]\ResumeFormUnit.pas' {TransResForm},
  LogoFormUnit in 'forms-[all]\LogoFormUnit.pas' {LogoForm},
  AboutFormUnit in 'forms-[all]\AboutFormUnit.pas' {AboutForm},
  CreateFolderFormUnit in 'forms-[all]\CreateFolderFormUnit.pas' {CreateFForm};

{$R *.RES}
{------------------------------------------------------------------------------}

procedure CreateForm(ClassName: TFormClass; var InstanceName; StateMsg: string);
begin
{ show current state }
    LogoForm.ShowState(StateMsg);
{ create form }
    Application.CreateForm(ClassName, InstanceName);
end;

{------------------------------------------------------------------------------}

var hWND: THandle;  { handle for lookin' other instances of YAFTP }
begin
{ preventing to run multiple instances - find a window with same name. This
  method of multiple instance detecting doesn't work in Delphi IDE. }
    hWND:= FindWindow('TFTPForm', nil);
{ if there's another window with same name, sure, we have another instance. }
    if hWND <> 0 then
    begin
        MessageDlg('You can''t run YAFTP in multiple instances.',
                   mtError, [mbOk], 0);
        SetForegroundWindow(hWND);  { set first instance to be focused }
        exit;
    end;

{ initialize application }
    Application.Initialize;
    Application.Title := 'pBoy''s Yet Another FTP Client';

{ create main form, LogoForm, this form will appear while application start up }
    Application.CreateForm(TLogoForm, LogoForm);
    LogoForm.ApplicationStarted:= false;  { don't let hide LogoForm }
    LogoForm.Show;
    Application.ProcessMessages; { let Windows to show LogoForm }

{ create other forms... it takes a while }
    CreateForm(TFTPForm, FTPForm, 'Creating main form...');
    CreateForm(TSetupForm, SetupForm, 'Creating Preferences form...');
    CreateForm(TTransferForm, TransferForm, 'Creating Transfer form...');
    CreateForm(TTransReqForm, TransReqForm, 'Creating other forms...');
    CreateForm(TTransResForm, TransResForm, 'Creating other forms...');
    CreateForm(TCreateFolderForm, CreateFolderForm, 'Creating other forms...');
    CreateForm(TAboutForm, AboutForm, 'Creating AboutBox...');

{ load initial settings and show FTPForm }
    LogoForm.ShowState('Loading initial settings...');
    FTPFTools.LoadInitSettings;          { load init settings }
    LogoForm.ApplicationStarted:= true;  { now we can hide LogoForm }
    FTPForm.Show;                        { show real main form }
    LogoForm.ShowState('');              { no state... application started }
    Application.ProcessMessages; { let Windows to show FTPForm while GC runs }

{ run garbage collector if needed }
    if SetupForm.SetupData.sGCStartup then FTPFTools.RunGC;

{ run application }
    Application.Run;
    { ...and that's all folks :) }
end.
