unit Psutils;

interface

function CheckCRLF( var s: string): boolean;
function Copy2( Src: string; From, Count:integer): string;
function IsIP( S: string): boolean;
function IsPort( S: string): boolean;
function GetIP( s: string): string;
function GetPort( S: string): integer;

implementation
uses Sysutils;

function CheckCRLF( var s: string): boolean;
var i: integer;
begin
   Result := false;
   i := length(s);
   if i >= 2 then begin
     if (s[i] = ^J) and (s[pred(i)]=^M) then delete( s, i-1, 2);
     Result := true
   end
end;

function Copy2( Src: string; From, Count:integer): string;
begin
   if Count = 0 then Result := ''
   else begin
     if (Src[From + Count-1] = ^J) then begin
        dec(Count);
        if (Count > 0) and (Src[From + Count-1] = ^M) then dec(Count);
     end
     else if (Src[From + Count-1] = ^M) then dec(Count);
     Result := copy( Src, From, Count)
   end
end;

function IsIP( S: string): boolean;
var i,j,ii: integer;
begin
   Result := false;
   i := pos( ' ', s);
   while i > 0 do begin
      delete( s, i, 1);
      i := pos( ' ', s);
   end;
   j := 0;
   ii := 0;
   for i := 1 to length(s) do
      if s[i] = '.' then
        if i = succ(ii) then exit
        else begin
          inc(j);
          ii := i;
        end;
   if j = 3 then Result := true;
end;

function GetIP( s: string): string;
var i: integer;
begin
   i := pos( ' ', s);
   while i > 0 do begin
      delete( s, i, 1);
      i := pos( ' ', s);
   end;
   Result := s
end;

function IsPort( S: string): boolean;
var i: integer;
begin
   i := pos( ' ', s);
   while i > 0 do begin
      delete( s, i, 1);
      i := pos( ' ', s);
   end;
   Result := true;
   try
     i := strtoint(s);
   except
     Result := false;
   end
end;

function GetPort( S: string): integer;
var i: integer;
begin
   i := pos( ' ', s);
   while i > 0 do begin
      delete( s, i, 1);
      i := pos( ' ', s);
   end;
   try
     Result := strtoint(s);
   except
     Result := 0;
   end
end;

end.
