unit Semelha;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables;

type
  tTipoSQL  = (Access, Paradox);

  TSemelha = class(TComponent)
  private
    vTipoSQL : tTipoSQL;
    vaVersao: String;
    fTabela: TTable;
    fFiltro: String;
    fCmpDig: String;
    fPosCampo: Integer;
    procedure SetTabela(value: TTable);
    function GetaVersao: String;
  protected
    { Protected declarations }
  public
    function Execute: Boolean;
  published
    property aVersao: String read GetaVersao write vaVersao;
    property Tabela: TTable read fTabela write SetTabela;
    property CmpDig: String read fCmpDig write fCmpDig;
    property Filtro: String read fFiltro write fFiltro;
    property PosCampo: Integer read fPosCampo write fPosCampo;
    property TipoSQL: tTipoSQL read vTipoSQL write vTipoSQL
      default Paradox;
  end;

procedure Register;

implementation

uses
  fSemelh;

procedure Register;
begin
  RegisterComponents('Dialogs', [TSemelha]);
end;

function TSemelha.GetaVersao: String;
begin
  Result := '1.02';
end;

{ Inclui as tabelas }
procedure TSemelha.SetTabela(value: TTable);
begin
  if value <> fTabela then fTabela := value;
end;

function TSemelha.Execute: Boolean;
begin
  F_Semelh := TF_Semelh.Create(Application);
  with F_Semelh do begin
    DSPesquisa.DataSet := Tabela;
    Filtra   := Filtro;
    NumCampo := fPosCampo;
    nTipoSQL := vTipoSQL;
    Result   := (Execute(fCmpDig) = IDOK);
    Hide;
    Free;
  end;
end;

end.
