unit Fsemelh;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, DBTables, Semelha;

type
  TF_Semelh = class(TForm)
    Label1: TLabel;
    LstSemelhante: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    QryPesquisa: TQuery;
    DSPesquisa: TDataSource;
    Table1: TTable;
    Table1No_Atividade: TFloatField;
    Table1Ds_Atividade: TStringField;
  private
    NmCampo : String;
    function DevCampo : String;
    function SetFiltro : String;
    procedure TipoCampo;
  public
    nTipoSQL : tTipoSQL;
    Filtra, CampoA: String;
    NumCampo : Integer;
    function Execute(var CmpDev : String) : Integer;
  end;

var
  F_Semelh: TF_Semelh;

implementation

{$R *.DFM}

function TF_Semelh.SetFiltro : String;
begin
  result := '';
  if filtra <> '' then
    result := 'AND (' + filtra + ')';
end;

function TF_Semelh.DevCampo : String;
begin
  with QryPesquisa do
    case Fields[NumCampo].DataType of
      ftDate, ftTime,
      ftDateTime : Result := DateTimeToStr(FieldByName(NmCampo).AsDateTime);
      ftInteger  : Result := IntToStr(FieldByName(NmCampo).AsInteger);
      ftBytes, ftVarBytes,
      ftFloat    : Result := FloatToStr(FieldByName(NmCampo).AsFloat);
    else
      Result := FieldByName(NmCampo).AsString;
    end
end;

procedure TF_Semelh.TipoCampo;
begin
  try
    with (DSPesquisa.DataSet as TTable) do
      case Fields[NumCampo].DataType of
        ftDate, ftTime,
        ftDateTime: QryPesquisa.Params[0].AsDateTime := StrToDateTime(CampoA);
        ftInteger : QryPesquisa.Params[0].AsInteger := StrToInt(CampoA);
        ftBytes, ftVarBytes,
        ftFloat   : QryPesquisa.Params[0].AsFloat := StrToFloat(CampoA);
      else
        if nTipoSQL = Access then
          QryPesquisa.Params[0].AsString := CampoA + '*'
        else
          QryPesquisa.Params[0].AsString := CampoA + '%';
      end
  except
    raise Exception.Create('Valor no encontrado');
  end;
end;

function TF_Semelh.Execute(var CmpDev : String) : Integer;
var
  i : integer;
begin
  // Seta os Parmetros do SQL
  with (DSPesquisa.DataSet as TTable) do
  begin
    QryPesquisa.DataBaseName := DataBaseName;
    QryPesquisa.SQL.Clear;
    QryPesquisa.SQL.Add('SELECT * FROM ' + TableName);
    case Fields[NumCampo].DataType of
      ftInteger, ftBytes, ftVarBytes,
      ftFloat : QryPesquisa.SQL.Add('WHERE ' + Fields[NumCampo].FieldName + ' = :Campo'
                + SetFiltro);
    else
      CampoA := Trim(CmpDev);
        if nTipoSQL = Access then
          QryPesquisa.SQL.Add('WHERE (UCase(' + Fields[NumCampo].FieldName
            + ') Like UCase(:Campo))' + SetFiltro)
        else
          QryPesquisa.SQL.Add('WHERE (Upper(' + Fields[NumCampo].FieldName
            + ') Like Upper(:Campo))' + SetFiltro);
    end;
  end;
  TipoCampo;
  with QryPesquisa do
  begin
    Open;
    First;
    if EOF then
    begin
      Result := mrCancel;
      exit;
    end;
    NmCampo := Fields[NumCampo].FieldName;
  end;
  // Carrega a Lista
  with LstSemelhante do
  begin
    Items.Clear;
    repeat
      Items.Add(DevCampo);
      QryPesquisa.Next;
    until QryPesquisa.EOF;
    ItemIndex := 0;
    Result := ShowModal;
    // Caso Ok verifica o novo cdigo digitado
    if (Result = IDOK) then
      for i := 0 to (Items.Count - 1) do
        if Selected[i] then
        begin
          CmpDev := Items[i];
          exit;
        end;
  end;
end;

end.
