unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls, QRPrntr;

type
  TfrmPreview = class(TForm)
    QRPreview1: TQRPreview;
    Panel1: TPanel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Edit1: TEdit;
    sbFirst: TSpeedButton;
    sbPrior: TSpeedButton;
    sbNext: TSpeedButton;
    sbLast: TSpeedButton;
    sbPrintSetup: TSpeedButton;
    sbPrint: TSpeedButton;
    sbClose: TSpeedButton;
    Label2: TLabel;
    Label3: TLabel;
    procedure ComboBox1Change(Sender: TObject);
    procedure sbFirstClick(Sender: TObject);
    procedure sbPriorClick(Sender: TObject);
    procedure sbNextClick(Sender: TObject);
    procedure sbLastClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure sbPrintSetupClick(Sender: TObject);
    procedure sbPrintClick(Sender: TObject);
    procedure sbCloseClick(Sender: TObject);
    procedure QRPreview1PageAvailable(Sender: TObject; PageNum: Integer);
  private
    { Private declarations }
  public
    procedure ChecaPaginas;
  end;

var
  frmPreview: TfrmPreview;

implementation

{$R *.DFM}

procedure TfrmPreview.ChecaPaginas;
begin
  Edit1.Text := Inttostr(qrPreview1.PageNumber);
  Label1.Caption := ' de '+Inttostr(qrPreview1.qrPrinter.PageCount);

  sbFirst.Enabled:=(QrPreview1.PageNumber > 1);
  sbPrior.Enabled:= (qrPreview1.PageNumber > 1);
  sbNext.Enabled:=(QrPreview1.PageNumber < qrPreview1.qrPrinter.PageCount);
end;

procedure TfrmPreview.ComboBox1Change(Sender: TObject);
begin
  try
    qrPreview1.Zoom := StrToInt(ComboBox1.text);
    except
  End;
end;

procedure TfrmPreview.sbFirstClick(Sender: TObject);
begin
  qrPreview1.PageNumber:=1;
  ChecaPaginas;
end;

procedure TfrmPreview.sbPriorClick(Sender: TObject);
begin
  qrPreview1.PageNumber:= QrPreview1.pageNumber-1;
  ChecaPaginas;
end;

procedure TfrmPreview.sbNextClick(Sender: TObject);
begin
  qrPreview1.PageNumber := qrPreview1.PageNumber+1;
  ChecaPaginas;
end;

procedure TfrmPreview.sbLastClick(Sender: TObject);
begin
  QrPreview1.Pagenumber := QrPreview1.QRPrinter.PageCount;
  ChecaPaginas;
end;

procedure TfrmPreview.Edit1Change(Sender: TObject);
begin
  try
    qrPreview1.PageNumber:=StrToInt(Edit1.Text);
    except
  End;
end;

procedure TfrmPreview.sbPrintSetupClick(Sender: TObject);
begin
  qrPreview1.qrPrinter.PrintSetup
end;

procedure TfrmPreview.sbPrintClick(Sender: TObject);
begin
  qrPreview1.qrPrinter.Print
end;

procedure TfrmPreview.sbCloseClick(Sender: TObject);
begin
  close
end;

procedure TfrmPreview.QRPreview1PageAvailable(Sender: TObject;
  PageNum: Integer);
begin
  checapaginas;
end;

end.
