unit PJALixo;

interface

uses
  ShellApi, Classes, Forms;

type
  TPJALixeira = class(TComponent)
  private
    { Private declarations }
    FArquivo : String;
    FConfirmar : Boolean;
    FMostraProgresso : Boolean;
    FMostraNome : Boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    function Enviar : Boolean;
  published
    { Published declarations }
    property Arquivo : String read FArquivo write FArquivo;
    property Confirmar : Boolean read FConfirmar write FConfirmar;
    property MostraProgresso : Boolean read FMostraProgresso write FMostraProgresso;
    property MostraNome : Boolean read FMostraNome write FMostraNome;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PJA Sistemas', [TPJALixeira]);
end;

{
   Funo Enviar -> Envia o arquivo especificado em FArquivo para a Lixeira

   Retorno :
             True = Tudo OK
             False = Erro
}
function TPJALixeira.Enviar : Boolean;
var
  fos : TSHFileOpStruct;
begin
  FillChar( fos, SizeOf( fos ), 0 );
  with fos do
  begin
    Wnd := (Owner as TForm).Handle;
    wFunc  := FO_DELETE;
    pFrom  := PChar( FArquivo );
    fFlags := FOF_ALLOWUNDO;
    lpszProgressTitle := 'Teste !!!';
    { Se no confirma ... }
    if not FConfirmar then
       fFlags := fFlags or FOF_NOCONFIRMATION;
    { Se no mostra progresso ... }
    if not FMostraProgresso then
       fFlags := fFlags or FOF_SILENT
    { Se mostra progresso e no mostra nome ... }
    else if not FMostraNome then
       fFlags := fFlags or FOF_SIMPLEPROGRESS;
  end;
  Result := ( 0 = ShFileOperation( fos ) );
end;

end.
