{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{*******************************************************}

{
You can download the latest version of PHP from
http://www.php.net/downloads.php
You have to download and install PHP separately.
It is not included in the package.

For more information on the PHP Group and the PHP project,
please see <http://www.php.net>.
The PHP Licence is available at through the world-wide-web at
http://www.php.net/license/2_02.txt.

This unit was tested with PHP 4.2.0
}
unit psvPHP;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  php4Delphi;
type

  TPHPVariable = class(TCollectionItem)
  private
    FName : string;
    FValue : string;
  published
    property Name  : string read FName write FName;
    property Value : string read FValue write FValue;
  end;

  TPHPVariables = class(TCollection)
  private
    FOwner : TComponent;
    procedure SetItem(Index: Integer; const Value: TPHPVariable);
    function  GetItem(Index: Integer): TPHPVariable;
  protected
    function  GetOwner : TPersistent; override;
  public
    function Add: TPHPVariable;
    constructor Create(AOwner: TComponent);
    function GetVariables : string;
    property Items[Index: Integer]: TPHPVariable read GetItem write SetItem; default;
  end;

  TpsvPHP = class(TComponent)
  private
    FVariables : TPHPVariables;
    FBuffer : string;
    FFileName : string;
    procedure SetVariables(Value : TPHPVariables);
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    function Execute : string;
  published
    property Variables : TPHPVariables read FVariables write SetVariables;
    property FileName : string read FFileName write FFileName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TpsvPHP]);
end;

{ TPHPVariables }

function TPHPVariables.Add: TPHPVariable;
begin
  result := TPHPVariable(inherited Add);
end;

constructor TPHPVariables.Create(AOwner: TComponent);
begin
 inherited create(TPHPVariable);
 FOwner := AOwner;
end;

function TPHPVariables.GetItem(Index: Integer): TPHPVariable;
begin
  Result := TPHPVariable(inherited GetItem(Index));
end;

procedure TPHPVariables.SetItem(Index: Integer; const Value: TPHPVariable);
begin
  inherited SetItem(Index, Value)
end;

function TPHPVariables.GetOwner : TPersistent;
begin
  Result := FOwner;
end;

function TPHPVariables.GetVariables: string;
var i : integer;
begin
  for i := 0 to Count - 1 do
    begin
      Result := Result + Items[i].FName + '=' + Items[i].FValue;
      if i < Count - 1 then
        Result := Result + '&';
    end;
end;

{ TpsvPHP }

constructor TpsvPHP.Create(AOwner: TComponent);
begin
  inherited;
  FVariables := TPHPVariables.Create(Self);
end;

destructor TpsvPHP.Destroy;
begin
  FVariables.Free;
  inherited;
end;

function TpsvPHP.Execute : string;
begin
  try
    if PHPLoaded then
     begin
       RegisterVariables(PChar(FVariables.GetVariables));
       FBuffer := RunPHPScript(FFileName);
       Result := FBuffer;
     end;
  except
    Result := '';
  end;
end;

procedure TpsvPHP.SetVariables(Value: TPHPVariables);
begin
  FVariables.Assign(Value);
end;

end.
