{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{*******************************************************}

{
You can download the latest version of PHP from 
http://www.php.net/downloads.php
You have to download and install PHP separately.
It is not included in the package.

For more information on the PHP Group and the PHP project, 
please see <http://www.php.net>.
The PHP Licence is available at through the world-wide-web at
http://www.php.net/license/2_02.txt.

This unit was tested with PHP 4.2.0
}

unit PHP4Delphi;

interface
uses
  Windows;

type

//register global variables BEFORE executing the PHP script
//Ex:
//RegisterVariables('var1=val1&variable2=value2&name=me);
TRegisterVariables = procedure (VarString : PChar) ; stdcall;

//returns the value of global variable by name
TGetVar = function (VarName : PChar) : PChar ; stdcall;

var
 RegisterVariables : TRegisterVariables = nil;
 GetVar : TGetVar = nil;

//execute PHP script
//FileName - the name of the file with full path like c:\php\test.php
function RunPHPScript(FileName : string) : string;

function PHPLoaded : boolean;

implementation

type
TExecutePHP = procedure (FileName : Pchar; ACallBack : pointer)  stdcall;

var
 DelphiPHPLib : THandle = 0;
 ExecutePHP : TExecutePHP = nil;
 PHPResult : string;


procedure PHPCallBack(c: char); stdcall;
begin
 PHPResult := PHPResult + c;
end;

function PHPLoaded : boolean;
begin
  Result := DelphiPHPLib <> 0;
end;

procedure UnloadPHP;
begin
  if PHPLoaded then
   begin
      FreeLibrary(DelphiPHPLib);
      DelphiPHPLib := 0;
      @ExecutePHP := nil;
      @RegisterVariables := nil;
      @GetVar := nil;
   end;
end;

procedure LoadPHP;
const
  ExecutePHPName = 'ExecutePHP';
  RegisterVariablesName = 'RegisterVariables';
  GetVarName = 'GetVar';
begin
  DelphiPHPLib := LoadLibrary('php4Delphi.dll');
  if PHPLoaded then
   begin
     @ExecutePHP := GetProcAddress(DelphiPHPLib,ExecutePHPName);
     @RegisterVariables := GetProcAddress(DelphiPHPLib,RegisterVariablesName);
     @GetVar := GetProcAddress(DelphiPHPLib,GetVarName);
     if ((not Assigned(ExecutePHP)) or (not Assigned(RegisterVariables) ) or
     (not Assigned(GetVar)) ) then
       UnloadPHP;
   end;
end;


function RunPHPScript(FileName : string) : string;
begin
  PHPResult := '';
  if PHPLoaded then
    ExecutePHP(PChar(FileName),@PHPCallback);
  Result := PHPResult
end;

initialization
 LoadPHP;
finalization
 UnloadPHP;
end.