{ PCI Classes }

type pci_record =
  record
    class,
    subclass,
    progif      : byte;
    name        : string[40];
  end;

const
   pci_class_names      : array [0..$11] of string[40] = (

   'Unknown',
   'Storage',
   'Network',
   'Display',
   'Multimedia',
   'Memory',
   'Bridge',
   'Simple Communication',
   'System',
   'Input',
   'Docking',
   'Processor',
   'Serial',
   'Wireless',
   'Intelligent I/O',
   'Satellite Communication',
   'En/Decryption',
   'Data Aquisition & Signal Processing'
   );


   high_class_name	: word = $11;	{ update this to same as line above }

   high_class_array	: word = 119;	{ update this to same as line below }

   pci_class_array : array [0..119] of pci_record = (

   (class:$00;subclass:$00;progif:$00;name:'Undefined'),
   (class:$00;subclass:$01;progif:$00;name:'VGA'),

   (class:$01;subclass:$00;progif:$00;name:'SCSI'),
   (class:$01;subclass:$01;progif:$00;name:'IDE'),
   (class:$01;subclass:$02;progif:$00;name:'Floppy'),
   (class:$01;subclass:$03;progif:$00;name:'IPI'),
   (class:$01;subclass:$04;progif:$00;name:'RAID'),
   (class:$01;subclass:$80;progif:$00;name:'Other'),

   (class:$02;subclass:$00;progif:$00;name:'Ethernet'),
   (class:$02;subclass:$01;progif:$00;name:'Token Ring'),
   (class:$02;subclass:$02;progif:$00;name:'FDDI'),
   (class:$02;subclass:$03;progif:$00;name:'ATM'),
   (class:$02;subclass:$04;progif:$00;name:'ISDN'),
   (class:$02;subclass:$80;progif:$00;name:'Other'),

   (class:$03;subclass:$00;progif:$00;name:'VGA'),
   (class:$03;subclass:$00;progif:$01;name:'VGA+8514'),
   (class:$03;subclass:$01;progif:$00;name:'XGA'),
   (class:$03;subclass:$02;progif:$00;name:'3D'),
   (class:$03;subclass:$80;progif:$00;name:'Other'),

   (class:$04;subclass:$00;progif:$00;name:'Video'),
   (class:$04;subclass:$01;progif:$00;name:'Audio'),
   (class:$04;subclass:$02;progif:$00;name:'Telephony'),
   (class:$04;subclass:$80;progif:$00;name:'Other'),

   (class:$05;subclass:$00;progif:$00;name:'RAM'),
   (class:$05;subclass:$01;progif:$00;name:'Flash'),
   (class:$05;subclass:$80;progif:$00;name:'Other'),

   (class:$06;subclass:$00;progif:$00;name:'PCI to HOST'),
   (class:$06;subclass:$01;progif:$00;name:'PCI to ISA'),
   (class:$06;subclass:$02;progif:$00;name:'PCI to EISA'),
   (class:$06;subclass:$03;progif:$00;name:'PCI to MCA'),
   (class:$06;subclass:$04;progif:$00;name:'PCI to PCI'),
   (class:$06;subclass:$04;progif:$01;name:'PCI to PCI (Subtractive Decode)'),
   (class:$06;subclass:$05;progif:$00;name:'PCI to PCMCIA'),
   (class:$06;subclass:$06;progif:$00;name:'PCI to NuBUS'),
   (class:$06;subclass:$07;progif:$00;name:'PCI to Cardbus'),
   (class:$06;subclass:$08;progif:$00;name:'PCI to RACEway'),
   (class:$06;subclass:$09;progif:$00;name:'PCI to PCI'),
   (class:$06;subclass:$0A;progif:$00;name:'PCI to InfiBand'),
   (class:$06;subclass:$80;progif:$00;name:'PCI to Other'),

   (class:$07;subclass:$00;progif:$00;name:'Serial'),
   (class:$07;subclass:$00;progif:$01;name:'Serial - 16450'),
   (class:$07;subclass:$00;progif:$02;name:'Serial - 16550'),
   (class:$07;subclass:$00;progif:$03;name:'Serial - 16650'),
   (class:$07;subclass:$00;progif:$04;name:'Serial - 16750'),
   (class:$07;subclass:$00;progif:$05;name:'Serial - 16850'),
   (class:$07;subclass:$00;progif:$06;name:'Serial - 16950'),
   (class:$07;subclass:$01;progif:$00;name:'Parallel'),
   (class:$07;subclass:$01;progif:$01;name:'Parallel - BiDir'),
   (class:$07;subclass:$01;progif:$02;name:'Parallel - ECP'),
   (class:$07;subclass:$01;progif:$03;name:'Parallel - IEEE1284 Controller'),
   (class:$07;subclass:$01;progif:$FE;name:'Parallel - IEEE1284 Target'),
   (class:$07;subclass:$02;progif:$00;name:'Multiport Serial'),
   (class:$07;subclass:$03;progif:$00;name:'Hayes Compatible Modem'),
   (class:$07;subclass:$03;progif:$01;name:'Hayes Compatible Modem, 16450'),
   (class:$07;subclass:$03;progif:$02;name:'Hayes Compatible Modem, 16550'),
   (class:$07;subclass:$03;progif:$03;name:'Hayes Compatible Modem, 16650'),
   (class:$07;subclass:$03;progif:$04;name:'Hayes Compatible Modem, 16750'),
   (class:$07;subclass:$80;progif:$00;name:'Other'),

   (class:$08;subclass:$00;progif:$00;name:'PIC'),
   (class:$08;subclass:$00;progif:$01;name:'ISA PIC'),
   (class:$08;subclass:$00;progif:$02;name:'EISA PIC'),
   (class:$08;subclass:$00;progif:$10;name:'I/O APIC'),
   (class:$08;subclass:$00;progif:$20;name:'I/O(x) APIC'),
   (class:$08;subclass:$01;progif:$00;name:'DMA'),
   (class:$08;subclass:$01;progif:$01;name:'ISA DMA'),
   (class:$08;subclass:$01;progif:$02;name:'EISA DMA'),
   (class:$08;subclass:$02;progif:$00;name:'Timer'),
   (class:$08;subclass:$02;progif:$01;name:'ISA Timer'),
   (class:$08;subclass:$02;progif:$02;name:'EISA Timer'),
   (class:$08;subclass:$03;progif:$00;name:'RTC'),
   (class:$08;subclass:$03;progif:$00;name:'ISA RTC'),
   (class:$08;subclass:$03;progif:$00;name:'Hot-Plug'),
   (class:$08;subclass:$80;progif:$00;name:'Other'),

   (class:$09;subclass:$00;progif:$00;name:'Keyboard'),
   (class:$09;subclass:$01;progif:$00;name:'Pen'),
   (class:$09;subclass:$02;progif:$00;name:'Mouse'),
   (class:$09;subclass:$03;progif:$00;name:'Scanner'),
   (class:$09;subclass:$04;progif:$00;name:'Game Port'),
   (class:$09;subclass:$80;progif:$00;name:'Other'),

   (class:$0a;subclass:$00;progif:$00;name:'Generic'),
   (class:$0a;subclass:$80;progif:$00;name:'Other'),

   (class:$0b;subclass:$00;progif:$00;name:'386'),
   (class:$0b;subclass:$01;progif:$00;name:'486'),
   (class:$0b;subclass:$02;progif:$00;name:'Pentium'),
   (class:$0b;subclass:$03;progif:$00;name:'PentiumPro'),
   (class:$0b;subclass:$10;progif:$00;name:'DEC Alpha'),
   (class:$0b;subclass:$20;progif:$00;name:'PowerPC'),
   (class:$0b;subclass:$30;progif:$00;name:'MIPS'),
   (class:$0b;subclass:$40;progif:$00;name:'Coprocessor'),
   (class:$0b;subclass:$80;progif:$00;name:'Other'),

   (class:$0c;subclass:$00;progif:$00;name:'FireWire'),
   (class:$0c;subclass:$00;progif:$10;name:'OHCI FireWire'),
   (class:$0c;subclass:$01;progif:$00;name:'ACCESS.bus'),
   (class:$0c;subclass:$02;progif:$00;name:'SSA'),
   (class:$0c;subclass:$03;progif:$00;name:'USB (UHCI)'),
   (class:$0c;subclass:$03;progif:$10;name:'USB (OHCI)'),
   (class:$0c;subclass:$03;progif:$80;name:'USB'),
   (class:$0c;subclass:$03;progif:$FE;name:'USB Device'),
   (class:$0c;subclass:$04;progif:$00;name:'Fibre Channel'),
   (class:$0c;subclass:$05;progif:$00;name:'SMBus Controller'),
   (class:$0c;subclass:$06;progif:$00;name:'InfiniBand'),
   (class:$0c;subclass:$80;progif:$00;name:'Other'),

   (class:$0d;subclass:$00;progif:$00;name:'iRDA Controller'),
   (class:$0d;subclass:$01;progif:$00;name:'Consumer IR'),
   (class:$0d;subclass:$10;progif:$00;name:'RF controller'),
   (class:$0d;subclass:$80;progif:$00;name:'Other'),

   (class:$0e;subclass:$00;progif:$00;name:'I2O'),
   (class:$0e;subclass:$80;progif:$00;name:'Other'),

   (class:$0f;subclass:$01;progif:$00;name:'TV'),
   (class:$0f;subclass:$02;progif:$00;name:'Audio'),
   (class:$0f;subclass:$03;progif:$00;name:'Voice'),
   (class:$0f;subclass:$04;progif:$00;name:'Data'),
   (class:$0f;subclass:$80;progif:$00;name:'Other'),

   (class:$10;subclass:$00;progif:$00;name:'Network'),
   (class:$10;subclass:$10;progif:$00;name:'Entertainment'),
   (class:$10;subclass:$80;progif:$00;name:'Other'),

   (class:$11;subclass:$00;progif:$00;name:'DPIO Modules'),
   (class:$11;subclass:$01;progif:$00;name:'Performance Counters'),
   (class:$11;subclass:$10;progif:$00;name:'Comm Sync, Time+Frequency Measurement'),
   (class:$11;subclass:$80;progif:$00;name:'Other')

   );


