unit Principal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, Mask, ImgList, Buttons,
  Menus, CheckLst, IniFiles, Atributos, ExtDlgs;

const
  {Separadores:}
  cItemSep    = '\';
  cArqSep     = '_';
  cCuringa    = '%';
  {Extensoes:}
  cExtIni     = '.ini';
  cExtTxt     = '.rtf';
  cExtCfg     = '.cfg';
  {Salvar no *.ini:}
  cConfig     = 'Config';
  cOpcoes     = 'Opcoes';
  cStatus     = 'Status';
  cAtrib      = 'Atributos';
  cUltimoArq  = 'UltimoArq';
  cEvento     = 'Evento';
  cImagem     = 'Imagem';
  {Coordenadas:}
  cEsquerda   = 'Esquerda';
  cTopo       = 'Topo';
  cLargura    = 'Largura';
  cAltura     = 'Altura';
  cSeparacao  = 'Separacao';
  cItem       = 'Item';
  {Pos. no texto:}
  cPosTexto   = 'PosTexto';

type
  TfrmPrincipal = class(TForm)
    sepIDCont: TSplitter;
    grpPesq: TGroupBox;
    lblItem: TLabel;
    lblCont: TLabel;
    btnPesqID: TSpeedButton;
    btnNovo: TSpeedButton;
    btnDel: TSpeedButton;
    btnPesqCont: TSpeedButton;
    prg: TProgressBar;
    imgLstTree: TImageList;
    btnAlt: TSpeedButton;
    stb: TStatusBar;
    cbxResult: TComboBox;
    menu: TMainMenu;
    mnuItem: TMenuItem;
    mnuCont: TMenuItem;
    mnuItemPesq: TMenuItem;
    mnuItemNovo: TMenuItem;
    mnuItemDel: TMenuItem;
    mnuItemAlt: TMenuItem;
    mnuContPesq: TMenuItem;
    imgLstBtns: TImageList;
    chkLstOp: TCheckListBox;
    edtID: TComboBox;
    edtCont: TComboBox;
    mnuItemSep: TMenuItem;
    mnuItemAtrib: TMenuItem;
    mnuArq: TMenuItem;
    mnuArqNovo: TMenuItem;
    mnuArqAbrir: TMenuItem;
    mnuArqSalvarComo: TMenuItem;
    mnuArqSepSair: TMenuItem;
    mnuArqSair: TMenuItem;
    odNota: TOpenDialog;
    sdNota: TSaveDialog;
    popAtrib: TPopupMenu;
    mnuAtr1: TMenuItem;
    mnuAtr2: TMenuItem;
    mnuAtr3: TMenuItem;
    mnuArqSalvar: TMenuItem;
    mnuContFonte: TMenuItem;
    memCont: TRichEdit;
    fdNota: TFontDialog;
    mnuContSepFonte: TMenuItem;
    mnuContNegrito: TMenuItem;
    mnuContItalico: TMenuItem;
    mnuContSub: TMenuItem;
    popTxt: TPopupMenu;
    popTxtPesqItem: TMenuItem;
    popTxtPesqCont: TMenuItem;
    popTxtFonte: TMenuItem;
    popTxtContPesq: TMenuItem;
    mnuArqSepImp: TMenuItem;
    mnuArqImp: TMenuItem;
    popTxtSubst: TMenuItem;
    mnuAjuda: TMenuItem;
    mnuAjudaAbre: TMenuItem;
    rtfAux: TRichEdit;
    pnlTree: TPanel;
    treeID: TTreeView;
    pnlDataItem: TPanel;
    dtpDataItem: TDateTimePicker;
    btnDataItem: TSpeedButton;
    mnuItemEvento: TMenuItem;
    btnImagens: TSpeedButton;
    odImagem: TOpenPictureDialog;
    mnuArqRecente: TMenuItem;
    procedure edtIDKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnPesqIDClick(Sender: TObject);
    procedure edtContKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnPesqContClick(Sender: TObject);
    procedure btnAltClick(Sender: TObject);
    procedure treeIDChange(Sender: TObject; Node: TTreeNode);
    procedure btnNovoClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure memContExit(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cbxResultClick(Sender: TObject);
    procedure chkLstOpExit(Sender: TObject);
    procedure cbxResultKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure mnuArqSairClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mnuArqNovoClick(Sender: TObject);
    procedure mnuArqAbrirClick(Sender: TObject);
    procedure mnuArqSalvarComoClick(Sender: TObject);
    procedure mnuAtr3Click(Sender: TObject);
    procedure mnuArqSalvarClick(Sender: TObject);
    procedure chkLstOpClick(Sender: TObject);
    procedure mnuContFonteClick(Sender: TObject);
    procedure mnuContNegritoClick(Sender: TObject);
    procedure mnuContItalicoClick(Sender: TObject);
    procedure mnuContSubClick(Sender: TObject);
    procedure popTxtPesqItemClick(Sender: TObject);
    procedure popTxtPesqContClick(Sender: TObject);
    procedure popTxtContPesqClick(Sender: TObject);
    procedure mnuItemAtribClick(Sender: TObject);
    procedure mnuArqImpClick(Sender: TObject);
    procedure popTxtSubstClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cbxResultExit(Sender: TObject);
    procedure cbxResultEnter(Sender: TObject);
    procedure memContChange(Sender: TObject);
    procedure mnuAjudaAbreClick(Sender: TObject);
    procedure treeIDDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure treeIDDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure dtpDataItemChange(Sender: TObject);
    procedure btnDataItemClick(Sender: TObject);
    procedure treeIDClick(Sender: TObject);
    procedure mnuItemEventoClick(Sender: TObject);
    procedure btnImagensClick(Sender: TObject);
    procedure memContKeyPress(Sender: TObject; var Key: Char);
    procedure mnuArqRecenteClick(Sender: TObject);
  private
    DirAtual,
    ArqAtual, ArqTxt: string;
    ini: TIniFile;
    f_Alterado: boolean;
    NomeAtrib: array[1..cNumAtribs] of string;
    FiltraAtrib: array[1..cNumAtribs] of boolean;
    aMenu: array[1..cNumAtribs] of TMenuItem;
    AtzPosTexto,
    pesq_exata: boolean;
    NTransf,NAtual: TTreeNode;
    procedure Separa(s: string; var s1: string; var s2: string);
    function StrToItem(s: string): TTreeNode;
    procedure Reposiciona(p: integer);
    procedure SalvaCoords;
    procedure CarregaCoords;
    function PodeMudarArq: boolean;
    procedure AbreArquivos;
    procedure SalvaArquivos;
    procedure MudaTitulo;
    function SalvarComo: boolean;
    procedure SalvaOps;
    procedure SalvaPosItem;
    procedure CarregaStatus;
    procedure SalvaStatus;
    procedure SetAlterado(Value: boolean);
    function OpcoesPesquisa: TSearchTypes;
    procedure FiltraTree;
    procedure FiltraEventos;
    procedure AtualizaFiltroTree;
    procedure Importa;
    procedure CarregaAtribs;
    procedure SetProximoArquivo(Value: string);
    function LocalizaSubstitui(Troca: string): boolean;
    function PalavraAtual: string;
    procedure AtualizaLista(cbx: TComboBox; const s: string);
    procedure VerificaOrdenacao;
    procedure AjustaCategorias;
    {}
    function PesqConteudo(s: string): boolean;
    function PesquisaID(s: string): boolean; overload;
    function PesquisaID(s: string; var p: integer): boolean; overload;
    function NovaCatego(nome: string): TTreeNode;
    function NovoItem(N: TTreeNode; nome: string): TTreeNode;
    function Diretorio(s: string): string;
    function NomeArqPrin(ext: string): string;
    function NomeArqItem(N: TTreeNode): string;
    procedure SalvaTxt;
    function RenArqTree(N: TTreeNode; novoNome: string): boolean;
    procedure DelArqTree(N: TTreeNode);
    function LocalizaTextoRtf(s: string; rtf: TRichEdit): integer;
    procedure CarregaTxt(s: string);
    procedure CarregaPosMemo(s: string);
    function ArquivoPrincipal: string;
    function Coincide(s1,s2: string): boolean;
    function LimpaTexto(const s: string): string;
    procedure ConfiguraNode(N: TTreeNode);
    function NovaCfg(const arq: string): TIniFile;
    procedure FechaImagens;
    procedure CarregaImagens;
    procedure MarcaItemAtual;
    {}
    property Alterado: boolean read f_Alterado write SetAlterado;
    property ProximoArquivo: string write SetProximoArquivo;
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses Imprimir, Substituir, Imagem;

{$R *.DFM}

procedure TfrmPrincipal.edtIDKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = vk_Return then
    btnPesqID.Click;
end;

procedure TfrmPrincipal.btnPesqIDClick(Sender: TObject);
var
  s: string;
begin
  s := edtID.Text;
  if (ActiveControl <> edtID)
  and not InputQuery('Pesquisa','Tpico:',s) then
    Exit;
  {}
  if PesquisaID(s) then begin
    stb.SimpleText := '';
    AtualizaLista(edtID,s);
    treeId.SetFocus;
  end
  else
    stb.SimpleText := 'Tpico NO encontrado.'
end;

procedure TfrmPrincipal.edtContKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = vk_Return then
    btnPesqContClick(Sender);
end;

procedure TfrmPrincipal.btnPesqContClick(Sender: TObject);
var
  s: string;
begin
  s := edtCont.Text;
  if ActiveControl <> edtCont then begin
    if not InputQuery('Pesquisa','Contedo:',s) then
      Exit;
    edtCont.Text := s;
  end;
  if PesqConteudo(s) then begin
    cbxResult.SetFocus;
    AtualizaLista(edtCont,s);
    stb.SimpleText := '';
  end
  else
    stb.SimpleText := 'Contedo NO encontrado.';
end;

function TfrmPrincipal.PesqConteudo(s: string): boolean;
{#}
  procedure VerificaTextoArqItem(N: TTreeNode);
  var
    id: string;
  begin
    id := NomeArqItem(N);
    if not FileExists(id) then
      Exit;
    {}
    rtfAux.Lines.LoadFromFile(id);
    if LocalizaTextoRtf(s,rtfAux) = -1 then
      Exit;
    {}
    id := N.Parent.Text+cItemSep+N.Text;
    with cbxResult.Items do
      if IndexOf(id) = -1 then Add(id);
  end;
{#}
var
  i: integer;
begin
  Result := False;
  if s = '' then Exit;
  {}
  with cbxResult do begin
    Items.Clear;
    Visible := False;
  end;  // with
  prg.Max := treeID.Items.Count;
  prg.Position := 0;
  s := Trim(s);
  for i := 0 to treeID.Items.Count-1 do begin
    if treeID.Items[i].Level = 1 then
      VerificaTextoArqItem(treeID.Items[i]);
    prg.Position := prg.Position + 1;
  end;  // for
  prg.Position := 0;
  with cbxResult do begin
    Result := (Items.Count > 0);
    ShowHint := Result;
    if Result then begin
      Hint := Items[0];
      ItemIndex := 0;
      Reposiciona(0);
    end;
    Visible := True;
  end;  // with
end;

procedure TfrmPrincipal.btnAltClick(Sender: TObject);
var
  s,s2: string;
  N: TTreeNode;
  p: integer;
begin
  N := treeID.Selected;
  if N = nil then Exit;
  {}
  s := LimpaTexto(edtID.Text);
  if ActiveControl <> edtID then begin
    if not InputQuery('Alterao','Tpico:',s) then
      Exit;
  end;
  if LimpaTexto(s) = '' then Exit;
  {}
  if N.Level = 1 then
    s2 := N.Parent.Text+cItemSep+s
  else
    s2 := s;
  pesq_exata := True;
  if PesquisaID(s2,p) then begin
    MessageDlg('O Tpico j existe.',mtWarning,[mbOk],0);
    Exit;
  end;
  RenArqTree(N,s);
  N.Text   := s;
  Alterado := True;
  VerificaOrdenacao;
end;

function TfrmPrincipal.NomeArqPrin(ext: string): string;
begin
  Result := DirAtual+ArqAtual+ext;
end;

function TfrmPrincipal.Diretorio(s: string): string;
const
  cSepDir = '\';  // NO confundir c/ cItemSep !
begin
  Result := '';
  if s = '' then
    s := ExtractFilePath( Application.ExeName )
  else
    s := ExtractFilePath(s);
  {}
  if s = '' then Exit;
  {}
  if s[ Length(s) ] <> cSepDir then
    s := s + cSepDir;
  Result := s;
end;

procedure TfrmPrincipal.treeIDChange(Sender: TObject; Node: TTreeNode);
begin
  ConfiguraNode(Node);
end;

procedure TfrmPrincipal.btnNovoClick(Sender: TObject);
var
  N: TTreeNode;
  s: string;
begin
  s := LimpaTexto(edtID.Text);
  if ActiveControl <> edtID then begin
    if not InputQuery('Novo','Tpico:',s) then
      Exit;
  end;
  if LimpaTexto(s) = '' then Exit;
  {}
  N := StrToItem(s);
  if N = nil then begin
    MessageDlg('O Tpico j existe',mtInformation,[mbOk],0);
    Exit;
  end;
  Alterado   := True;
  N.Selected := True;
  if N.Level = 0 then Exit;
  {}
  ArqTxt := NomeArqItem(N);
  SalvaTxt;
  VerificaOrdenacao;
end;

function TfrmPrincipal.NovaCatego(nome: string): TTreeNode;
begin
  Result := treeID.Items.Add(nil,nome);
  with Result do begin
    ImageIndex    := 0;
    StateIndex    := -1;
    SelectedIndex := 0;
  end; // with
  treeID.Refresh;
end;

procedure TfrmPrincipal.btnDelClick(Sender: TObject);
var
  N: TTreeNode;
  s: string;
begin
  N := treeId.Selected;
  if N = nil then Exit;
  {}
  s := 'Tem certeza que quer deletar ';
  if N.Level = 0 then
    s := s + 'a Categoria "'+N.Text+'" ?'
  else
    s := s + 'o Tpico "'+N.Text+'" ?';
  if MessageDlg(s,mtConfirmation
  ,[mbOk,mbCancel],0) = mrCancel then
    Exit;
  DelArqTree(N);
  if N = NAtual then
    NAtual := nil;
  treeId.Items.Delete(N);
  Alterado := True;
end;

function TfrmPrincipal.NovoItem(N: TTreeNode; nome: string): TTreeNode;
begin
  Result := treeId.Items.AddChild(N,nome);
  with Result do begin
    ImageIndex    := 1;
    StateIndex    := -1;
    SelectedIndex := 1;
  end; // with
  treeID.Refresh;
end;

function TfrmPrincipal.NomeArqItem(N: TTreeNode): string;
begin
  Result := DirAtual+N.Parent.Text+cArqSep+N.Text+cExtTxt;
end;

procedure TfrmPrincipal.memContExit(Sender: TObject);
begin
  SalvaTxt;
end;

procedure TfrmPrincipal.SalvaTxt;
begin
  if ArqTxt <> '' then begin
    if AtzPosTexto then
      with NovaCfg(ArqTxt) do begin
        WriteInteger(cConfig,cPosTexto,memCont.SelStart);
        Free;
      end;  // with
    memCont.Lines.SaveToFile(ArqTxt);
  end;
  ArqTxt   := '';
end;

procedure TfrmPrincipal.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if not PodeMudarArq then begin
    Action := caNone;
    Exit;
  end;
  FechaImagens;
end;

procedure TfrmPrincipal.Separa(s: string; var s1: string; var s2: string);
var
  p: integer;
begin
  {* Sintaxe: <Categoria>\<Tpico> }
  p := Pos(cItemSep,s);
  if p = 0 then begin
    s1 := s;
    s2 := '';
  end
  else begin
    s1 := Trim( Copy(s,1,p-1) );
    Delete(s,1,p);
    s2 := Trim(s);
  end;  // else
end;

procedure TfrmPrincipal.cbxResultClick(Sender: TObject);
var
  p: integer;
begin
  p := cbxResult.ItemIndex;
  if p = -1 then Exit;
  {}
  with cbxResult do
    Hint := Items[ItemIndex];
  Reposiciona(p);
end;

function TfrmPrincipal.PesquisaID(s: string; var p: integer): boolean;
type
  TModoPesqCat = (mpcTodas,mpcIgnora,mpcFim);
var
  i: integer;
  s1,s2: string;
  mpc: TModoPesqCat;
begin
  Result := False;
  p := -1;
  if s = '' then Exit;
  {}
  Separa(s,s1,s2);
  if (s1 = '') and (s2 <> '') then begin
    mpc := mpcIgnora;
    s1  := s2;
    s2  := '';
  end
  else
    mpc := mpcTodas;
  for i := 0 to treeID.Items.Count-1 do
  with treeID.Items[i] do
    if (mpc <> mpcTodas) and (Level = 0) then begin
      case mpc of
        mpcIgnora: Continue;
        mpcFim: Break;
      end;  // case
    end
    else if Coincide(s1,Text) then begin
      if s2 = '' then begin
        Result := True;
        Selected := True;
        Exit;
      end
      else if Level = 1 then
        Continue;
      p := i;
      mpc := mpcFim;
      s1 := s2;
      s2 := '';
    end;  //  for/with/if
end;

function TfrmPrincipal.PesquisaID(s: string): boolean;
var
  p: integer;
begin
  Result := PesquisaID(s,p);
end;

function TfrmPrincipal.RenArqTree(N: TTreeNode; novoNome: string): boolean;
var
  s,s2: string;
  h,p: integer;
  sr: TSearchRec;
begin
  Result := False;
  if N.Level = 1 then
    s := DirAtual+N.Parent.Text+cArqSep+N.Text
  else
    s := DirAtual+N.Text+'*';
  s := s + '.*';
  h := FindFirst(s,faArchive,sr);
  while h = 0 do begin
    s  := sr.Name;
    s2 := s;
    p := Pos('.',s2);
    Delete(s2,1,p-1);
    if N = NTransf then
      s2 := novoNome+s2
    else if N.Level = 0 then begin
      p := Pos(cArqSep,s);
      s2 := novoNome
      +Copy(s,p,Length(s)-p+1);
    end
    else
      s2 := N.Parent.Text+cArqSep
      +novoNome+s2;
    {}
    Result := RenameFile(DirAtual+s,DirAtual+s2);
    if not Result then
      MessageDlg('O arquivo "'+s
      +'" NO pode ser renomeado para "'
      +s2+'"',mtError,[mbOk],0);
    h := FindNext(sr);
  end;  // while
  FindClose(sr);
end;

procedure TfrmPrincipal.DelArqTree(N: TTreeNode);
var
  s: string;
  h: integer;
  sr: TSearchRec;
begin
  if N.Level = 1 then
    s := DirAtual+N.Parent.Text+cArqSep+N.Text
  else
    s := DirAtual+N.Text;
  s := s + '.*';
  h := FindFirst(s,faArchive,sr);
  while h = 0 do begin
    if not DeleteFile(DirAtual+sr.Name) then
      MessageDlg('O arquivo "'+s
      +'" NO pode ser deletado'
      ,mtError,[mbOk],0);
    h := FindNext(sr);
  end;  // while
  FindClose(sr);
end;

procedure TfrmPrincipal.chkLstOpExit(Sender: TObject);
begin
  chkLstOp.ItemIndex := -1;
end;

function TfrmPrincipal.StrToItem(s: string): TTreeNode;
var
  N: TTreeNode;
  s1,s2: string;
  p: integer;
  criaCat,criaItem: boolean;
begin
  Result := nil;
  N := treeID.Selected;
  Separa(s,s1,s2);
  if s2 = '' then begin
    if N = nil then
      s := ''
    else if N.Level = 1 then
      s := N.Parent.Text+cItemSep+s1;
  end;
  pesq_exata := True;
  if PesquisaID(s,p) then
    Exit;
  {* Monta as partes:}
  if s2 = '' then begin
    {+}
    if N = nil then begin
      criaCat  := True;
      criaItem := False;
    end
    else begin
      criaItem := (N.Level = 1);
      if criaItem then begin
        N  := N.Parent;
        s2 := s1;
      end;
      criaCat  := not criaItem;
    end;
    {+}
  end
  else if p = -1 then begin
    criaCat  := True;
    criaItem := True;
  end
  else begin   // sempre Level = 0
    N := treeID.Items[p];
    criaCat  := False;
    criaItem := True;
  end;
  if criaCat then
    N := NovaCatego(s1);
  if criaItem then
    N := NovoItem(N,s2);
  {*}
  Result := N;
end;

procedure TfrmPrincipal.Reposiciona(p: integer);
begin
  PesquisaID(cbxResult.Items[p]);
  p := LocalizaTextoRtf(edtCont.Text,memCont);
  if p = -1 then Exit;
  {}
  memCont.SelStart  := p;
  memCont.SelLength := Length(edtCont.Text);
end;

procedure TfrmPrincipal.cbxResultKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = vk_Return then
    cbxResultClick(Sender);
end;

procedure TfrmPrincipal.FormCreate(Sender: TObject);
begin
  aMenu[1] := mnuAtr1;
  aMenu[2] := mnuAtr2;
  aMenu[3] := mnuAtr3;
  DirAtual := '';
  ini := TIniFile.Create(ArquivoPrincipal);
  AtzPosTexto := True;
  ProximoArquivo := ini.ReadString(cConfig,cUltimoArq,'');
end;

procedure TfrmPrincipal.mnuArqSairClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPrincipal.FormDestroy(Sender: TObject);
begin
  ini.Free;
end;

procedure TfrmPrincipal.SalvaCoords;
begin
  ini.WriteInteger(cConfig,cEsquerda,Left);
  ini.WriteInteger(cConfig,cTopo,Top);
  ini.WriteInteger(cConfig,cLargura,Width);
  ini.WriteInteger(cConfig,cAltura,Height);
  ini.WriteInteger(cConfig,cSeparacao,pnlTree.Width);
end;

procedure TfrmPrincipal.CarregaCoords;
begin
  Left   := ini.ReadInteger(cConfig,cEsquerda,Left);
  Top    := ini.ReadInteger(cConfig,cTopo,Top);
  Width  := ini.ReadInteger(cConfig,cLargura,Width);
  Height := ini.ReadInteger(cConfig,cAltura,Height);
  pnlTree.Width := ini.ReadInteger(cConfig,cSeparacao,treeID.Width);
end;

procedure TfrmPrincipal.mnuArqNovoClick(Sender: TObject);
begin
  if not SalvarComo then Exit;
  {}
  memCont.Clear;
  treeID.Items.Clear;
  ini.Free;
  ini := TIniFile.Create( NomeArqPrin(cExtIni) );
  SalvaArquivos;
  Importa;
end;

function TfrmPrincipal.PodeMudarArq: boolean;
begin
  Result := True;
  if not Alterado then Exit;
  {}
  case MessageDlg('Salvar Alteraes?'
  ,mtConfirmation,[mbYes,mbNo,mbCancel],0) of
    mrYes: SalvaArquivos;
    mrNo: ;
    mrCancel: Result := False;
  end;
end;

procedure TfrmPrincipal.mnuArqAbrirClick(Sender: TObject);
var
  iniDef: TIniFile;
begin
  odNota.InitialDir := DirAtual;
  if not odNota.Execute then Exit;
  {}
  ProximoArquivo := odNota.FileName;
  iniDef := TIniFile.Create(ArquivoPrincipal);
  iniDef.WriteString(cConfig,cUltimoArq,NomeArqPrin(cExtIni));
  iniDef.Free;
end;

procedure TfrmPrincipal.mnuArqSalvarComoClick(Sender: TObject);
begin
  if SalvarComo then
    SalvaArquivos;
end;

procedure TfrmPrincipal.AbreArquivos;
var
  s: string;
  i: integer;
begin
  Importa;
  ini.Free;
  ini := TIniFile.Create( NomeArqPrin(cExtIni) );
  with chkLstOp do
    for i := 0 to Items.Count-1 do
      Checked[i] := ini.ReadBool(cOpcoes,Items[i],False);
  CarregaCoords;
  MudaTitulo;
  s := ini.ReadString(cConfig,cItem,'');
  if s <> '' then PesquisaID(s);
  {}
  CarregaStatus;
  CarregaAtribs;
  FiltraTree;
  Alterado := False;
end;

procedure TfrmPrincipal.SalvaArquivos;
begin
  SalvaTxt;
  SalvaCoords;
  SalvaOps;
  SalvaPosItem;
  SalvaStatus;
  Alterado := False;
end;

procedure TfrmPrincipal.MudaTitulo;
const
  cTitulo = 'Anotaes';
var
  s: string;
begin
  s := ArqAtual;
  if s <> '' then s := s + ' - ';
  s := s + cTitulo;
  {}
  Application.Title := s;
  Caption := s;
end;

function TfrmPrincipal.SalvarComo: boolean;
begin
  sdNota.InitialDir := DirAtual;
  Result := sdNota.Execute;
  if not Result then Exit;
  {}
  ProximoArquivo := sdNota.FileName;
  MudaTitulo;
end;

procedure TfrmPrincipal.SalvaOps;
var
  i: integer;
begin
  with chkLstOp do begin
    for i := 0 to Items.Count-1 do
      ini.WriteBool(cOpcoes,Items[i],Checked[i]);
  end;  // with    
end;

procedure TfrmPrincipal.SalvaPosItem;
var
  s: string;
  N: TTreeNode;
begin
  s := '';
  N := treeID.Selected;
  if N = nil then Exit;
  {}
  if N.Level = 1 then
    s := N.Parent.Text+cItemSep;
  s := s + N.Text;
  ini.WriteString(cConfig,cItem,s);
end;

procedure TfrmPrincipal.mnuAtr3Click(Sender: TObject);
var
  N: TTreeNode;
  x: integer;
begin
  N := treeID.Selected;
  if (N = nil) or (N.Level = 0) then Exit;
  {}
  x := TMenuItem(Sender).ImageIndex;
  N.ImageIndex    := x;
  N.StateIndex    := -1;
  N.SelectedIndex := x;
  treeID.Refresh;
  Alterado   := True;
end;

procedure TfrmPrincipal.CarregaStatus;
var
  i,x: integer;
  N: TTreeNode;
begin
  for i := 0 to treeID.Items.Count-1 do begin
    N := treeID.Items[i];
    if N.Level = 0 then
      Continue;
    with NovaCfg( NomeArqItem(N) ) do begin
      x := ReadInteger(cConfig,cStatus,1);
      Free;
    end;  // with
    N.ImageIndex    := x;
    N.StateIndex    := -1;
    N.SelectedIndex := x;
  end;  // for
end;

procedure TfrmPrincipal.SalvaStatus;
var
  i: integer;
  N: TTreeNode;
  s: string;
begin
  for i := 0 to treeID.Items.Count-1 do begin
    N := treeID.Items[i];
    if (N.Level = 1)
    and (N.ImageIndex > 1) then
      with NovaCfg( NomeArqItem(N) ) do begin
        WriteInteger(cConfig,cStatus,N.ImageIndex);
        Free;
      end;  // with
  end;
  {Salva Nomes e status dos Atributos:}
  for i := 1 to cNumAtribs do begin
    s := IntToStr(i);
    ini.WriteBool(cAtrib,cFiltro+s,FiltraAtrib[i]);
    ini.WriteString(cAtrib,cNomAtrib+s,NomeAtrib[i]);
  end;  // for
end;

procedure TfrmPrincipal.mnuArqSalvarClick(Sender: TObject);
begin
  SalvaArquivos;
end;

procedure TfrmPrincipal.chkLstOpClick(Sender: TObject);
begin
  Alterado := True;
end;

procedure TfrmPrincipal.SetAlterado(Value: boolean);
begin
  if f_Alterado = Value then Exit;
  {}
  f_Alterado := Value;
  mnuArqSalvar.Enabled := Value;
end;

procedure TfrmPrincipal.mnuContFonteClick(Sender: TObject);
begin
  fdNota.Font.Assign(memCont.SelAttributes);
  if not fdNota.Execute then
    Exit;
  {}
  memCont.SelAttributes.Assign(fdNota.Font);
end;

procedure TfrmPrincipal.mnuContNegritoClick(Sender: TObject);
begin
  with memCont do begin
    if fsBold in SelAttributes.Style then
      SelAttributes.Style := SelAttributes.Style - [fsBold]
    else
      SelAttributes.Style := SelAttributes.Style + [fsBold];
  end;  // with
end;

procedure TfrmPrincipal.mnuContItalicoClick(Sender: TObject);
begin
  with memCont do begin
    if fsItalic in SelAttributes.Style then
      SelAttributes.Style := SelAttributes.Style - [fsItalic]
    else
      SelAttributes.Style := SelAttributes.Style + [fsItalic];
  end;  // with
end;

procedure TfrmPrincipal.mnuContSubClick(Sender: TObject);
begin
  with memCont do begin
    if fsUnderline in SelAttributes.Style then
      SelAttributes.Style := SelAttributes.Style - [fsUnderline]
    else
      SelAttributes.Style := SelAttributes.Style + [fsUnderline];
  end;  // with
end;

procedure TfrmPrincipal.popTxtPesqItemClick(Sender: TObject);
begin
  MarcaItemAtual;
  edtID.Text := PalavraAtual;
  edtID.SetFocus;
  btnPesqID.Click;
end;

procedure TfrmPrincipal.popTxtPesqContClick(Sender: TObject);
begin
  MarcaItemAtual;
  edtCont.Text := PalavraAtual;
  edtCont.SetFocus;
  btnPesqContClick(Sender);
end;

function TfrmPrincipal.LocalizaTextoRtf(s: string; rtf: TRichEdit): integer;
var
  op: TSearchTypes;
begin
  op := OpcoesPesquisa;
  Result := rtf.FindText(s,0,Length(rtf.Text),op);
end;

function TfrmPrincipal.OpcoesPesquisa: TSearchTypes;
begin
  Result := [];
  if chkLstOp.Checked[0] then
    Result := Result + [stWholeWord];
  if chkLstOp.Checked[1] then
    Result := Result + [stMatchCase];
end;

procedure TfrmPrincipal.popTxtContPesqClick(Sender: TObject);
begin
  LocalizaSubstitui('');
end;

procedure TfrmPrincipal.mnuItemAtribClick(Sender: TObject);
var
  i : integer;
begin
  frmAtrib := TfrmAtrib.Create(self);
  with frmAtrib do begin
    for i := 1 to cNumAtribs do begin
      aBtn[i].Down := FiltraAtrib[i];
      aEdt[i].Text := NomeAtrib[i];
    end;
    if ShowModal = mrOk then begin
      for i := 1 to cNumAtribs do begin
        FiltraAtrib[i]   := aBtn[i].Down;
        NomeAtrib[i]     := aEdt[i].Text;
        aMenu[i].Caption := aEdt[i].Text;
      end;  // for
      AtualizaFiltroTree;
      Alterado := True;
    end;
  end;  // with
  frmAtrib.Free;
  mnuItemAtrib.Checked := (mnuItemEvento.Visible);
end;

procedure TfrmPrincipal.FiltraTree;
var
  i,x, NEventos: integer;
  N: TTreeNode;
  s: string;
begin
  treeID.OnChange := nil;
  treeID.OnClick  := nil;
  treeID.Items.BeginUpdate;
  i := 0;  NEventos := 0;
  while i < treeID.Items.Count do begin
    N := treeID.Items[i];
    x := N.ImageIndex;
    if (x = 0) or FiltraAtrib[x] then
      Inc(i)
    else begin
      N.Delete;
      Continue;
    end;
    if N.Level = 0 then Continue;
    {}
    with NovaCfg( NomeArqItem(N) ) do begin
      s := ReadString(cConfig,cEvento,'');
      Free;
    end;  // with
    if s <> '' then
      try
        if (StrToDate(s) = Date) then begin
          N.StateIndex := 4;
          Inc(NEventos);
        end;
      except
      end;
  end;  // while
  if NEventos > 0 then begin
    stb.SimpleText := '** Existe(m) '+IntToStr(NEventos)
    +' evento(s) marcado(s) para hoje!';
    mnuItemEvento.Visible := True;
  end
  else begin
    stb.SimpleText := '';
    mnuItemEvento.Visible := False;
  end;
  NAtual := nil;
  treeID.Items.EndUpdate;
  treeID.OnChange := treeIDChange;
  treeID.OnClick  := treeIDClick;
  ConfiguraNode(treeID.Selected);
end;

procedure TfrmPrincipal.AtualizaFiltroTree;
begin
  Importa;
  FiltraTree;
  PesquisaID(edtID.Text);
  VerificaOrdenacao;
  AjustaCategorias;
end;

procedure TfrmPrincipal.Importa;
var
  h,p: integer;
  sr: TSearchRec;
  s: string;
begin
  {Monta a rvore de acordo com os arquivos relacionados:}
  treeID.Items.Clear;
  h := FindFirst(DirAtual+'*'+cExtTxt,faArchive,sr);
  while h = 0 do begin
    s := ChangeFileExt(sr.Name,'');
    p := Pos(cArqSep,s);
    if p > 0 then begin
      s[p] := cItemSep;
      StrToItem(s);
    end;
    h := FindNext(sr);
  end;  // while
  FindClose(sr);
  CarregaStatus;
  treeID.Refresh;
end;

procedure TfrmPrincipal.CarregaAtribs;
var
  i: integer;
  s: string;
begin
  for i := 1 to cNumAtribs do begin
    s := IntToStr(i);
    FiltraAtrib[i] := ini.ReadBool(cAtrib,cFiltro+s,True);
    NomeAtrib[i]   := ini.ReadString(cAtrib,cNomAtrib+s,s);
    aMenu[i].Caption := NomeAtrib[i];
  end;
  treeID.Refresh;
end;

procedure TfrmPrincipal.SetProximoArquivo(Value: string);
begin
  if ((ArqAtual <> '') and not PodeMudarArq)
  or (Value = '') then
    Exit;
  {}
  if ArqAtual <> '' then begin
    mnuArqRecente.Caption := NomeArqPrin(cExtIni);
    mnuArqRecente.Visible := True;
  end;  
  ArqAtual := ChangeFileExt( ExtractFileName(Value),'' );
  DirAtual := Diretorio(Value);
  NAtual := nil;
  AbreArquivos;
  VerificaOrdenacao;
  AjustaCategorias;
  odImagem.InitialDir := DirAtual;
end;

procedure TfrmPrincipal.mnuArqImpClick(Sender: TObject);
var
  i,p: integer;
  s: string;
begin
  frmImprimir := TfrmImprimir.Create(self);
  p := 0;
  with frmImprimir do begin
    for i := 0 to treeID.Items.Count-1 do
      if treeID.Items[i].Level = 1 then begin
        s := NomeArqItem(treeID.Items[i]);
        if not FileExists(s) then
          Continue;
        s := ExtractFileName(s);
        if treeID.Selected = treeID.Items[i] then
          p := chklItens.Items.Count;
        chklItens.Items.Add(s);
      end;  // if .. Level = 1 ..  
    chklItens.Checked[p] := True;
    if ShowModal = mrOk then
      for i := 0 to chklItens.Items.Count-1 do begin
        s := chklItens.Items[i];
        if not chklItens.Checked[i] then
          Continue;
        stb.SimpleText := 'Imprimindo '+s+'...';
        rtfAux.Lines.LoadFromFile(DirAtual+s);
        rtfAux.Print(s);
      end;  // for
    stb.SimpleText := '';  
  end;  // with
  frmImprimir.Free;
end;

function TfrmPrincipal.LocalizaSubstitui(Troca: string): boolean;
var
  op: TSearchTypes;
  tam, p: integer;
begin
  Result := False;
  op := OpcoesPesquisa;
  tam := Length(memCont.Text);
  p := memCont.SelStart+1;
  p := memCont.FindText(edtCont.Text,p,tam,op);
  if p = -1 then Exit;
  memCont.SelStart := p;
  memCont.SelLength := Length(edtCont.Text);
  if Troca <> '' then
    memCont.SelText := Troca;
  Result := True;
end;

procedure TfrmPrincipal.popTxtSubstClick(Sender: TObject);
var
  ok, todos: boolean;
  s: string;
begin
  frmSubstituir := TfrmSubstituir.Create(self);
  with frmSubstituir do begin
    edtSubst.Text := edtCont.Text;
    Caption := 'Substituir '+edtCont.Text+' por...';
    ok := (ShowModal = mrOk);
    todos := radTodos.Checked;
    s := edtSubst.Text;
  end;  // with
  frmSubstituir.Free;
  while ok do begin
    ok := LocalizaSubstitui(s);
    if not todos then Break; 
  end;  // while
end;

procedure TfrmPrincipal.CarregaTxt(s: string);
begin
  memCont.OnChange := nil;
  memCont.Lines.LoadFromFile(s);
  memCont.OnChange := memContChange;
end;

procedure TfrmPrincipal.FormShow(Sender: TObject);
begin
  treeID.SetFocus;
end;

procedure TfrmPrincipal.CarregaPosMemo(s: string);
var
  p: integer;
begin
  with NovaCfg(s) do begin
    p := ReadInteger(cConfig,cPosTexto,0);
    Free;
  end;  // with
  if p <> 0 then memCont.SelStart := p;
end;

function TfrmPrincipal.PalavraAtual: string;
{#}
  function Separador(c: char): boolean;
  begin
    Result := (c in [' ',#9,',','.']);
  end;
{#}
var
  i, p1,p2: integer;
begin
  if memCont.SelText <> '' then begin
    Result := memCont.SelText;
    Exit;
  end;
  p1 := 0;  p2 := 0;
  with memCont do begin
    for i := SelStart downto 1 do
      if Separador(Text[i]) then begin
        p1 := i;
        Break;
      end;
    for i := SelStart to Length(Text) do
      if Separador(Text[i]) then begin
        p2 := i;
        Break;
      end;
    if p2 = 0 then
      p2 := Length(Text) + 1;
    {}
    Result := Trim( Copy(Text,p1,p2-p1) );
  end;  // with
end;

procedure TfrmPrincipal.cbxResultExit(Sender: TObject);
begin
  AtzPosTexto := True;
end;

procedure TfrmPrincipal.cbxResultEnter(Sender: TObject);
begin
  AtzPosTexto := False;
end;

procedure TfrmPrincipal.AtualizaLista(cbx: TComboBox; const s: string);
begin
  if cbx.Items.IndexOf(s) <> -1 then
    Exit;
  if cbx.Items.Count > 14 then
    cbx.Items.Delete(14);  // deleta o ltimo
  cbx.Items.Insert(0,s);
end;

procedure TfrmPrincipal.memContChange(Sender: TObject);
var
  N: TTreeNode;
begin
  N := treeID.Selected;
  if (ActiveControl = memCont)
  and (N <> nil) then
    ArqTxt := NomeArqItem(N);
end;

procedure TfrmPrincipal.mnuAjudaAbreClick(Sender: TObject);
var
  ArqAjuda: string;
begin
  ArqAjuda := ArquivoPrincipal;
  if FileExists(ArqAjuda) then
    ProximoArquivo := ArqAjuda
  else
    MessageDlg('Arquivo de ajuda NO encontrado.',mtWarning,[mbOK],0);
end;

procedure TfrmPrincipal.VerificaOrdenacao;
begin
  if chkLstOp.Checked[3] then
    treeID.AlphaSort;
end;

function TfrmPrincipal.ArquivoPrincipal: string;
begin
  Result := ChangeFileExt( Application.ExeName,'.ini' );
end;

function TfrmPrincipal.Coincide(s1, s2: string): boolean;
var
  p, pCur, NumCuringas: integer;
begin
  {Compara as strings e diz se h coincidncia...}
  s1 := UpperCase( Trim(s1) );
  s2 := UpperCase( Trim(s2) );
  if pesq_exata then begin  // Exatamente iguais ('casaco','casaco')
    Result := (s1 = s2);
    pesq_exata := False;
    Exit;
  end;
  NumCuringas := 0;   pCur := 0;
  repeat
    p := Pos(cCuringa,s1);
    if p = 0 then Break;
    pCur := p;
    Delete(s1,p,1);
    Inc(NumCuringas);
  until NumCuringas = 2;  // 2 curingas so suficientes
  p := Pos(s1,s2);
  {...No meio da string  ('%sac%','casaco') :}
  if NumCuringas > 1 then begin
    Result := (p > 0);
    Exit;
  end;
  {...No final da string ('%saco','casaco') :}
  if pCur = 1 then begin
    Result := ( p = (Length(s2)-Length(s1)+1) );
    Exit;
  end;
  {...No comeo da string ('casa%','casaco') :}
  Result := (p = 1);
end;

procedure TfrmPrincipal.treeIDDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
  N: TTreeNode;
begin
  N := treeID.Selected;
  if N = nil then Exit;
  {}
  Accept := (N.Level = 1);
  if not Accept then Exit;
  {}
  NTransf := N;
end;

procedure TfrmPrincipal.treeIDDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  N, NCatego: TTreeNode;
  s: string;
  mr: TModalResult;
begin
  if NTransf = nil then Exit;
  {}
  N := treeID.DropTarget;
  if N = nil then
    Exit;
  {}
  if N.Level = 1 then
    NCatego := N.Parent
  else
    NCatego := N;
  {}
  if NCatego = NTransf.Parent then
    Exit;
  {}
  s  := Format( 'Transferir o tpico "%s" para a categoria "%s" ?'
  ,[NTransf.Text,NCatego.Text] );
  mr := MessageDlg(s,mtConfirmation,[mbYes,mbNo],0);
  s  := NCatego.Text+cArqSep+NTransf.Text;
  if (mr = mrYES) and RenArqTree(NTransf,s) then
    NTransf.MoveTo(NCatego,naAddChildFirst);
  NTransf := nil;
end;

function TfrmPrincipal.LimpaTexto(const s: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(s) do
    if not (s[i] in ['/',':','*','?','"'
    ,'<','>','|','.',',','%','_']) then
      Result := Result + s[i];
  // impede caracteres que NO podem ser usados em nomes de arquivos
end;

procedure TfrmPrincipal.dtpDataItemChange(Sender: TObject);
begin
  if dtpDataItem.Date < Date() then begin
    dtpDataItem.Date := Date();
    Exit;
  end;
  btnDataItem.Enabled := True;
end;

procedure TfrmPrincipal.btnDataItemClick(Sender: TObject);
var
  N: TTreeNode;
  s: string;
begin
  N := treeID.Selected;
  if N = nil then Exit;
  {}
  s := DateToStr(dtpDataItem.Date);
  with NovaCfg( NomeArqItem(N) ) do begin
    WriteString(cConfig,cEvento,s);
    Free;
  end;  // with
  btnDataItem.Enabled := False;
end;

procedure TfrmPrincipal.ConfiguraNode(N: TTreeNode);
var
  s: string;
  D: TDateTime;
begin
  if (N = nil)
  or (NTransf <> nil) then
    Exit;
  {}
  if (ActiveControl <> edtID)
  or (edtID.Text = '') then
    edtID.Text := N.Text;
  memCont.Enabled    := (N.Level = 1);
  popAtrib.AutoPopup := (N.Level = 1);
  if N.Level = 0 then begin
    memCont.Lines.Clear;
    pnlDataItem.Enabled := False;
    Exit;
  end;
  SalvaTxt;
  Alterado := True;
  s := NomeArqItem(N);
  if FileExists(s) then begin
    CarregaTxt(s);
    if AtzPosTexto
    and chkLstOp.Checked[2] then
      CarregaPosMemo(s);
  end
  else
    memCont.Lines.Clear;
  if N.Level = 0 then Exit;
  {Mostra datas dos eventos:}
  pnlDataItem.Enabled := True;
  D := Date();
  with NovaCfg(s) do begin
    s := ReadString(cConfig,cEvento,'');
    Free;
  end;  // with
  if s <> '' then
    try
      D := StrToDate(s);
    except
    end;
  dtpDataItem.Date := D;
  btnDataItem.Enabled := True;
  {Imagens associadas:}
  FechaImagens;
  CarregaImagens;
  NAtual := N;
end;

procedure TfrmPrincipal.treeIDClick(Sender: TObject);
begin
  ConfiguraNode(treeID.Selected);
end;

procedure TfrmPrincipal.mnuItemEventoClick(Sender: TObject);
begin
  FiltraEventos;
  PesquisaID(edtID.Text);
  mnuItemEvento.Checked := True;
  VerificaOrdenacao;
  AjustaCategorias;
end;

procedure TfrmPrincipal.FiltraEventos;
var
  i: integer;
  N: TTreeNode;
begin
  treeID.OnChange := nil;
  treeID.OnClick  := nil;
  treeID.Items.BeginUpdate;
  i := 0;
  while i < treeID.Items.Count do begin
    N := treeID.Items[i];
    if (N.Level = 0)
    or (N.StateIndex = 4) then
      Inc(i)
    else
      N.Delete;
  end;  // while
  NAtual := nil;
  treeID.Items.EndUpdate;
  treeID.OnChange := treeIDChange;
  treeID.OnClick  := treeIDClick;
  ConfiguraNode(treeID.Selected);
end;

procedure TfrmPrincipal.AjustaCategorias;
var
  i, icone_catego: integer;
  N: TTreeNode;
begin
  for i := 0 to treeID.Items.Count-1 do begin
    N := treeID.Items[i];
    if N.Level = 1 then Continue;
    {Coloca cone de acordo com o estado da Categoria...}
    if N.HasChildren then
      icone_catego := 0   // ...Livro aberto se possui tpicos
    else
      icone_catego := 5;  // ...Livro fechado se est vazia
    {}
    N.ImageIndex    := icone_catego;
    N.SelectedIndex := icone_catego;
  end;  // for
end;

function TfrmPrincipal.NovaCfg(const arq: string): TIniFile;
var
  s: string;
begin
  s := ChangeFileExt(arq,cExtCfg);
  Result := TIniFile.Create(s);
end;

procedure TfrmPrincipal.CarregaImagens;
var
  N: TTreeNode;
  iniC: TIniFile;
  Lista: TStringList;
  i: integer;
  s, _imagem: string;
{# rotina local:}
  function SubExpr(c: char): string;
  var
    p: integer;
  begin
    p := Pos(c,s);
    Result := Copy(s,1,p-1);
    Delete(s,1,p);
  end;
{#}
begin
  N := treeID.Selected;
  if N = nil then Exit;
  {}
  iniC  := NovaCfg( NomeArqItem(N) );
  Lista := TStringList.Create;
  iniC.ReadSectionValues(cImagem,Lista);
  for i := 0 to Lista.Count-1 do begin
    s := Lista[i];
    _imagem := SubExpr('=');
    with TfrmImagem.Create(self) do begin
      Left   := StrToInt( SubExpr(',') );
      Top    := StrToInt( SubExpr(',') );
      Width  := StrToInt( SubExpr(',') );
      Height := StrToInt(s);
      ArquivoImagem := _imagem;
    end;  // with
  end;
  iniC.Free;
  Lista.Free;
end;

procedure TfrmPrincipal.FechaImagens;
var
  iniC: TIniFile;
  i: integer;
  F: TfrmImagem;
  s: string;
begin
  if NAtual = nil then
    iniC := nil
  else begin
    iniC := NovaCfg( NomeArqItem(NAtual) );
    iniC.EraseSection(cImagem);
  end;  // else
  for i := Screen.FormCount-1 downto 0 do
    if Screen.Forms[i] is TfrmImagem then begin
      F := TfrmImagem(Screen.Forms[i]);
      if iniC <> nil then begin
        s := Format('%d,%d,%d,%d',[F.Left,F.Top,F.Width,F.Height]);
        iniC.WriteString(cImagem,F.ArquivoImagem,s);
      end;
      F.Free;
    end;
  iniC.Free;
end;

procedure TfrmPrincipal.btnImagensClick(Sender: TObject);
begin
  if odImagem.Execute then
    TfrmImagem.Create(self).ArquivoImagem := odImagem.FileName;
end;

procedure TfrmPrincipal.memContKeyPress(Sender: TObject; var Key: Char);
begin
  Alterado := True;
end;

procedure TfrmPrincipal.MarcaItemAtual;
var
  N: TTreeNode;
  s: string;
begin
  N := treeID.Selected;
  if N <> nil then begin
    if N.Level = 1 then
      s := N.Parent.Text+cItemSep
    else
      s := '';
    s := s + N.Text;    
    AtualizaLista(edtID,s);
  end;
end;

procedure TfrmPrincipal.mnuArqRecenteClick(Sender: TObject);
begin
  ProximoArquivo := mnuArqRecente.Caption;
end;

end.
