unit Imprimir;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, Printers, ExtCtrls, Menus;

type

  TTipoSel = (tselTudo,tselNenhum,tselInverte);

  TfrmImprimir = class(TForm)
    chklItens: TCheckListBox;
    panBotoes: TPanel;
    btnOpcoes: TButton;
    btnOk: TButton;
    btnCancela: TButton;
    pd: TPrintDialog;
    popSel: TPopupMenu;
    popSelTodos: TMenuItem;
    popSelDesmarca: TMenuItem;
    popSelInverte: TMenuItem;
    procedure btnOpcoesClick(Sender: TObject);
    procedure popSelTodosClick(Sender: TObject);
    procedure popSelDesmarcaClick(Sender: TObject);
    procedure popSelInverteClick(Sender: TObject);
    procedure chklItensClickCheck(Sender: TObject);
  private
    procedure AtualizaSelecao(sel: TTipoSel);
    function TemSelecionado: boolean;
  public
    {}
  end;

var
  frmImprimir: TfrmImprimir;

implementation

{$R *.DFM}

procedure TfrmImprimir.btnOpcoesClick(Sender: TObject);
begin
  pd.Execute;
end;

procedure TfrmImprimir.AtualizaSelecao(sel: TTipoSel);
var
  i: integer;
  ok: boolean;
begin
  ok := False;
  for i := 0 to chklItens.Items.Count-1 do begin
    case sel of
    tselTudo:
      ok := True;
    tselNenhum:
      ok := False;
    tselInverte:
      ok := not chklItens.Checked[i];
    end;  // case
    chklItens.Checked[i] := ok;
  end;  // for
  chklItensClickCheck(nil);
end;

procedure TfrmImprimir.popSelTodosClick(Sender: TObject);
begin
  AtualizaSelecao(tselTudo);
end;

procedure TfrmImprimir.popSelDesmarcaClick(Sender: TObject);
begin
  AtualizaSelecao(tselNenhum)
end;

procedure TfrmImprimir.popSelInverteClick(Sender: TObject);
begin
  AtualizaSelecao(tselInverte)
end;

function TfrmImprimir.TemSelecionado: boolean;
var
  i: integer;
begin
  for i := 0  to chklItens.Items.Count-1 do
    if chklItens.Checked[i] then begin
      Result := True;
      Exit;
    end;  // if
  Result := False;
end;

procedure TfrmImprimir.chklItensClickCheck(Sender: TObject);
begin
  btnOk.Enabled := TemSelecionado;
end;

end.
