unit Imagem;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Jpeg;

type
  TfrmImagem = class(TForm)
    img: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FArquivoImagem: string;
    procedure SetArquivoImagem(const Value: string);
  public
    property ArquivoImagem: string read FArquivoImagem write SetArquivoImagem;
  end;

var
  frmImagem: TfrmImagem;

implementation

{$R *.DFM}

procedure TfrmImagem.SetArquivoImagem(const Value: string);
begin
  try
    img.Picture.LoadFromFile(Value);
  except
    Exit;
  end;
  FArquivoImagem := Value;
  Caption := Value;
  Show;
end;

procedure TfrmImagem.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
