unit Example;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, Grids, DBGrids, StdCtrls, ExtCtrls, mktable,
  DBCtrls;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Panel2: TPanel;
    Label2: TLabel;
    Button4: TButton;
    Panel3: TPanel;
    Label3: TLabel;
    Button5: TButton;
    Button6: TButton;
    Table1: tTableDBF;
    Button7: TButton;
    Button8: TButton;
    Panel4: TPanel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    RecNum: TPanel;
    TableFilter1: TTableFilter;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function FilterEvent(DataSet: TDataset): Boolean;
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  { remember that the key is prov+area+sector+subsector }
  if Table1.FindKeyDBF('NS01020001') = false then ShowMessage('Key not found! Problem!');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  { remember that the key is prov+area+sector+subsector }
  if Table1.FindKeyDBF('NS01010099') = false then ShowMessage('Key not found! No problem.');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Table1.Pack;
  Table1.RegenerateIndexes;
  ShowMessage('Table packed and re-indexed.');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  { remember that the key is prov+area+sector+subsector }
  Table1.FindNearestDBF('NS20051');
  ShowMessage('Table1.FindNearestDBF("NS20051")');
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  Table1.CancelRangeDBF;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Table1.ApplyRangeDBF('NS02', 'NS03');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1.Open;
end;

function TForm1.FilterEvent(DataSet: TDataset): Boolean;
begin
  with DataSet do
  begin
    Result := (FieldByName('Area').AsString = '02');
  end;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  TableFilter1.Filter := TRUE;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  TableFilter1.Filter := FALSE;
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin

 if Table1.State = dsBrowse then
   RecNum.Caption := format('Record number %d of %d',
                            [Table1.RecordNumber, Table1.RecordCount])
 else
   RecNum.Caption := 'Editing or inserting';

end;

end.
