{***************************************************************}
{                                                               }
{         DBMailLabel component                                  }
{                                                               }
{         Copyright (C) 1997, by Walter Alves Chagas Junior     }
{         All rights reserved                                   }
{                                                               }
{    For comments, questions and suggestions, contact the       }
{    author at wchagas@horizontes.net                           }
{                                                               }
{***************************************************************}

unit DBMailLabel;

interface

{$IFNDEF WIN32}
  Sinto muito mas este componente somente roda em Plataformas Win9x
{$ENDIF}

uses
  Windows, ShellAPI, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, DBCtrls;

type
  TDBMailLabel = class(TDBText)
  private
    FColorNormal, FColorMoveOver, FColorClick: TColor;
    Down: Boolean;
    FMensagem: string;
    FAssunto: String;
    procedure CorrigeReturn;
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure CMMouseEnter(var Msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Msg: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property ColorNormal: TColor read FColorNormal write FColorNormal default clBlue;
    property ColorMoveOver: TColor read FColorMoveOver write FColorMoveOver default clBlue;
    property ColorClick: TColor read FColorClick write FColorClick default clRed;
    property Mensagem: string read FMensagem write FMensagem;
    property Assunto: string read FAssunto write FAssunto;
    property Cursor;
    property Hint;
    property Autosize;
    property ShowHint;
 end;

procedure Register;

implementation


{ ********* Unit support routines ********* }

procedure Register;
begin
RegisterComponents('Data Controls', [TDBMailLabel]);
end;


{ ****** TDBMailLabel public methods ****** }


procedure TDBMailLabel.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
Down := True; Font.Color := ColorClick;
end;

procedure TDBMailLabel.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Var 
ComandoMail : String;
begin
if (X >= 0) and (Y >= 0) and (Y <= Height) and (X <= Width) then
   begin
   if Down then
      begin
      ComandoMail := 'mailto:'+Field.AsString;
      If (FMensagem <> '') or (FAssunto <> '') then
         ComandoMail := ComandoMail + '?';
      If (FAssunto <> '') then
         Begin
         ComandoMail := ComandoMail+'Subject='+FAssunto;
         If (FMensagem <> '') then
             ComandoMail := ComandoMail+'&';
         End;
     If (FMensagem <> '') then
        Begin
        CorrigeReturn;
        ComandoMail := ComandoMail+'Body='+FMensagem;
        End;
     ShellExecute(ValidParentForm(Self).Handle, 'open', PChar(ComandoMail), nil, nil, SW_SHOW);
     Font.Color := ColorMoveOver;
     end;
   end
else
   begin
   Font.Color := ColorNormal;
   end;
Down := False;
end;


procedure TDBMailLabel.CMMouseEnter(var Msg: TMessage);
begin
if Down then
   begin
   Font.Color := ColorClick;
   end
else
   begin
   Font.Color := ColorMoveOver;
   end;
end;


procedure TDBMailLabel.CMMouseLeave(var Msg: TMessage);
begin
Font.Color := ColorNormal;
end;


constructor TDBMailLabel.Create(AOwner: TComponent);
begin
inherited Create(AOwner);
Font.Color := clBlue; Font.Style := [fsUnderline];
FColorNormal := clBlue; FColorMoveOver := clBlue; FColorClick := clRed;
ShowHint := True;
Autosize := True;
Hint := 'Contate-me: wchagas@horizontes.net';
Cursor :=-21;
end;


procedure TDBMailLabel.CorrigeReturn;
Var I,Tam : Integer;
    Msg : String;
Begin
  {Substitui #$D#$A por %0D%0A}
  Msg := FMensagem;
  Tam:=Length(Msg);
  For I := 1 to Tam do
  Begin
     If Msg[I] = #13 then
     Begin
        Delete(Msg,I,1);
        Insert('%0A',Msg,I);
        Tam := Tam+2;
     End;
     If Msg[I] = #10 then
     Begin
        Delete(Msg,I,1);
        Insert('%0D',Msg,I);
        Tam:=Tam+2;
     End;
  End;
  Fmensagem := Msg;
End;

end.
