{ Copyright  1996, Con Brio, Seward, all rights reserved.

Although I retain the copyright, this unit and demo are totally
free (along with source code).  You may use the unit i2bConvert
in any program, private or commercial.

If you find it useful (or even if you don't) then I would
appreciate any of the following:

   * An email message with greetings and where you hail from.
   * Comments, suggestions, bug finds, etc.
   * If you improve the unit, please send me a copy of the
     changes.
   * If you create a component from this code, please send me
     a copy (along with the source, if possible).

Mike Reith
Seward, NE, USA
mike@seward.ccsn.edu

This unit and the associated demo program can be freely used
and distributed in commercial and private environments, provided
this notice is not modified in any way and there is no charge
for it.

Date last modified:  26 July 1996
}

unit I2BConvert;

interface

uses
  Windows, Graphics;

const
  i2bDefaultColor : TColor = $00123456;  { pick a dark brown for the
                                           default transparent color }

procedure ConvertIcon2Bitmap(Icon : TIcon;
                             TransColor : TColor;
                         var Bitmap : TBitmap);

implementation

procedure ConvertIcon2Bitmap(Icon : TIcon;
                             TransColor : TColor;
                         var Bitmap : TBitmap);
{ Convert the supplied icon into a proper bitmap for Delphi button
  glyphs and return in Bitmap.  Use TransColor for the transparent
  color in the Bitmap.  See the demo program for examples on usage. }
var
  i,j : integer;           { loop control variables }
  IconInfo : TIconInfo;    { information about the icon }
  ANDmask : TBitmap;       { the AND mask of the icon }
  OldMaskColor : TColor;        { keep track of last color in AND mask }
  NewMaskColor : TColor;        { the current color in the AND mask }
begin  { convertIcon2Bitmap }
{ create bitmap for the icon AND mask information }
ANDmask := TBitmap.Create;
try
  { Get the icon information and place the AND mask into
    the appropriate TBitmap structure }
  GetIconInfo(Icon.Handle,IconInfo);
  ANDmask.Handle := IconInfo.hbmMask;
  { Set the returning bitmap size and draw the icon onto it }
  Bitmap.Width := ANDmask.Width;
  Bitmap.Height := ANDmask.Height + 1;  { add one line onto the bottom
                                          of the bitmap to keep the
                                          Delphi glyph happy }
  Bitmap.Canvas.Draw(0,0,Icon);

  { Where the ANDmask bitmap is transparent, place the transparent color }
  Bitmap.Canvas.Pen.Color := TransColor;
  for j := 0 to ANDmask.Height - 1 do
    begin  { for j }
    OldMaskColor := clRed;  { start off with a color that is not in the mask }
    Bitmap.Canvas.MoveTo(0,j);  { move the the first pixel of this row }
    for i := 0 to ANDmask.Width - 1 do
      begin  { for i }
      NewMaskColor := GetPixel(ANDmask.Canvas.Handle,i,j); { get pixel color }
      if NewMaskColor <> OldMaskColor then
        begin  { NewMaskColor <> OldMaskColor }
        { if the pixel is not the same color as the last pixel then we
          have a trasition -- either from transparent or to transparent
          colors }
        OldMaskColor := NewMaskColor;
        if NewMaskColor = clWhite then
          { transition from solid to transparent -- move to the first
            pixel of the transparent region }
          Bitmap.Canvas.MoveTo(i,j)
        else
          { transition from transparent to solid -- draw a line through
            the transparent region in the transparent color }
          Bitmap.Canvas.LineTo(i,j);
        end;   { NewMaskColor <> OldMaskColor }
      end;  { for i }
    { if the line ends with a transparent color then draw a line through
      the transparent region in the transparent color }
    if NewMaskColor = clWhite then
      Bitmap.Canvas.LineTo(ANDmask.Width,j);
    end;  { for j }

  { place an extra line at the bottom of the bitmap so that the
    Delphi TSpeedButton transparent color works correctly }
  Bitmap.Canvas.MoveTo(0,Bitmap.Height - 1);
  Bitmap.Canvas.LineTo(Bitmap.Width,Bitmap.Height - 1);
  finally
    { Release the memory for the icon information }
    ANDmask.Free;
    end;  { try..finally }
end;  { ConvertIcon2Bitmap }

end.  { I2BConvert }

