unit Register;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, Label3d;

type
  TRegisterDlg = class(TForm)
    Bevel1: TBevel;
    ProgramIcon: TImage;
    Bevel2: TBevel;
    Label7: TLabel;
    Components: TLabel;
    Label8: TLabel;
    RegistrationInfo: TLabel;
    OkBtn: TBitBtn;
    Label3D1: TLabel3D;
    Label3D2: TLabel3D;
    Label3D3: TLabel3D;
    Label3D4: TLabel3D;
    ProgramName: TLabel3D;
    Version: TLabel3D;
    Label3D5: TLabel3D;
    procedure OKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RegisterDlg: TRegisterDlg;

implementation

{$R *.DFM}

procedure TRegisterDlg.OKBtnClick(Sender: TObject);
begin
   Close;
end;

procedure TRegisterDlg.FormCreate(Sender: TObject);
begin
{Get program icon}
    ProgramIcon.Picture.Graphic := Application.Icon;
    {Set Aboutbox Program Name & Version}
    RegisterDlg.ProgramName.Caption := ExtractFileName(Application.EXEName);
    RegisterDlg.Version.Caption := 'Version 1.0';
    RegisterDlg.Components.Caption := 'Requires the GrafLite Shareware Visual Component to recompile '+
                                      'as written.  If the shareware component is not '+
                                      'available, delete all references to GraphicLight in the project.';
    RegisterDlg.RegistrationInfo.Caption := 'This is a freeware program to promote the shareing of source code '+
                                            'on the Borland Forum on Compuserve.  '+
                                            '  Formatting code based on a unit provided by Henning Jorgensen of Denmark.'+
                                            '  The author assumes no responsibity for use or misuse of this program.';
end;

end.
