unit About;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Register, Label3d;

type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    Panel2: TPanel;
    Label7: TLabel;
    WinVersion: TLabel;
    Label8: TLabel;
    DosVersion: TLabel;
    Label9: TLabel;
    Coprocessor: TLabel;
    Label10: TLabel;
    CPU: TLabel;
    Label11: TLabel;
    FreeMemory: TLabel;
    Label12: TLabel;
    FreeResources: TLabel;
    Label13: TLabel;
    FreeDisk: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ProgramName: TLabel3D;
    Version: TLabel3D;
    Label3D1: TLabel3D;
    Label3D2: TLabel3D;
    Label3D3: TLabel3D;
    Label3D4: TLabel3D;
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    fileHandle: THandle;
    fileBuffer: Array [0..29] of Char;
    wVersion: Word;
    dVersion: Word;
    winFlags: LongInt;
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

{$R *.DFM}

procedure TAboutBox.BitBtn2Click(Sender: TObject);
begin
RegisterDlg.Show
end;

procedure TAboutBox.BitBtn1Click(Sender: TObject);
begin
   Close;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
    {Get program icon}
    ProgramIcon.Picture.Graphic := Application.Icon;
    {Set Aboutbox Program Name & Version}
    AboutBox.ProgramName.Caption := ExtractFileName(Application.EXEName);
    AboutBox.Version.Caption := 'Version 1.0';
    { Get Win/Dos version numbers }
    wVersion := LoWord(GetVersion);
    dVersion := HiWord(GetVersion);
    AboutBox.WinVersion.Caption := IntToStr(LO(wVersion)) + '.' +
                                   IntToStr(HI(wVersion));
    AboutBox.DosVersion.Caption := IntToStr(HI(dVersion)) + '.' +
                                   IntToStr(LO(dVersion));

    winFlags := GetWinFlags;

    { Get math coprocessor status }
    if winFlags and WF_80x87 > 0 then
        AboutBox.Coprocessor.Caption := 'Present'
    else
        AboutBox.Coprocessor.Caption := 'Not Present';

    { Get CPU type }
     if winFlags and WF_CPU486 > 0 then
        AboutBox.CPU.Caption := '486';
     if winFlags and WF_CPU386 > 0 then
        AboutBox.CPU.Caption := '386';
     if winFlags and WF_CPU286 > 0 then
        AboutBox.CPU.Caption := '286';

     { Get free memory, resources, disk space }
     AboutBox.FreeMemory.Caption := IntToStr(GetFreeSpace(0) div 1000) + ' KB';
     AboutBox.FreeResources.Caption := IntToStr(GetFreeSystemResources(GFSR_SYSTEMRESOURCES))
                                       + '%';
     AboutBox.FreeDisk.Caption := IntToStr(DiskFree(0) div 1000000) + ' MB';

end;

end.
