unit filprops;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FILEPROP, StdCtrls, ExtCtrls, ComCtrls;

type
  TfrmFileProperties1 = class(TfrmFileProperties)
    btnDelete: TButton;
    procedure btnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFileProperties1: TfrmFileProperties1;

implementation

{$R *.DFM}

procedure TfrmFileProperties1.btnDeleteClick(Sender: TObject);
begin
  inherited;

  // the user has asked to delete this file....
  if MessageDlg ('Are you sure you want to delete the file' +
                 #13 + filename, mtWarning, [mbYes, mbNo], 0) = mrYes
  then
    begin
    if not DeleteFile (filename) then
      Application.MessageBox (PChar (filename),
                              'Can''t delete file',
                              MB_ICONEXCLAMATION + MB_OK);
    ModalResult := mrOK;
    end;
end;

end.
