unit Mainwin;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FileCtrl, StdCtrls, Buttons, Splash, DirNav;

type
  TMain = class(TForm)
    ListBox1: TListBox;
    SearchBtn: TBitBtn;
    BitBtn2: TBitBtn;
    DirectoryListBox1: TDirectoryListBox;
    FilterComboBox1: TFilterComboBox;
    DriveComboBox1: TDriveComboBox;
    CheckBox1: TCheckBox;
    FileMask: TEdit;
    DirNav: TDirNavigator;
    procedure SearchBtnClick(Sender: TObject);
    procedure FilterComboBox1Change(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirNavRecurse(Sender: TObject);
    procedure DirNavBeforeNavigate(Sender: TObject);
    procedure DirNavAfterNavigate(Sender: TObject);
  private
    { Private declarations }
    procedure GetMasks;
  public
    { Public declarations }
  end;

var
  Main: TMain;
  CurrentDir: String;

implementation

{$R *.DFM}

procedure TMain.SearchBtnClick(Sender: TObject);
begin
  Main.ListBox1.Clear;
  if CheckBox1.Checked then DirNav.Navigate
  else GetMasks;
  ListBox1.Items.Insert(0,IntToStr(ListBox1.Items.Count)+' files matching '+FileMask.Text+' found');
end;

procedure TMain.FilterComboBox1Change(Sender: TObject);
begin
  FileMask.Text := FilterComboBox1.Mask;
end;

procedure TMain.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
end;

procedure TMain.GetMasks;
var
  LocalDir: String;
  Sr: TSearchRec;
  DosError: integer;
begin
  LocalDir := ExpandFileName('.');
  if LocalDir[Length(LocalDir)] <> '\' then
    LocalDir := LocalDir + '\';
  DosError := FindFirst(FileMask.Text, faArchive, Sr);
  while DosError = 0 do with Sr do
  begin
    Main.ListBox1.Items.Add(LocalDir+Name);
    DosError := FindNext(Sr);
  end;
end;

procedure TMain.DirNavRecurse(Sender: TObject);
begin
  GetMasks;
end;

procedure TMain.DirNavBeforeNavigate(Sender: TObject);
begin
  CurrentDir := ExpandFileName('.');
end;

procedure TMain.DirNavAfterNavigate(Sender: TObject);
begin
  ChDir(CurrentDir);
end;

end.
