library ckshow;
{
    This is a port of the CKSHOW example program included
    in the WSAPI developer's kit (as shipped with WebSite Pro).
    Port by Paul Gallagher, 1997 <paulpg@ozemail.com.au>
}
//========================================================================
// COPYRIGHT NOTICE:
//				Copyright (C) 1996, Robert B. Denny, Pasadena, California
//				All Rights Reserved
// PROPRIETARY RIGHTS NOTICE:
//				This source code is the property of Robert B. Denny of
//				Pasadena, California, and is furnished under license only.
//========================================================================
// TITLE:		CKSHOW.C
//
// FACILITY:	WSAPI Cookie displayer
//
// ABSTRACT:	This WSAPI "CGI" extension simply displays any Cookies
//				that may be present in a request. It is supplied as a
//				accessory to the "gcookie giver" preprocessor example.
//
// INSTALLING:	To install this WSAPI extension add a registry KEY (e.g.)
//
//		HKEY_LOCAL_MACHINE\SOFTWARE\Denny\WebServer\CurrentVersion\CGI\DLL\ckshow
//
//				and under this key, add a value "ExtCgiDll", a REG_SZ,
//				with  the name of the DLL (if it is located in the same
//				directory as the server httpd.exe, or the full physical
//				pathname of the DLL (if it is located elsewhere). Also add
//				another value "ExtCgiEntry", a REG_SZ, with the string
//				'ShowCookies' (the action routine's entry point name).
//
//
// USING:		Fetch http://x.y.z/~wsapi/ckshow and you'll see any
//				cookies that are present in your request. Note that
//				only cookies valid for the paths '/', '/~wsapi' or
//				'/~wsapi/ckshow' will be shown.
//
// ENVIRONMENT:	WebSite Professional 1.0 or later, WSAPI 1.0 (or later)
//				Microsoft Windows Windows NT 3.5x, Windows 95
//				Developed under Microsoft Visual C++ Version 4.0
//
// AUTHOR:		Robert B. Denny
//
// Edit Log:
//
// When			Who		What
//----------	---		--------------------------------------------------
// 12-Mar-96	rbd		Initial edit
// 13-Apr-96	rbd		Action routine -> Process() for server-side applet
//						"clear" content-length and turn off keep-alive.
// 26-Jan-97    paulg           Port to Delphi
//========================================================================

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Windows,
  WSAPI in '..\..\lib\WSAPI.pas';

//========================================================================
//
// Process() - Generate an HTML report on cookies
//
//========================================================================
function Process(tp : PTCTX) : Boolean; export; cdecl;
var
  st: TSystemTime;
  buf : string;
  tbuf : array[0..SML_STRING_LEN] of Char;
  i : integer;
  bFound : boolean;
begin

  //
  // Start the report
  //
  tp^.keep_alive := FALSE;			// so no keep-alive on this!
  StrPCopy(tp^.content_type,'text/html');
  tp^.content_length := -1;		// No content-length
  send_http_header(tp, False);		// Defaults to text/html, send extra headers

  nputs('<HTML><HEAD>'#13#10, tp);
  nputs('<TITLE>WSAPI Cookie Report</TITLE>'#13#10, tp);
  nputs('</HEAD>'#13#10'<BODY BGCOLOR=#FFFFFF>'#13#10, tp);
  nputs('<H1>WSAPI Cookie Report</H1>'#13#10, tp);
  GetSystemTime(st);
  http_nt_timestr(@st, tbuf, sizeof(tbuf));
  nputs('<I>', tp);
  nputs(PChar('<I>' + tbuf + '</I>'#13#10'<HR>'), tp);
  nputs('Here are the cookies you sent:'#13#10'<P>', tp);
  //
  // Search extra headers for cookies and display
  //
  if (tp^.num_req_xhdr>0) then
    for i := 0 to tp^.num_req_xhdr-1 do begin
      if (StriComp(PChar(tp^.req_xhdr[i].key), 'Cookie') = 0) then begin
        // Found one
        bFound := TRUE;
        buf := Format('<TT>%s: %s</TT><BR>'#13#10,
                     [PChar(tp^.req_xhdr[i].key),
     	            PChar(tp^.req_xhdr[i].value)]);
        nputs(PChar(buf), tp);
      end;
    end;

  if not bFound then								// No cookies
	nputs('<H2>No cookies in this request.</H2>', tp);

  //
  // Finish off the document & return
  //
  nputs('<HR></BODY></HTML>'#13#10, tp);

  Result:=True;
end;



exports
  Process;

begin
  // module initialisation
  if not bind_wsapi(MAJOR_VERSION, MINOR_VERSION, FALSE) then
    ExitCode:=1; // cause DLL load to fail
end.
