{========================================================|
| DrMeter (Ver 1.00) - (c) 1997 by Alvaro L. S. Almeida  |
|--------------------------------------------------------|
| Pointer meter. Like a VU used in sound machines. It is |
| good to indicate, for example, percentage, Volts...    |
| For Delphi 1, 2 e 3 (16 and 32 bits)                   |
|                                                        |
| See other components in our home-page.                 |
|--------------------------------------------------------|
| DROID Informatica ltda - Rio de Janeiro - Brazil       |
|                                                        |
| Home Page: http://www.di.com.br                        |
| E-Mail:    comp@di.com.br                              |
| Fax:       055 021 224-0331                            |
|========================================================}

unit drMeter;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TVuBorder = (boNone, boSingle, boRaised, boLowered);
  TVuDispScale = (dsDefault, dsPercent, dsDivBy10, dsDivBy100, dsDivBy1000, dsDivBy10000);

  TDRMeter = class(TGraphicControl)
  private
    FDivisor,                { Used by TVuDispScale }
    radius,
    FScalePoints : integer;  { number of points in the scale of the meter }

    FBackColor   : TColor;
    FScaleColor  : TColor;
    FPointerColor: TColor;

    FDispGrad    : boolean;  { if true, display gradient }
    FDispText    : boolean;  { if true, display values   }

    scale,                   { max - min }
    FMax,                    { max }
    FMin,                    { min }
    FPosition,               { Actual "position" }
    OldPointer   : LongInt;  { Old "position"    }

    xc,yc,                   { xc: width div 2 - yc: heigth div 2 }
    lx,ly,base   : integer;  { base: radius of the base of the pointer }

    FBorder      : TVuBorder;{ Border type }

    LabelLoc,
    BasePointer,             { width of the bottom of the pointer }
    PointerMult,             { used to calculate the size of the pointer }
    LineMult1,               { used to calculate the size of the scale points }
    LineMult2,               { used to calculate the size of the scale points }
    TextMult     : real;     { used to calculate the text position }

    FDispScale   : tVuDispScale;

  protected
    procedure Paint; override;
    procedure SetPointer(posi:LongInt; clear:boolean);
    procedure SetMults;

  public
    constructor Create(AOwner: TComponent); override;

  published
    property Align;
    property Enabled;
    property Visible;
    property Font;
    property ShowHint;
    property DisplayScale:    TVuDispScale read  FDispScale
                                           write SetDispScale;
    property DisplayGradient: boolean      read  FDispGrad
                                           write SetDispGrad;
    property DisplayText:     boolean      read  FDispText
                                           write SetDispText;
    property Position:        LongInt      read  FPosition
                                           write SetPosition;
    property Color:           TColor       read  FBackColor
                                           write SetBackColor;
    property ScaleColor:      TColor       read  FScaleColor
                                           write SetScaleColor;
    property PointerColor:    TColor       read  FPointerColor
                                           write SetPointerColor;
    property ScalePoints:     integer      read  FScalePoints
                                           write SetScalePoints;
    property Max:             LongInt      read  FMax
                                           write SetMax;
    property Min:             LongInt      read  FMin
                                           write SetMin;
    property Border:          TVuBorder    read  FBorder
                                           write SetBorder;
  end;

procedure Register;

implementation

{ . . . }

procedure Register;
begin
  RegisterComponents('DROID', [tDrMeter]);
end;

end.
