{=====================================================|
| Analogical Clock - Ver 1.00                         |
| (c) 1996 by Alvaro L. S. Almeida                    |
|-----------------------------------------------------|
| Displays an analog clock, in Delphi programs.       |
| For Delphi 1, 2 e 3 (16 and 32 bits)                |
|                                                     |
| See other components in our home-page.              |
|-----------------------------------------------------|
| DROID Informatica ltda - Rio de Janeiro - Brazil    |
|                                                     |
| Home Page: http://www.di.com.br                     |
| E-Mail:    comp@di.com.br                           |
| Fax:       055 021 224-0331                         |
|=====================================================}

unit DrClock;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Dialogs, ExtCtrls;

type
  TDRBorder = (boNone, boSingle, boRaised, boLowered);

  TDRClock  = class(TGraphicControl)
  private
    lxS,
    lyS,
    lxM,
    lyM,
    lxH,
    lyH,
    MinAnt,
    SecAnt,
    Hour,
    Min,
    Sec,
    MSec         : Word;

    FTimer       : TTimer;
    FBorder      : TDRBorder;

    FEnabled,
    FDispPoints,
    FDispText    : boolean;

    HWidth,                  { Width od the hour pointer }
    MWidth,                  { Width od the minute pointer }
    xc,yc,                   { xc: width div 2 - yc: heigth div 2 }
    lx,ly,base,              { base: radius of the base of the pointer }
    radius       : integer;

    FBackColor,
    FScaleColor,
    FSecondsColor,
    FPointerColor: TColor;

    LabelLoc,
    PointerMultM,            { used to calculate the size of the minute pointer }
    PointerMultH,            { used to calculate the size of the hour pointer }
    LineMult1,               { used to calculate the size of the scale points }
    LineMult2,               { used to calculate the size of the scale points }
    TextMult     : real;     { used to calculate the text position }

    procedure SetBorder(Value: TDRBorder);
    procedure FTimerOnTimer(sender:TObject);
    procedure SetBackColor(value:TColor);
    procedure SetPointerColor(value:TColor);
    procedure SetSecondsColor(value:TColor);
    procedure SetScaleColor(value:TColor);
    procedure SetDispText(value: boolean);
    procedure SetDispPoints(Value: boolean);
    procedure SetEnabled(Value: boolean);

  protected
    procedure Paint; override;
    procedure SetMults;

  public
    constructor Create(AOwner: TComponent); override;

  published
    property Align;
    property Visible;
    property Font;
    property ShowHint;

    property Border:        TDRBorder  read  FBorder
                                       write SetBorder;
    property Color:         TColor     read  FBackColor
                                       write SetBackColor;
    property PointerColor:  TColor     read  FPointerColor
                                       write SetPointerColor;
    property SecondsColor:  TColor     read  FSecondsColor
                                       write SetSecondsColor;
    property ScaleColor:    TColor     read  FScaleColor
                                       write SetScaleColor;
    property DisplayText:   boolean    read  FDispText
                                       write SetDispText;
    property DisplayPoints: boolean    read  FDispPoints
                                       write SetDispPoints;
    property Enabled:       boolean    read  FEnabled
                                       write SetEnabled;

  end;

procedure Register;

implementation

   { . . . }

procedure Register;
begin
  RegisterComponents('DROID',[TDRClock]);
end;

end.
