unit graf;
interface
uses graph,mouse;

procedure StartGraph(Tall:word);
procedure EndGraph;
FUNCTION LoadFont(FontName:STRING):INTEGER;

const GraphOn : boolean = false;
      Mode : integer = 0;
      MyFont : word = 0;

var   gd,gm : integer;
var   Result:integer;

implementation

function AutoDet:integer; far;
begin
  AutoDet := Mode;
end;

procedure BGI256Proc; external;
{$L BGI256.OBJ}

procedure SmallFontProc; external;
{$L LITT.OBJ}

{------------------------------------------------}
procedure StartGraph(Tall:word);
var Err:integer;
begin
  if not GraphOn then


    GraphOn := false;
    case Tall of
     0..200 : Mode := 0;
     201..480 : Mode := 2;
     481..600: Mode := 3;
     else Mode := 3;
    end;
    gm := mode;
    gd := InstallUserDriver('BGI256',@AutoDet);
    Result := RegisterBGIDriver(@BGI256Proc);

    gd := 0;
    InitGraph(gd,gm,'');
    Err := GraphResult;
    if Err <> 0 then
    begin
      writeln('Eek! no graphics! ',GraphErrorMsg(Err));
      halt(1);
    end;
    GraphOn := true;
end;

procedure EndGraph;
begin
  HideMouse;
  if GraphOn then
    CloseGraph;
end;

{$I-}
FUNCTION LoadFont(FontName:STRING):INTEGER;
VAR FontF: file;
    FontP: pointer;
    FontNumber : integer;
BEGIN
  if FontName <> 'LITT.CHR' then
  begin
    FontNumber := InstallUserFont(FontName);   { Install the font }
    IF GraphResult <> grOk THEN
    BEGIN
      Writeln('Error installing ',FontName,' (using DefaultFont)');
      Exit;
    END;

    Assign(FontF, FontName);
    Reset(FontF, 1);
    GetMem(FontP, FileSize(FontF));
    BlockRead(FontF,FontP^,FileSize(FontF));
    CLOSE(FontF);
  end
  else
  begin
    FontP := @SmallFontProc;
  end;

  FontNumber := RegisterBGIfont(FontP);
  LoadFont := FontNumber;
  IF FontNumber < 0 THEN
  BEGIN
    WriteLn('Error registering font: ',FontName,' (',
            GraphErrorMsg(GraphResult),')');
    LoadFont := 0;
  END;

END;


end.
