{ TDialer component for Borland DELPHI, Version 1.00.
     Freeware.
  Original code by Artchil Gogava, ArGo Software Design, Toronto, Canada.
October 1995.
     Internet: 75231.330@compuserve.com
     www     : http://www.icacomp.com/customers/agogava
  Changes for Borland DELPHI 2.0 made by:
     Ruud Overdijk, Kwarts produkties, Hilversum, The Netherlands, April 1996.
     Internet : roverdyk@worldaccess.nl
     Compuserve :  71613,1733 }

unit Dialer;

interface

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs;
type

  TComPort = (dpCOM1,dpCOM2,dpCOM3,dpCOM4);
  TMethod  = (dmTone,dmPulse);

  TDialer = class(TComponent)
  private
    { Private declarations }
    FComPort : TComPort;
    FNumberToDial : string;
    FConfirm : boolean;
    FMethod : TMethod;
  protected
    { Protected declarations }
  public
    { Public declarations }

    procedure Execute;
  published
    property ComPort : TComPort read FComPort
                 write FComPort;
    property Confirm : boolean read FConfirm
                 write FConfirm;
    property Method  : TMethod read FMethod
                 write FMethod;
    property NumberToDial : string read FNumberToDial
                 write FNumberToDial;
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDialer]);
end;

procedure TDialer.Execute;
var
  s		: string;
  hCommFile 	: THandle;
  Status 	: LongBool;
  NumberWritten	: DWORD;
begin
  if FConfirm then
  begin
  if MessageDlg('About to dial the number '+FNumberToDial+'. Are you sure?',
      mtConfirmation, [mbYes,mbNo], 0)=mrNo then Exit;
  end;
  {Open Com Port}
  s:='COM'+Chr(49+Ord(FComPort));
  hCommFile:= CreateFile( PChar(s), GENERIC_WRITE,
                                0, {not shared}
                                nil, {no security ??}
                                OPEN_EXISTING,
                                FILE_ATTRIBUTE_NORMAL,
                                0 {template} );
  if hCommFile=INVALID_HANDLE_VALUE then
  begin
    MessageDlg('Unable to open '+s,mtError,[mbOk], 0);
    Exit;
  end;
  {Create a string to send to modem}
  s:='ATDT'+FNumberToDial+#13+#10;
  if FMethod=dmPulse then s[4]:='P';
  {Send phone number to modem}
  NumberWritten:=0;
  Status:=WriteFile( hCommFile,PChar(s)[0],
                     Length(s),
                     NumberWritten,
                     nil);
  if Status then
  begin
    MessageDlg('Pick up phone',mtInformation,[mbOk], 0);
    WriteFile(hCommFile,'ATH'^M^J,5,NumberWritten,nil);
  end
  else
    MessageDlg('Unable to dial number',mtError,[mbOk], 0);
  {Close communication port}
  CloseHandle(hCommFile);
end;

end.
