unit gbCob399;

interface

uses
   classes, SysUtils, {DateUtils, }gbCobranca
   {$IFDEF VER140}
      , MaskUtils, contnrs
   {$ELSE}
      {$IFDEF VER130}
         , Mask, contnrs
      {$ELSE}
         , Mask
      {$ENDIF}
   {$ENDIF}
   ;

const
   CodigoBanco = '399';
   NomeBanco = 'HSBC';

type

   TgbBanco399 = class(TPersistent)
   published
      function  GetNomeBanco   : string; {Retorna o nome do banco}
      function  GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string; {Retorna o contedo da parte varivel do cdigo de barras}
      function  CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string; {Calcula o dgito do NossoNumero, conforme critrios definidos por cada banco}
      procedure FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string); {Define o formato como alguns valores sero apresentados no boleto }
{$IFNDEF VER120}
      function  LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean; {L o arquivo retorno recebido do banco}
      function  GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean; {Gerar arquivo remessa para enviar ao banco}
{$ENDIF}
   end;


implementation


function TgbBanco399.GetNomeBanco : string;
begin
   Result := NomeBanco;
end;

function TgbBanco399.CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string;
var
   ANossoNumero,
   ACodigoCedente,
   ADataVencimento,
   ADigitoNossoNumero, ADigitoNossoNumero1 : string;
begin
   Result := '0';

   ANossoNumero := Formatar(ATitulo.NossoNumero,13,false,'0');
   ACodigoCedente := Formatar(ATitulo.Cedente.CodigoCedente,7,false,'0');
   ADigitoNossoNumero1 := Modulo11(ANossoNumero,9);
   if ATitulo.DataVencimento <> 0  then
   begin
      ADataVencimento := FormatDateTime('ddmmyy',ATitulo.DataVencimento);
      ADigitoNossoNumero := Modulo11(IntToStr(StrToInt(ANossoNumero + ADigitoNossoNumero1 + '4') + StrToInt(ACodigoCedente) + StrToInt(ADataVencimento)));
      ADigitoNossoNumero := ADigitoNossoNumero1 + '4' + ADigitoNossoNumero;
   end
   else
   begin
      ADigitoNossoNumero := Modulo11(IntToStr(StrToInt(ANossoNumero + ADigitoNossoNumero1 + '5') + StrToInt(ACodigoCedente)));
      ADigitoNossoNumero := ADigitoNossoNumero1 + '5' + ADigitoNossoNumero;
   end;
   Result := ADigitoNossoNumero;
end;

function TgbBanco399.GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string;
var
   ADiaDoAno,
   AUltimoDigitoDoAno,
   ADataVencimentoJuliano,
   ANossoNumero,
   ACodigoCedente: string;
begin

   {
    A primeira parte do cdigo de barras ser calculada automaticamente.
    Ela  composta por:
    Cdigo do banco (3 posies)
    Cdigo da moeda = 9 (1 posio)
    Dgito do cdigo de barras (1 posio) - Ser calculado e includo pelo componente
    Fator de vencimento (4 posies) - Obrigatrio a partir de 03/07/2000
    Valor do documento (10 posies) - Sem vrgula decimal e com ZEROS  esquerda

    A segunda parte do cdigo de barras  um campo livre, que varia de acordo
    com o banco. Esse campo livre ser calculado por esta funo (que voc dever
    alterar de acordo com as informaes fornecidas pelo banco).
   }

   {Segunda parte do cdigo de barras - Campo livre - Varia de acordo com o banco}

   with ATitulo do
   begin
      ACodigoCedente := Formatar(Cedente.CodigoCedente,7,false,'0');
      ANossoNumero := Formatar(NossoNumero,13,false,'0');
      {
       O preenchimento da data de vencimento em formato juliano, somente deve
       ser feito, se e somente se, para tipo identificador "4" e com retorno
       dos 3 dgitos no arquivo magntico e demonstrativo de liquidao
       (condio cadastral).

       Data de vencimento informada atravs de ms juliano.  Exemplo:
       -  001  -  corresponde a 01 de janeiro
       -  042  -  corresponde a 11 de fevereiro

       A ltima posio dessas deve ser utilizada para representar o ano. Exemplo:
       -  0 a 7  -  corresponde: 2000 a 2007
       -  8 e 9  -  corresponde: 1998 e 1999

       Para o tipo identificador 5 ou tipo de identificador 4 sem o retorno dos
       3 dgitos, a data de vencimento no formato juliano deve ser zerada (0000).
      }
//      ADataVencimentoJuliano := Formatar( IntToStr(1 + Trunc(Now - EncodeDate(StrToInt(FormatDateTime('yyyy',Now)),1,1))) + FormatDateTime('y',Now) ,4,false,'0');
      if DataVencimento = 0 then
         ADataVencimentoJuliano := '0000'
      else
      begin
          ADiaDoAno := Formatar(IntToStr(Trunc(DataVencimento - EncodeDate(StrToInt(FormatDateTime('yyyy',DataVencimento))-1,12,31))),3,false,'0');
          AUltimoDigitoDoAno := FormatDateTime('y',DataVencimento);
          ADataVencimentoJuliano := ADiaDoAno + AUltimoDigitoDoAno;
      end;
   end;

   Result := ACodigoCedente + ANossoNumero + ADataVencimentoJuliano + '2';
end;

procedure TgbBanco399.FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string);
begin
   with ATitulo do
   begin
      AAgenciaCodigoCedente := Cedente.ContaBancaria.CodigoAgencia + '/' + Cedente.CodigoCedente;
      ANossoNumero := Formatar(NossoNumero,13,false,'0') + '-' + DigitoNossoNumero;
      ACarteira := Formatar(Carteira,3);
      AEspecieDocumento := '';
   end;
end;

{$IFNDEF VER120}

function TgbBanco399.GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
begin
   Result := FALSE;
   Raise Exception.CreateFmt('Gerao de arquivo remessa no est disponvel para o banco %s - %s',[CodigoBanco, NomeBanco]);
end;

function TgbBanco399.LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
begin
   Result := FALSE;
   Raise Exception.CreateFmt('Processamento de arquivo retorno no est disponvel para o banco %s - %s',[CodigoBanco, NomeBanco]);
end;

{$ENDIF}

initialization
RegisterClass(TgbBanco399);

end.
