unit gbCob021;

interface

uses
   classes, SysUtils, gbCobranca
   {$IFDEF VER140}
      , MaskUtils, contnrs
   {$ELSE}
      {$IFDEF VER130}
         , Mask, contnrs
      {$ELSE}
         , Mask
      {$ENDIF}
   {$ENDIF}
   ;

const
   CodigoBanco = '021';
   NomeBanco = 'BANESTES';

type

   TgbBanco021 = class(TPersistent)
   published
      function  GetNomeBanco   : string; {Retorna o nome do banco}
      function  GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string; {Retorna o contedo da parte varivel do cdigo de barras}
      function  CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string; {Calcula o dgito do NossoNumero, conforme critrios definidos por cada banco}
      procedure FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string); {Define o formato como alguns valores sero apresentados no boleto }
{$IFNDEF VER120}
      function  LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean; {L o arquivo retorno recebido do banco}
      function  GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean; {Gerar arquivo remessa para enviar ao banco}
{$ENDIF}
   end;


implementation

function DigitosChaveASBACE(ChaveASBACESemDigito : string) : string;
{Calcula os 2 dgitos usados na CHAVE ASBACE - Cdigo usado por bancos estaduais}
var
   Digito1, Digito2 : integer;

   function CalcularDigito1(ChaveASBACESemDigito : string) : integer;
   {
    Calcula o primeiro dgito.
    O clculo  parecido com o da rotina Modulo10. Porm, no faz diferena o
    nmero de dgitos de cada subproduto.
    Se o resultado da operao for 0 (ZERO) o dgito ser 0 (ZERO). Caso contrrio,
    o dgito ser igual a 10 - Resultado.
   }
   var
      Auxiliar, Soma, Contador, Peso, Digito1 : integer;
   begin
      Soma := 0;
      Peso := 2;
      for Contador := Length(ChaveASBACESemDigito) downto 1 do
      begin
         Auxiliar := (StrToInt(ChaveASBACESemDigito[Contador]) * Peso);
         if Auxiliar > 9 then
            Auxiliar := Auxiliar - 9;
         Soma := Soma + Auxiliar;
         if Peso = 1 then
            Peso := 2
         else
            Peso := 1;
      end;

      Digito1 := Soma mod 10;
      if (Digito1 = 0) then
         Result := Digito1
      else
         Result := 10 - Digito1;
   end;

   function CalcularDigito2(ChaveASBACESemDigito : string; var Digito1 : integer) : integer;
   {Calcula o segundo dgito}
   var
      Digito2 : integer;
      ChaveASBACEComDigito1 : string;
   begin
      ChaveASBACEComDigito1 := ChaveASBACESemDigito + IntToStr(Digito1);
      Digito2 := StrToInt(Modulo11(ChaveASBACEComDigito1,7,true));
      {Se dgito2 = 1, deve-se incrementar o dgito1 e recalcular o dgito2}
      if Digito2 = 1 then
      begin
         Digito1 := Digito1 + 1;
         {Se, aps incrementar o dgito1, ele ficar maior que 9, deve-se
          substitu-lo por 0}
         if Digito1 > 9 then
            Digito1 := 0;
         Digito2 := CalcularDigito2(ChaveASBACESemDigito, Digito1);
      end
      else if Digito2 > 1 then
      begin
         Digito2 := 11 - Digito2;
      end;

      Result := Digito2;
   end;

begin
   Digito1 := CalcularDigito1(ChaveASBACESemDigito);
   Digito2 := CalcularDigito2(ChaveASBACESemDigito, Digito1);

   Result := IntToStr(Digito1) + IntToStr(Digito2);
end;


function TgbBanco021.GetNomeBanco : string;
begin
   Result := NomeBanco;
end;

function TgbBanco021.CalcularDigitoNossoNumero(ATitulo: TgbTitulo) : string;
var
   ANossoNumero,
   ADigitoNossoNumero : string;
begin
   Result := '0';

   ANossoNumero := Formatar(ATitulo.NossoNumero,8,false,'0');
   ADigitoNossoNumero := Modulo11(ANossoNumero,9);
   ADigitoNossoNumero := Modulo11(ANossoNumero + ADigitoNossoNumero,10);

   Result := ADigitoNossoNumero;
end;

function TgbBanco021.GetCampoLivreCodigoBarra(ATitulo: TgbTitulo) : string;
var
   ANossoNumero,
   ANumeroConta,
   ACampoLivre: string;
begin

   {
    A primeira parte do cdigo de barras ser calculada automaticamente.
    Ela  composta por:
    Cdigo do banco (3 posies)
    Cdigo da moeda = 9 (1 posio)
    Dgito do cdigo de barras (1 posio) - Ser calculado e includo pelo componente
    Fator de vencimento (4 posies) - Obrigatrio a partir de 03/07/2000
    Valor do documento (10 posies) - Sem vrgula decimal e com ZEROS  esquerda

    A segunda parte do cdigo de barras  um campo livre, que varia de acordo
    com o banco. Esse campo livre ser calculado por esta funo (que voc dever
    alterar de acordo com as informaes fornecidas pelo banco).
   }

   {Segunda parte do cdigo de barras - Campo livre - Varia de acordo com o banco}

   with ATitulo do
   begin
      ANossoNumero := Formatar(NossoNumero,8,false,'0');
      ANumeroConta := Formatar(Cedente.ContaBancaria.NumeroConta,11,false,'0');
   end;
   ACampoLivre := ANossoNumero + ANumeroConta + '2' + '021';

   Result := ACampoLivre + DigitosChaveASBACE(ACampoLivre);
end;

procedure TgbBanco021.FormatarBoleto(ATitulo: TgbTitulo; var AAgenciaCodigoCedente, ANossoNumero, ACarteira, AEspecieDocumento: string);
begin
   with ATitulo do
   begin
      AAgenciaCodigoCedente := Formatar(Cedente.ContaBancaria.CodigoAgencia,4,false,'0') + '/' + Formatar(Cedente.CodigoCedente,11,false,'0') + '-' + Cedente.DigitoCodigoCedente;
      ANossoNumero := Formatar(NossoNumero,8,false,'0') + '-' + DigitoNossoNumero;
      ACarteira := Formatar(Carteira,1,false,'0');
      AEspecieDocumento := '';
   end;
end;

{$IFNDEF VER120}

function  TgbBanco021.GerarRemessa(var ACobranca: TgbCobranca; var Remessa: TStringList) : boolean;
begin
   Result := FALSE;
   Raise Exception.CreateFmt('Gerao de arquivo remessa no est disponvel para o banco %s - %s',[CodigoBanco, NomeBanco]);
end;

function TgbBanco021.LerRetorno(var ACobranca: TgbCobranca; Retorno: TStringList) : boolean;
begin
   Result := FALSE;
   Raise Exception.CreateFmt('Processamento de arquivo retorno no est disponvel para o banco %s - %s',[CodigoBanco, NomeBanco]);
end;

{$ENDIF}

initialization
RegisterClass(TgbBanco021);

end.
