unit DBColorEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, DBCtrls,DBGrids,db;

type
  TDBColorEdit = class(TDBEdit)
  private
    MyDBGrid1: TDBGrid;
    FForm:TForm;
    FButton:TButton;
    FAuthor:string;
    FFocusColor:TColor;
    FNotFound :string;
    FInputText:string;
    FButtonCaption:string;
    procedure OxLocate(var message:TMessage);message  WM_LBUTTONDBLCLK;
    procedure OxFocus(var Message: TMessage); message CM_ENTER;
    procedure OxNotFocus(var Message: TMessage); message CM_EXIT;
    procedure MyButtonClick(Sender: TObject);
    { Private declarations }
  protected
    { Protected declarations }
  public
    constructor Create (AOwner:Tcomponent);override;
    destructor Destroy;override;
    { Public declarations }
  published
    property FocusColor:TColor read FFocusColor write FFocusColor default clInfoBk;
    property NotFoundText:String read FNotFound write FNotFound ;
    property InputText:String read FInputText write FInputText;
    property ButtonCaption:String read FButtonCaption write FButtonCaption;

      { Published declarations }
  end;

procedure Register;

implementation

var
  Renk:TColor;

procedure Register;
begin
RegisterComponents('Data Controls', [TDBColorEdit]);
end;

constructor TDBColorEdit.Create (AOwner:TComponent);
begin
inherited;
FAuthor := 'Oxygen';
FFocusColor := clInfoBk;
FNotFound := 'Not Found';
FInputText := 'Please Enter the Search Criteria';
FButtonCaption := 'Ok';
end;


procedure TDBColorEdit.OxFocus(var message:TMessage);
begin
Renk:=Self.Color;
Self.Color:=FFocusColor;
end;

procedure TDBColorEdit.OxNotFocus(var message:TMessage);
begin
Self.Color:=Renk;
end;

procedure TDBColorEdit.OxLocate(var message:TMessage);
var
search:string;
i:SmallInt;
begin
Search:=Inputbox('',FInputText,'');
if Search <> '' then
   begin
   try
     Self.DataSource.DataSet.Filter:=self.DataField+'= '+#39+Search+#39;
     Self.DataSource.DataSet.Filtered:=true;
     if Self.DataSource.DataSet.RecordCount <> 0 then
        begin
        FForm:=TForm.Create(nil);
        FForm.Parent := nil;
        FForm.Position := poScreenCenter;
        FForm.BorderStyle := bsDialog;
        FForm.BorderIcons := [];
        FForm.Height := 210;
        FForm.Width := 500;
        MyDBGrid1 := Tdbgrid.Create(FForm) ;
        MyDBGrid1.parent := FForm;
        MyDBGrid1.readonly := true;
        MyDBGrid1.Height := 145;
        MyDBGrid1.Width := 492;
        MyDBGrid1.DataSource := Self.DataSource;
        MyDBGrid1.Columns.State := csCustomized;
        FButton := TButton.Create(FForm);
        FButton.parent := FForm;
        FButton.Top := 152;
        FButton.Left := 208;
        FButton.Caption := FButtonCaption;
        FButton.OnClick := MyButtonClick;
        FForm.Visible := True;
        //ilk yap
        for i := 0 to Self.DataSource.DataSet.FieldCount -1 do
            begin
            if MyDBGrid1.Columns[i].FieldName= Self.DataField then
               begin
               MyDBGrid1.Columns[i].Index:=0;
               MyDBGrid1.Columns[0].Color:=clInfoBk;
               end;
            end;
        //son
        MyDBGrid1.Visible:=True;
        end
     else
        begin
        ShowMessage(FNotFound);
        Self.DataSource.DataSet.Filtered:=false;
        end;
   except
     Abort;
     end;
   end;
end;

procedure TDBColorEdit.MyButtonClick(Sender: TObject);
var 
MyBookmark: TBookmark;
begin
MyBookmark := self.DataSource.DataSet.GetBookmark;
Self.DataSource.DataSet.Filtered := false;
self.DataSource.DataSet.GotoBookmark(MyBookmark);
self.DataSource.DataSet.FreeBookmark(MyBookmark);
FForm.Release;
end;

destructor TDBColorEdit.Destroy;
begin
inherited Destroy;
end;
end.