unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, DB,
  DBTables, ExtCtrls, WZM_Image, StdCtrls, Mask, DBCtrls, Buttons,
  ToolEdit, RXDBCtrl;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Table1Chave: TAutoIncField;
    Table1NOME: TStringField;
    Table1ENDERECO: TStringField;
    Table1TELEFONE: TStringField;
    Table1DATA: TDateField;
    Table1Carteira: TStringField;
    Table1Valor: TStringField;
    DataSource1: TDataSource;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    Label6: TLabel;
    DBEdit6: TDBEdit;
    Label7: TLabel;
    DBEdit7: TDBEdit;
    WZM_Image1: TWZM_Image;
    DBNavigator1: TDBNavigator;
    SpeedButton2: TSpeedButton;
    SpeedButton1: TSpeedButton;
    DBDateEdit1: TDBDateEdit;
    procedure FormCreate(Sender: TObject);
    procedure DBEdit2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DBEdit7Exit(Sender: TObject);
    procedure DBEdit2Exit(Sender: TObject);
  private
    { Private declarations }
  procedure WMNCHitTest (var Msg: TMessage);
  Message WM_NCHitTest;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.WMNCHitTest(var Msg: TMessage);
begin
        If GetAsyncKeyState (VK_LBUTTON) < 0
                Then
                        Msg.Result := HTCAPTION
                Else
                        Msg.Result := HTCLIENT;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var
 NewTable: TTable;
begin
        If Not (FileExists ('Multa.Db'))
                Then
                        Begin
                                NewTable := TTable.Create (Nil);
                                With NewTable Do
                                        Begin
                                                Active := False;
                                                DatabaseName := ExtractFilePath (ParamStr (0));
                                                TableName := 'Multa.DB';
                                                TableType := ttDefault;
                                                FieldDefs.Clear;
                                                FieldDefs.Add ('Chave', ftAutoInc, 0, True);
                                                FieldDefs.Add ('NOME', ftString, 150, False);
                                                FieldDefs.Add ('ENDERECO', ftString, 150, False);
                                                FieldDefs.Add ('TELEFONE', ftString, 14, False);
                                                FieldDefs.Add ('DATA', ftDate, 0, False);
                                                FieldDefs.Add ('Carteira', ftString, 150, False);
                                                FieldDefs.Add ('Valor', ftString, 30, False);
                                                IndexDefs.Clear;
                                                IndexDefs.Add ('PrimaryIndex', 'Chave', [ixUnique, ixPrimary]);
                                                CreateTable;
                                                AddIndex ('IndNome', 'NOME', [ixCaseInsensitive]);
                                        End;
                                NewTable.Free;
                                Table1.Active := True;
                        End;
end;

procedure TForm1.DBEdit2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
        If Key = VK_RETURN
                Then
                        Perform (Wm_NextDlgCtl, 0, 0);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
        Close;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
        Application.Minimize;
end;

procedure TForm1.DBEdit7Exit(Sender: TObject);
begin
        ShowMessage ('Fala a Verdade..., o Valor  Maior...');
        DBEdit7.Text := '1500';
end;

procedure TForm1.DBEdit2Exit(Sender: TObject);
begin
        Application.MessageBox ('Toma idiota, quem manda no saber dirigir...', '', mb_Ok + mb_IconInformation);
end;

end.
