unit Pickdate;

{**************************************************************************
Formulrio de calendrio
Autor: Reinaldo M.R. Alves
Data: 14/11/96

Descrio:

    Apresenta uma janela com o calendrio.

Propriedades:

    Data: TDateTime => leitura/escrita da data. Apenas run time.

Metodos:

        Exec    => Absoleto
        Execute => Apresenta a janela. Retorna True de clicado OK

Exemplo:

var
   lFCal: TBrDateForm;
begin
try
   lFCal := TBrDateForm.Create(Self);
   if Not lFCal.Execute then Exit;

   editData.Text := DateToStr( lFCal.Data);

finally
       lFCal.Release;
end;
end;
***************************************************************************}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  SysUtils, StdCtrls, Grids, ExtCtrls, DB, DBTables, DBCtrls, Calend;

type
  TBrDateForm = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Calendario1: TDBCalendario;
    Table1: TTable;
    DataSource1: TDataSource;
    BitBtn3: TBitBtn;
    procedure Calendario1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    procedure SetDate(Data: TDateTime);
    function GetDate: TDateTime;
  public
    function Execute: Boolean;
    property Data: TDateTime read GetDate write SetDate;
  end;

var
  BrDateForm: TBrDateForm;

implementation

{$R *.DFM}

uses Mask;

procedure TBrDateForm.SetDate(Data: TDateTime);
var
   Dia,Mes,Ano: Word;
begin
DecodeDate(Data,Ano,Mes,Dia);
if Ano>0 then Calendario1.Data := Data
else Calendario1.Data := Date;
end;

function TBrDateForm.GetDate: TDateTime;
begin
Result := Calendario1.Data;
end;

function TBrDateForm.Execute: Boolean;
begin
Result := ShowModal=mrOK;
end;

procedure TBrDateForm.Calendario1DblClick(Sender: TObject);
begin
ModalResult := mrOK;
end;

procedure TBrDateForm.FormCreate(Sender: TObject);
begin
Table1.DatabaseName := ExtractFilePath(Application.ExeName);
Table1.Open;
end;

procedure TBrDateForm.BitBtn3Click(Sender: TObject);
begin
Calendario1.EditaDia( Calendario1.Data);
end;

end.
