unit Botoes;

{**************************************************************************
TBitBtnXT - TBitBtn extend
Autor: Reinaldo M. R. Alves
Criao: 11/05/96

Propriedades:

KindXT => funciona como a propriedade Kind
***************************************************************************}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TKindXT = (xtCustom, xtGravar, xtNovo, xtExcluir, xtVoltar, xtImprimir,
               xtSair, xtPesquisar);

  TBitBtnXT = class(TBitBtn)
  private
    { Private declarations }
    fKindXT: TKindXT;
    procedure GravaKindXT( Value: TKindXT);
    procedure SetCaption( Value: string);
    procedure SetHint( Value: string);
    procedure SetAntCaption( Value: string);
    procedure SetAntHint( Value: string);
    function ECustom: Boolean;
    function GetCaption: string;
    function GetHint: string;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property KindXT: TKindXT read fKindXT write GravaKindXT;
    property Caption: string read GetCaption write SetCaption stored ECustom;
    property Hint: string read GetHint write SetHint stored ECustom;
    property Glyph stored ECustom;
  end;

procedure Register;

implementation

{$R BOTOES.RES}

procedure Register;
begin
  RegisterComponents('XT', [TBitBtnXT]);
end;

function TBitBtnXT.ECustom: Boolean;
begin
Result := FKindXT=xtCustom;
end;

procedure TBitBtnXT.SetCaption( Value: string);
begin
SetAntCaption(Value);
FKindXT := xtCustom;
end;

procedure TBitBtnXT.SetHint( Value: string);
begin
SetAntHint(Value);
FKindXT := xtCustom;
end;

function TBitBtnXT.GetCaption: string;
begin
Result := TBitBtn(Self).Caption;
end;

function TBitBtnXT.GetHint: string;
begin
Result := TBitBtn(Self).Hint;
end;

procedure TBitBtnXT.SetAntCaption( Value: string);
begin
inherited Caption := Value;
end;

procedure TBitBtnXT.SetAntHint( Value: string);
begin
inherited Hint := Value;
end;

procedure TBitBtnXT.GravaKindXT( Value: TKindXT);
begin
     fKindXT := Value;

     if Value=xtCustom then Exit;

     {Valores comuns a todos}
     NumGlyphs   := 1;

     {Valore especficos}
     case Value of
          xtGravar: begin
                    Glyph.Handle := LoadBitmap( hInstance, 'BXTGRAVAR');
                    SetAntCaption('&Gravar');
                    SetAntHint('Grava o registro que est sendo digitado.');
                    Name := 'cmdGravar'
                    end;
          xtSair: begin
                  Glyph.Handle := LoadBitmap( hInstance, 'BXTSAIR');
                  SetAntCaption('Sair');
                  Cancel := True;
                  SetAntHint('Fecha a janela atual.');
                  Name := 'cmdSair'
                  end;
          xtNovo: begin
                  Glyph.Handle := LoadBitmap( hInstance, 'BXTNOVO');
                  SetAntCaption('&Novo');
                  SetAntHint('Inclui um novo registro.');
                  Name := 'cmdNovo';
                  end;
          xtImprimir: begin
                      Glyph.Handle := LoadBitmap( hInstance, 'BXTIMPRIMIR');
                      SetAntCaption('Im&primir');
                      SetAntHint('Imprimir.');
                      Name := 'cmdImprimir'
                      end;
          xtVoltar: begin
                    Glyph.Handle := LoadBitmap( hInstance, 'BXTVOLTAR');
                    SetAntCaption('&Voltar Dig.');
                    SetAntHint('Cancela a ltima digitao.');
                    Name := 'cmdVoltar'
                    end;
          xtExcluir: begin
                     Glyph.Handle := LoadBitmap( hInstance, 'BXTEXCLUIR');
                     SetAntCaption('&Excluir');
                     SetAntHint('Apaga o registro atual.');
                     Name := 'cmdExcluir'
                     end;
          xtPesquisar: begin
                       Glyph.Handle := LoadBitmap( hInstance, 'BXTPESQUISAR');
                       SetAntCaption('&Pesquisar');
                       SetAntHint('Localiza um registro desejado.');
                       Name := 'cmdPesquisar'
                       end;
     end;
     Invalidate;
end;

end.
